package com.jshx.hisxrjfjlb.service.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hisxrjfjlb.dao.HisxrjfjlbDao;
import com.jshx.hisxrjfjlb.entity.Hisxrjfjlb;
import com.jshx.hisxrjfjlb.service.HisxrjfjlbService;

@Service("hisxrjfjlbService")
public class HisxrjfjlbServiceImpl extends BaseServiceImpl implements HisxrjfjlbService
{
	/**
	 * Dao类
	 */
	@Autowired()
	@Qualifier("hisxrjfjlbDao")
	private HisxrjfjlbDao hisxrjfjlbDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return hisxrjfjlbDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hisxrjfjlb getById(String id)
	{
		return hisxrjfjlbDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Hisxrjfjlb hisxrjfjlb)
	{
		hisxrjfjlbDao.save(hisxrjfjlb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Hisxrjfjlb hisxrjfjlb)
	{
		hisxrjfjlbDao.update(hisxrjfjlb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list = Arrays.asList(ids);

		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects = hisxrjfjlbDao.findHisxrjfjlb(paraMap);

		hisxrjfjlbDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
		String[] idArray = ids.split("\\|");
		if (null != idArray)
		{
			for (String id : idArray)
			{
				if (id != null && !id.trim().equals(""))
					hisxrjfjlbDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Hisxrjfjlb> query(Map<String, Object> map)
	{
		return hisxrjfjlbDao.findHisxrjfjlb(map);
	}
}
