package com.jshx.hisxrjfjlb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hisxrjfjlb.entity.Hisxrjfjlb;
import com.jshx.hisxrjfjlb.dao.HisxrjfjlbDao;

@Component("hisxrjfjlbDao")
public class HisxrjfjlbDaoImpl extends BaseDaoImpl implements HisxrjfjlbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHisxrjfjlbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHisxrjfjlb(Map<String, Object> paraMap){
		return this.findListByHqlId("findHisxrjfjlbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hisxrjfjlb getById(String id)
	{
		return (Hisxrjfjlb)this.getObjectById(Hisxrjfjlb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hisxrjfjlb hisxrjfjlb)
	{
		hisxrjfjlb.setId(null);
		this.saveOrUpdateObject(hisxrjfjlb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hisxrjfjlb hisxrjfjlb)
	{
		this.saveOrUpdateObject(hisxrjfjlb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hisxrjfjlb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hisxrjfjlb hisxrjfjlb = (Hisxrjfjlb)this.getObjectById(Hisxrjfjlb.class, id);
		hisxrjfjlb.setDelFlag(1);
		this.saveObject(hisxrjfjlb);
	}
}
