package com.jshx.hisxrjbxxb.web;

import java.io.FileInputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.hibernate.SessionFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.hisxrfymxb.entity.Hisxrfymxb;
import com.jshx.hisxrfymxb.service.HisxrfymxbService;
import com.jshx.hisxrjbxxb.entity.DetailsInfo;
import com.jshx.hisxrjbxxb.entity.Hisxrjbxxb;
import com.jshx.hisxrjbxxb.service.HisxrjbxxbService;
import com.jshx.hisxrjfjlb.entity.Hisxrjfjlb;
import com.jshx.hisxrjfjlb.service.HisxrjfjlbService;

import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

public class HisxrjbxxbAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Hisxrjbxxb hisxrjbxxb = new Hisxrjbxxb();

	/**
	 * 业务类
	 */
	@Autowired
	private HisxrjbxxbService hisxrjbxxbService;
	@Autowired
	private HisxrjfjlbService hisxrjfjlbService;
	@Autowired
	private HisxrfymxbService hisxrfymxbService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;

	private Date queryCommit2TimeStart;

	private Date queryCommit2TimeEnd;

	private Date queryCommit3TimeStart;

	private Date queryCommit3TimeEnd;

	private Date queryAcceptTimeStart;

	private Date queryAcceptTimeEnd;

	private Date queryArea1TimeStart;

	private Date queryArea1TimeEnd;

	private Date queryArea2TimeStart;

	private Date queryArea2TimeEnd;

	private Date queryCommit1TimeStart;

	private Date queryCommit1TimeEnd;

	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;

	private String acceptNo;

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception
	{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if (pagination == null)
			pagination = new Pagination(this.getRequest());

		if (null != hisxrjbxxb)
		{
			// 设置查询条件，开发人员可以在此增加过滤条件
			if ((null != hisxrjbxxb.getAcceptNo()) && (0 < hisxrjbxxb.getAcceptNo().trim().length()))
			{
				paraMap.put("acceptNo", "%" + hisxrjbxxb.getAcceptNo().trim() + "%");
			}

			if (null != queryAcceptTimeStart)
			{
				paraMap.put("startAcceptTime", queryAcceptTimeStart);
			}

			if (null != queryAcceptTimeEnd)
			{
				paraMap.put("endAcceptTime", queryAcceptTimeEnd);
			}
			if ((null != hisxrjbxxb.getDwdm()) && (0 < hisxrjbxxb.getDwdm().trim().length()))
			{
				paraMap.put("dwdm", "%" + hisxrjbxxb.getDwdm().trim() + "%");
			}
			
			if ((null != hisxrjbxxb.getZsjxdbh()) && (0 < hisxrjbxxb.getZsjxdbh().trim().length()))
			{
				paraMap.put("zsjxdbh", "%" + hisxrjbxxb.getZsjxdbh().trim() + "%");
			}

			
			if ((null != hisxrjbxxb.getBuildDepartment()) && (0 < hisxrjbxxb.getBuildDepartment().trim().length()))
			{
				paraMap.put("buildDepartment", "%" + hisxrjbxxb.getBuildDepartment().trim() + "%");
			}
			
			if ((null != hisxrjbxxb.getCaseNo()) && (0 < hisxrjbxxb.getCaseNo().trim().length()))
			{
				paraMap.put("caseNo", "%" + hisxrjbxxb.getCaseNo().trim() + "%");
			}
			
			
			if ((null != hisxrjbxxb.getFileNo()) && (0 < hisxrjbxxb.getFileNo().trim().length()))
			{
				paraMap.put("fileNo", "%" + hisxrjbxxb.getFileNo().trim() + "%");
			}
			
			
			
			if ((null != hisxrjbxxb.getBuildItem()) && (0 < hisxrjbxxb.getBuildItem().trim().length()))
			{
				paraMap.put("buildItem", "%" + hisxrjbxxb.getBuildItem().trim() + "%");
			}
			
			
			if ((null != hisxrjbxxb.getBuildPlace()) && (0 < hisxrjbxxb.getBuildPlace().trim().length()))
			{
				paraMap.put("buildPlace", "%" + hisxrjbxxb.getBuildPlace().trim() + "%");
			}
			
			
			if ((null != hisxrjbxxb.getCheckArea()) && (0 < hisxrjbxxb.getCheckArea()))
			{
				paraMap.put("checkArea",  hisxrjbxxb.getCheckArea());
			}
			
			
			if ((null != hisxrjbxxb.getProcessType()) && (0 < hisxrjbxxb.getProcessType().trim().length()))
			{
				paraMap.put("processType", "%" + hisxrjbxxb.getProcessType().trim() + "%");
			}
			
	
			if ((null != hisxrjbxxb.getPolicyType()) && (0 < hisxrjbxxb.getPolicyType().trim().length()))
			{
				paraMap.put("policyType", "%" + hisxrjbxxb.getPolicyType().trim() + "%");
			}
	
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class, new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		// 此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class, new CodeJsonValueProcessor(codeMap));
		final String filter = "id|commit2Time|commit3Time|commit3User|dwdm|zsjxdbh|acceptNo|fileNo|processType|checkArea|buildDepartment|departmentPlace|zoneType1|tractType1|zoneType2|tractType2|policyType|departmentType|establishmentCheckType|acceptTime|buildItem|buildPlace|guarantyFloor|guarantyEstablishmentType|guarantyDelay|linkMan|linkTelephone|isAuto|operator|infoFlag|infoProcess|processType1|operatorname|messageNo|processType2|area1Time|area1Operator|area2Time|area2Operator|passDepartment|licenceBase|licenceArchitecture|changeFloor|changeEstablishmentType|layoutPass|password1|checkbackFlag|checkbackTimes|caseNo|zhFlag|xxdjbh|printNum|commit1User|commit1Time|commit2User|";
		if (filter != null && filter.length() > 1)
		{
			config.setJsonPropertyFilter(new PropertyFilter()
			{
				public boolean apply(Object source, String name, Object value)
				{
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = hisxrjbxxbService.findByPage(pagination, paraMap);

		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception
	{
		if ((null != hisxrjbxxb) && (null != hisxrjbxxb.getId()))
			hisxrjbxxb = hisxrjbxxbService.getById(hisxrjbxxb.getId());

		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception
	{
		view();
		return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception
	{
		FileInputStream in = null;
		try
		{
			// 设置Blob字段
			setBlobField(in);
		} finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				} catch (Exception ex)
				{
				}
			}
		}

		if ("add".equalsIgnoreCase(this.flag))
		{
			hisxrjbxxb.setDeptId(this.getLoginUserDepartmentId());
			hisxrjbxxb.setDelFlag(0);
			hisxrjbxxbService.save(hisxrjbxxb);
		}
		else
		{
			hisxrjbxxbService.update(hisxrjbxxb);
		}

		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != hisxrjbxxb)
		{
			try
			{
				// 此处将File对象转换成blob对象，并设置到hisxrjbxxb中去

			} catch (Exception ex)
			{
				ex.printStackTrace();
			}
		}
	}

	public String getInfo()
	{
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("acceptNo", acceptNo);
		List<Hisxrjbxxb> cjbxxbs = hisxrjbxxbService.query(map);
		List<Hisxrjfjlb> jfjlbs = hisxrjfjlbService.query(map);
		List<Hisxrfymxb> fymxbs = hisxrfymxbService.query(map);

		for (Hisxrjfjlb hixrxjfjlb : jfjlbs)
		{
			String str = hixrxjfjlb.getPayClass();
			switch (str)
			{
			case "1000":
				hixrxjfjlb.setPayClass("基础设施配套费");
				break;
			case "1100":
				hixrxjfjlb.setPayClass("基础设施配套费");
				break;
			case "2000":
				hixrxjfjlb.setPayClass("缓");
				break;
			case "2100":
				hixrxjfjlb.setPayClass("缓-缴");
				break;
			case "2200":
				hixrxjfjlb.setPayClass("缓-免");
				break;
			case "2300":
				hixrxjfjlb.setPayClass("缓-冲");
				break;
			case "4000":
				hixrxjfjlb.setPayClass("白蚁收费");
				break;
			case "4100":
				hixrxjfjlb.setPayClass("白蚁收费");
				break;
			case "5000":
				hixrxjfjlb.setPayClass("散装水泥");
				break;
			case "5100":
				hixrxjfjlb.setPayClass("散装水泥");
				break;
			case "6100":
				hixrxjfjlb.setPayClass("新墙体发展基金");
				break;
			case "7100":
				hixrxjfjlb.setPayClass("结建人防费");
				break;
			case "8100":
				hixrxjfjlb.setPayClass("教育附加费");
				break;
			default:
				break;
			}
		}

		if (fymxbs != null && fymxbs.size() != 0)
		{
			String type = fymxbs.get(0).getTernType();
			if (type != null)
			{
				switch (type.trim())
				{
				case "1":
					fymxbs.get(0).setTernType("1|半年");
				case "2":
					fymxbs.get(0).setTernType("2|一年");
				case "3":
					fymxbs.get(0).setTernType("3|长期");
				case "4":
					fymxbs.get(0).setTernType("4|再一次");
				case "5":
					fymxbs.get(0).setTernType("5|在两次");
				case "6":
					fymxbs.get(0).setTernType("6|再三次");
				}
			}
		}

		DetailsInfo detailsInfo = new DetailsInfo();
		detailsInfo.setHisxrjfjlbs(jfjlbs);
		if (fymxbs != null && fymxbs.size() != 0)
			BeanUtils.copyProperties(fymxbs.get(0), detailsInfo);
		if (cjbxxbs != null && cjbxxbs.size() != 0)
			BeanUtils.copyProperties(cjbxxbs.get(0), detailsInfo);

		setRequestAttribute("detailsInfo", detailsInfo);

		return SUCCESS;
	}

	/**
	 * 删除信息
	 */
	public String delete() throws Exception
	{
		try
		{
			hisxrjbxxbService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		} catch (Exception e)
		{
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}

	public String getAcceptNo()
	{
		return acceptNo;
	}

	public void setAcceptNo(String acceptNo)
	{
		this.acceptNo = acceptNo;
	}

	public String getIds()
	{
		return ids;
	}

	public void setIds(String ids)
	{
		this.ids = ids;
	}

	public Pagination getPagination()
	{
		return pagination;
	}

	public void setPagination(Pagination pagination)
	{
		this.pagination = pagination;
	}

	public Hisxrjbxxb getHisxrjbxxb()
	{
		return this.hisxrjbxxb;
	}

	public void setHisxrjbxxb(Hisxrjbxxb hisxrjbxxb)
	{
		this.hisxrjbxxb = hisxrjbxxb;
	}

	public String getFlag()
	{
		return flag;
	}

	public void setFlag(String flag)
	{
		this.flag = flag;
	}

	public Date getQueryCommit2TimeStart()
	{
		return this.queryCommit2TimeStart;
	}

	public void setQueryCommit2TimeStart(Date queryCommit2TimeStart)
	{
		this.queryCommit2TimeStart = queryCommit2TimeStart;
	}

	public Date getQueryCommit2TimeEnd()
	{
		return this.queryCommit2TimeEnd;
	}

	public void setQueryCommit2TimeEnd(Date queryCommit2TimeEnd)
	{
		this.queryCommit2TimeEnd = queryCommit2TimeEnd;
	}

	public Date getQueryCommit3TimeStart()
	{
		return this.queryCommit3TimeStart;
	}

	public void setQueryCommit3TimeStart(Date queryCommit3TimeStart)
	{
		this.queryCommit3TimeStart = queryCommit3TimeStart;
	}

	public Date getQueryCommit3TimeEnd()
	{
		return this.queryCommit3TimeEnd;
	}

	public void setQueryCommit3TimeEnd(Date queryCommit3TimeEnd)
	{
		this.queryCommit3TimeEnd = queryCommit3TimeEnd;
	}

	public Date getQueryAcceptTimeStart()
	{
		return this.queryAcceptTimeStart;
	}

	public void setQueryAcceptTimeStart(Date queryAcceptTimeStart)
	{
		this.queryAcceptTimeStart = queryAcceptTimeStart;
	}

	public Date getQueryAcceptTimeEnd()
	{
		return this.queryAcceptTimeEnd;
	}

	public void setQueryAcceptTimeEnd(Date queryAcceptTimeEnd)
	{
		this.queryAcceptTimeEnd = queryAcceptTimeEnd;
	}

	public Date getQueryArea1TimeStart()
	{
		return this.queryArea1TimeStart;
	}

	public void setQueryArea1TimeStart(Date queryArea1TimeStart)
	{
		this.queryArea1TimeStart = queryArea1TimeStart;
	}

	public Date getQueryArea1TimeEnd()
	{
		return this.queryArea1TimeEnd;
	}

	public void setQueryArea1TimeEnd(Date queryArea1TimeEnd)
	{
		this.queryArea1TimeEnd = queryArea1TimeEnd;
	}

	public Date getQueryArea2TimeStart()
	{
		return this.queryArea2TimeStart;
	}

	public void setQueryArea2TimeStart(Date queryArea2TimeStart)
	{
		this.queryArea2TimeStart = queryArea2TimeStart;
	}

	public Date getQueryArea2TimeEnd()
	{
		return this.queryArea2TimeEnd;
	}

	public void setQueryArea2TimeEnd(Date queryArea2TimeEnd)
	{
		this.queryArea2TimeEnd = queryArea2TimeEnd;
	}

	public Date getQueryCommit1TimeStart()
	{
		return this.queryCommit1TimeStart;
	}

	public void setQueryCommit1TimeStart(Date queryCommit1TimeStart)
	{
		this.queryCommit1TimeStart = queryCommit1TimeStart;
	}

	public Date getQueryCommit1TimeEnd()
	{
		return this.queryCommit1TimeEnd;
	}

	public void setQueryCommit1TimeEnd(Date queryCommit1TimeEnd)
	{
		this.queryCommit1TimeEnd = queryCommit1TimeEnd;
	}

}
