package com.jshx.hisxrhjkb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hisxrhjkb.entity.Hisxrhjkb;
import com.jshx.hisxrhjkb.dao.HisxrhjkbDao;

@Component("hisxrhjkbDao")
public class HisxrhjkbDaoImpl extends BaseDaoImpl implements HisxrhjkbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHisxrhjkbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHisxrhjkb(Map<String, Object> paraMap){
		return this.findListByHqlId("findHisxrhjkbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hisxrhjkb getById(String id)
	{
		return (Hisxrhjkb)this.getObjectById(Hisxrhjkb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hisxrhjkb hisxrhjkb)
	{
		hisxrhjkb.setId(null);
		this.saveOrUpdateObject(hisxrhjkb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hisxrhjkb hisxrhjkb)
	{
		this.saveOrUpdateObject(hisxrhjkb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hisxrhjkb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hisxrhjkb hisxrhjkb = (Hisxrhjkb)this.getObjectById(Hisxrhjkb.class, id);
		hisxrhjkb.setDelFlag(1);
		this.saveObject(hisxrhjkb);
	}
}
