package com.jshx.hisxlhjkb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hisxlhjkb.entity.Hisxlhjkb;
import com.jshx.hisxlhjkb.dao.HisxlhjkbDao;

@Component("hisxlhjkbDao")
public class HisxlhjkbDaoImpl extends BaseDaoImpl implements HisxlhjkbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHisxlhjkbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHisxlhjkb(Map<String, Object> paraMap){
		return this.findListByHqlId("findHisxlhjkbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hisxlhjkb getById(String id)
	{
		return (Hisxlhjkb)this.getObjectById(Hisxlhjkb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hisxlhjkb hisxlhjkb)
	{
		hisxlhjkb.setId(null);
		this.saveOrUpdateObject(hisxlhjkb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hisxlhjkb hisxlhjkb)
	{
		this.saveOrUpdateObject(hisxlhjkb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hisxlhjkb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hisxlhjkb hisxlhjkb = (Hisxlhjkb)this.getObjectById(Hisxlhjkb.class, id);
		hisxlhjkb.setDelFlag(1);
		this.saveObject(hisxlhjkb);
	}
}
