package com.jshx.hissfspjlb.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hissfspjlb.dao.HissfspjlbDao;
import com.jshx.hissfspjlb.entity.Hissfspjlb;
import com.jshx.hissfspjlb.service.HissfspjlbService;

@Service("hissfspjlbService")
public class HissfspjlbServiceImpl extends BaseServiceImpl implements HissfspjlbService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("hissfspjlbDao")
	private HissfspjlbDao hissfspjlbDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return hissfspjlbDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hissfspjlb getById(String id)
	{
		return hissfspjlbDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Hissfspjlb hissfspjlb)
	{
		hissfspjlbDao.save(hissfspjlb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Hissfspjlb hissfspjlb)
	{
		hissfspjlbDao.update(hissfspjlb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=hissfspjlbDao.findHissfspjlb(paraMap);
		
		hissfspjlbDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    hissfspjlbDao.deleteWithFlag(id);
			}
		}
	}
}
