package com.jshx.hissfcjbxxb.service.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hissfcjbxxb.dao.HissfcjbxxbDao;
import com.jshx.hissfcjbxxb.entity.Hissfcjbxxb;
import com.jshx.hissfcjbxxb.service.HissfcjbxxbService;

@Service("hissfcjbxxbService")
public class HissfcjbxxbServiceImpl extends BaseServiceImpl implements HissfcjbxxbService
{
	/**
	 * Dao类
	 */
	@Autowired()
	@Qualifier("hissfcjbxxbDao")
	private HissfcjbxxbDao hissfcjbxxbDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return hissfcjbxxbDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hissfcjbxxb getById(String id)
	{
		return hissfcjbxxbDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Hissfcjbxxb hissfcjbxxb)
	{
		hissfcjbxxbDao.save(hissfcjbxxb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Hissfcjbxxb hissfcjbxxb)
	{
		hissfcjbxxbDao.update(hissfcjbxxb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list = Arrays.asList(ids);

		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects = hissfcjbxxbDao.findHissfcjbxxb(paraMap);

		hissfcjbxxbDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
		String[] idArray = ids.split("\\|");
		if (null != idArray)
		{
			for (String id : idArray)
			{
				if (id != null && !id.trim().equals(""))
					hissfcjbxxbDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Hissfcjbxxb> query(Map<String, Object> map)
	{
		// TODO Auto-generated method stub
		return hissfcjbxxbDao.findHissfcjbxxb(map);
	}
}
