package com.jshx.hishxspjlb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hishxspjlb.entity.Hishxspjlb;
import com.jshx.hishxspjlb.dao.HishxspjlbDao;

@Component("hishxspjlbDao")
public class HishxspjlbDaoImpl extends BaseDaoImpl implements HishxspjlbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHishxspjlbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHishxspjlb(Map<String, Object> paraMap){
		return this.findListByHqlId("findHishxspjlbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hishxspjlb getById(String id)
	{
		return (Hishxspjlb)this.getObjectById(Hishxspjlb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hishxspjlb hishxspjlb)
	{
		hishxspjlb.setId(null);
		this.saveOrUpdateObject(hishxspjlb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hishxspjlb hishxspjlb)
	{
		this.saveOrUpdateObject(hishxspjlb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hishxspjlb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hishxspjlb hishxspjlb = (Hishxspjlb)this.getObjectById(Hishxspjlb.class, id);
		hishxspjlb.setDelFlag(1);
		this.saveObject(hishxspjlb);
	}
}
