package com.jshx.hishxfymxb.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.hishxfymxb.entity.Hishxfymxb;
import com.jshx.hishxfymxb.service.HishxfymxbService;

public class HishxfymxbAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Hishxfymxb hishxfymxb = new Hishxfymxb();

	/**
	 * 业务类
	 */
	@Autowired
	private HishxfymxbService hishxfymxbService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	
	private Date queryCheckTimeStart;

	private Date queryCheckTimeEnd;

	private Date queryMatureTimeStart;

	private Date queryMatureTimeEnd;

	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != hishxfymxb){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != hishxfymxb.getAcceptNo()) && (0 < hishxfymxb.getAcceptNo().trim().length())){
				paraMap.put("acceptNo", "%" + hishxfymxb.getAcceptNo().trim() + "%");
			}

			if ((null != hishxfymxb.getDwdm()) && (0 < hishxfymxb.getDwdm().trim().length())){
				paraMap.put("dwdm", "%" + hishxfymxb.getDwdm().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|acceptNo|fee0001|fee0002|fee0003|checkTime|lateFee|matureTime|ternType|infoFlag|linkMan|linkTelephone|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = hishxfymxbService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != hishxfymxb)&&(null != hishxfymxb.getId()))
			hishxfymxb = hishxfymxbService.getById(hishxfymxb.getId());
		
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		if ("add".equalsIgnoreCase(this.flag)){
			hishxfymxb.setDeptId(this.getLoginUserDepartmentId());
			hishxfymxb.setDelFlag(0);
			hishxfymxbService.save(hishxfymxb);
		}else{
			hishxfymxbService.update(hishxfymxb);
		}
		
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != hishxfymxb)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到hishxfymxb中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			hishxfymxbService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Hishxfymxb getHishxfymxb(){
		return this.hishxfymxb;
	}

	public void setHishxfymxb(Hishxfymxb hishxfymxb){
		this.hishxfymxb = hishxfymxb;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }
       
    
	public Date getQueryCheckTimeStart(){
		return this.queryCheckTimeStart;
	}

	public void setQueryCheckTimeStart(Date queryCheckTimeStart){
		this.queryCheckTimeStart = queryCheckTimeStart;
	}

	public Date getQueryCheckTimeEnd(){
		return this.queryCheckTimeEnd;
	}

	public void setQueryCheckTimeEnd(Date queryCheckTimeEnd){
		this.queryCheckTimeEnd = queryCheckTimeEnd;
	}

	public Date getQueryMatureTimeStart(){
		return this.queryMatureTimeStart;
	}

	public void setQueryMatureTimeStart(Date queryMatureTimeStart){
		this.queryMatureTimeStart = queryMatureTimeStart;
	}

	public Date getQueryMatureTimeEnd(){
		return this.queryMatureTimeEnd;
	}

	public void setQueryMatureTimeEnd(Date queryMatureTimeEnd){
		this.queryMatureTimeEnd = queryMatureTimeEnd;
	}

}
