package com.jshx.hishxfymxb.service.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hishxfymxb.dao.HishxfymxbDao;
import com.jshx.hishxfymxb.entity.Hishxfymxb;
import com.jshx.hishxfymxb.service.HishxfymxbService;

@Service("hishxfymxbService")
public class HishxfymxbServiceImpl extends BaseServiceImpl implements HishxfymxbService
{
	/**
	 * Dao类
	 */
	@Autowired()
	@Qualifier("hishxfymxbDao")
	private HishxfymxbDao hishxfymxbDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return hishxfymxbDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hishxfymxb getById(String id)
	{
		return hishxfymxbDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Hishxfymxb hishxfymxb)
	{
		hishxfymxbDao.save(hishxfymxb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Hishxfymxb hishxfymxb)
	{
		hishxfymxbDao.update(hishxfymxb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list = Arrays.asList(ids);

		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects = hishxfymxbDao.findHishxfymxb(paraMap);

		hishxfymxbDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
		String[] idArray = ids.split("\\|");
		if (null != idArray)
		{
			for (String id : idArray)
			{
				if (id != null && !id.trim().equals(""))
					hishxfymxbDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Hishxfymxb> query(Map<String, Object> map)
	{
		return hishxfymxbDao.findHishxfymxb(map);
	}
}
