package com.jshx.fymxb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.fymxb.entity.Fymxb;
import com.jshx.fymxb.dao.FymxbDao;

@Component("fymxbDao")
public class FymxbDaoImpl extends BaseDaoImpl implements FymxbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findFymxbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findFymxb(Map<String, Object> paraMap){
		return this.findListByHqlId("findFymxbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Fymxb getById(String id)
	{
		return (Fymxb)this.getObjectById(Fymxb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Fymxb fymxb)
	{
		fymxb.setId(null);
		this.saveOrUpdateObject(fymxb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Fymxb fymxb)
	{
		this.saveOrUpdateObject(fymxb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Fymxb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Fymxb fymxb = (Fymxb)this.getObjectById(Fymxb.class, id);
		fymxb.setDelFlag(1);
		this.saveObject(fymxb);
	}
}
