package com.jshx.fawen.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.fawen.dao.FawenDao;
import com.jshx.fawen.entity.Fawen;
import com.jshx.fawen.service.FawenService;

@Service("fawenService")
public class FawenServiceImpl extends BaseServiceImpl implements FawenService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("fawenDao")
	private FawenDao fawenDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return fawenDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Fawen getById(String id)
	{
		return fawenDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Fawen fawen)
	{
		fawenDao.save(fawen);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Fawen fawen)
	{
		fawenDao.update(fawen);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=fawenDao.findFawen(paraMap);
		
		fawenDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    fawenDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public Pagination findMailSendByPage(Pagination pagination, Map<String, Object> paraMap) {
		
		return fawenDao.findMailSendByPage(pagination,paraMap);
	}
}
