package com.jshx.fawen.service.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.fawen.dao.FawenReceiveinfoDao;
import com.jshx.fawen.entity.FawenReceiveinfo;
import com.jshx.fawen.service.FawenReceiveinfoService;


@Service("fawenReceiveinfoService")
public class FawenReceiveinfoServiceImpl extends BaseServiceImpl implements FawenReceiveinfoService
{
	/**
	 * Dao类
	 */
	@Resource
	@Qualifier("fawenReceiveinfoDao")
	private FawenReceiveinfoDao fawenReceiveinfoDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return fawenReceiveinfoDao.findByPage(page, paraMap);
	}

	
	@Override
	public List findByList(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return fawenReceiveinfoDao.findOaReceiveinfo(paraMap);
	}
	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public FawenReceiveinfo getById(String id)
	{
		return fawenReceiveinfoDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(FawenReceiveinfo oaReceiveinfo)
	{
		fawenReceiveinfoDao.save(oaReceiveinfo);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(FawenReceiveinfo oaReceiveinfo)
	{
		fawenReceiveinfoDao.update(oaReceiveinfo);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=fawenReceiveinfoDao.findOaReceiveinfo(paraMap);
		
		fawenReceiveinfoDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
			    	fawenReceiveinfoDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Object> queryQianshouList(Map<String, String> paramMap) {
		// TODO Auto-generated method stub
		return fawenReceiveinfoDao.queryQianshouList(paramMap);
	}
	
	
	public FawenReceiveinfo oaReceiveinfo_recieverList(Map<String, String> paramMap) {
		FawenReceiveinfo info =	(FawenReceiveinfo) fawenReceiveinfoDao.findObjectByFieldsMap(FawenReceiveinfo.class,paramMap);
		return info;
	}



	@Override
	public void deleteByEmailId(Map<String, Object> map) {
		fawenReceiveinfoDao.deleteByEmailId(map);
		
	}


	@Transactional
	public void saveCollection(Collection<FawenReceiveinfo> receiveList) {
		// TODO Auto-generated method stub
		fawenReceiveinfoDao.saveAllOrUpdateAll(receiveList);
	}


	@Override
	public List findnotReadInfo(Map<String, String> paramMap) {
		return fawenReceiveinfoDao.findnotReadInfo(paramMap);
	}

}
