package com.jshx.fawen.service;

import java.util.List;
import java.util.Map;

import com.jshx.core.base.service.BaseService;
import com.jshx.core.base.vo.Pagination;
import com.jshx.fawen.entity.FawenAttach;


public interface FawenAttachService extends BaseService
{

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public FawenAttach getById(String id);
	/**
	 * 根据附送材料查询材料序号
	 * @param fscl
	 * @return clno
	 */
	public String getByFscl(String fscl,String xmtype);
	public String getByFscl(String fscl);
	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(FawenAttach model);

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(FawenAttach model);

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	public void delete(String[] ids);

	
	public void delete(Map<String, Object> paramsMap);
	
	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	public void deleteWithFlag(String ids);

	/**
	 * 根据模板ID取相应的附件
	 * @param paramsMap
	 * @return
	 * 李荣
	 */
	public List<FawenAttach> queryAttachListByTempleId(
			Map<String, String> paramsMap);
	
	/**
	 * 根据模板ID取相应的附件,及上传人姓名
	 * @param paramsMap
	 * @return
	 * 李荣
	 */
	public List<FawenAttach> queryFawenAttachListByTempleId(
			Map<String, String> paramsMap);
	
	/**
	 * 根据模板ID取相应的附件,及上传人姓名
	 * @param paramsMap
	 * @return
	 * 李荣
	 */
	public List<FawenAttach> queryShouwenAttachListByTempleId(
			Map<String, String> paramsMap);
	
	/**
	 * 查询附件信息
	 * @param map 参数条件
	 * @return
	 */
	public List findOaAttachByMap(Map map);
}
