package com.jshx.fawen.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.jshx.core.base.entity.BaseModel;


/**
 * 实体类模板（目前仅适配MS-SQLServer数据库）
 * @author
 *
 */
@SuppressWarnings("serial")
@Entity
@Table(name="FAWEN_RECEIVEINFO")
public class FawenReceiveinfo extends BaseModel
{
	/**
	 * 部门代码
	 */
	private String deptId;

	/**
	 * 删除标记
	 */
	private Integer delFlag;

	
	/**
	 * 邮件标识
	 */
	private String inneremailid;

	/**
	 * 接收人
	 */
	private String receiveuserid;

	/**
	 * 接收状态
	 */
	private String receivestatus;



	/**
	 * 针对同一邮件的多个收件人的排序序号
	 * 新增字段 GY-UPDATE 2014-05-16
	 */
	private Integer infoIndex; 

	@Column
	public String getDeptId()
	{
		return deptId;
	}

	public void setDeptId(String deptId)
	{
		this.deptId = deptId;
	}

	@Column
	public Integer getDelFlag()
	{
		return delFlag;
	}

	public void setDelFlag(Integer delFlag)
	{
		this.delFlag = delFlag;
	}

	
	@Column(name="INNEREMAILID")
	public String getInneremailid()
	{
		return this.inneremailid;
	}

	public void setInneremailid(String inneremailid)
	{
		this.inneremailid = inneremailid;
	}

	@Column(name="RECEIVEUSERID")
	public String getReceiveuserid()
	{
		return this.receiveuserid;
	}

	public void setReceiveuserid(String receiveuserid)
	{
		this.receiveuserid = receiveuserid;
	}

	@Column(name="RECEIVESTATUS")
	public String getReceivestatus()
	{
		return this.receivestatus;
	}

	public void setReceivestatus(String receivestatus)
	{
		this.receivestatus = receivestatus;
	}


	

	@Column(name="INFO_INDEX")
	public Integer getInfoIndex()
	{
		return infoIndex;
	}

	public void setInfoIndex(Integer infoIndex)
	{
		this.infoIndex = infoIndex;
	}
}
