package com.jshx.elicense.web;

import com.jshx.common.utils.Constant;
import com.jshx.common.utils.FileUtils;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.core.utils.DateUtil;
import com.jshx.core.utils.StringUtil;
import com.jshx.core.utils.Struts2Util;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.elicense.entity.ELicense;
import com.jshx.elicense.entity.ELicenseFile;
import com.jshx.elicense.service.ELicenseFileService;
import com.jshx.elicense.service.ELicenseService;
import com.jshx.elicense.util.RSAEncrypt;
import com.jshx.elicense.util.RSASignature;
import com.jshx.elicense.util.Util;
import com.jshx.jktzs.entity.Jktzs;
import com.jshx.jktzs.service.JktzsService;
import com.jshx.module.admin.entity.CodeValue;
import com.jshx.module.admin.service.CodeService;
import com.jshx.spjkjl.entity.Spjkjl;
import com.jshx.spjlb.entity.Spjlb;
import com.jshx.spjlb.service.SpjlbService;
import com.jshx.xmdrb.service.GenericManager;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.zsdw.service.ZsdwService;
import com.jshx.zzhxm.entity.Zzhxm;
import com.jshx.zzhxm.entity.ZzhxmJktzs;
import com.jshx.zzhxm.entity.ZzhxmSfxx;
import com.jshx.zzhxm.service.ZzhxmJktzsService;
import com.jshx.zzhxm.service.ZzhxmService;
import com.jshx.zzhxm.service.ZzhxmSfxxService;
import net.sf.ezmorph.object.DateMorpher;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.JSONUtils;
import net.sf.json.util.PropertyFilter;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.hibernate.exception.ConstraintViolationException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataIntegrityViolationException;

import java.io.*;
import java.text.SimpleDateFormat;
import java.util.*;

public class ELicenseAction extends BaseAction {

    /**
     * 主键ID列表，用于接收页面提交的多条主键ID信息
     */
    private String ids;
    private String id;

    private Date startTerm;
    private Date endTerm;

    private Date startBind;
    private Date endBind;




    private Xmxxb xmxxb = new Xmxxb();
    private ELicense eLicense = new ELicense();
    private List<ELicenseFile> eLicenseFileList = new ArrayList<>();
    private Zzhxm zzhxm = new Zzhxm();
    private ZzhxmJktzs zzhxmJktzs = new ZzhxmJktzs();
    private List<ZzhxmSfxx> zzhxmSfxx = new ArrayList<>();
    private Jktzs jktzs = new Jktzs();

    /**
     * 文件下载
     */
    private String downFileName;// 文件下载下载文件文件名
    private InputStream downFileStream;// 文件下载，被下载文件的输入流

    /**
     * 分页信息
     */
    private Pagination pagination;


    @Autowired
    private ELicenseService eLicenseService;
    @Autowired
    private ELicenseFileService eLicenseFileService;
    @Autowired
    private ZsdwService zsdwService;
    @Autowired
    private SpjlbService spjlbService;
    @Autowired
    private XmxxbService xmxxbService;
    @Autowired
    private ZzhxmService zzhxmService;
    @Autowired
    private ZzhxmJktzsService zzhxmJktzsService;
    @Autowired
    private ZzhxmSfxxService zzhxmSfxxService;
    @Autowired
    private JktzsService jktzsService;

    @Autowired
    private GenericManager genericManager;

    @Autowired
    private CodeService codeService;

    @Autowired()
    @Qualifier("sessionFactory")
    private SessionFactory sessionFactory;

    /**
     * 执行查询的方法，返回json数据
     */
    public void list() throws Exception{
        Map<String, Object> paraMap = new HashMap<String, Object>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if(pagination==null)
            pagination = new Pagination(this.getRequest());

        if(null != eLicense){
            //设置查询条件，开发人员可以在此增加过滤条件
            if ((null != eLicense.getCaseNo()) && (0 < eLicense.getCaseNo().trim().length())){
                paraMap.put("caseNo", "%" + eLicense.getCaseNo().trim() + "%");
            }
            if ((null != eLicense.getOrgId()) && (0 < eLicense.getOrgId().trim().length())){
                paraMap.put("orgId", "%" + eLicense.getOrgId().trim() + "%");
            }
            if ((null != eLicense.getOrgName()) && (0 < eLicense.getOrgName().trim().length())){
                paraMap.put("orgName", "%" + eLicense.getOrgName().trim() + "%");
            }
            if ((null != eLicense.getInternalNo()) && (0 < eLicense.getInternalNo().trim().length())){
                paraMap.put("internalNo", "%" + eLicense.getInternalNo().trim() + "%");
            }
            if ((null != eLicense.getDeptYwRegNo()) && (0 < eLicense.getDeptYwRegNo().trim().length())){
                paraMap.put("deptYwRegNo", "%" + eLicense.getDeptYwRegNo().trim() + "%");
            }
            if ((null != eLicense.getDeptYwName()) && (0 < eLicense.getDeptYwName().trim().length())){
                paraMap.put("deptYwName", "%" + eLicense.getDeptYwName().trim() + "%");
            }
            if ((null != eLicense.getSqWay()) && (0 < eLicense.getSqWay().trim().length())){
                paraMap.put("sqWay", "%" + eLicense.getSqWay().trim() + "%");
            }
            if ((null != eLicense.getApplicantName()) && (0 < eLicense.getApplicantName().trim().length())){
                paraMap.put("applicantName", "%" + eLicense.getApplicantName().trim() + "%");
            }
            if ((null != eLicense.getLinkmanName()) && (0 < eLicense.getLinkmanName().trim().length())){
                paraMap.put("linkmanName", "%" + eLicense.getLinkmanName().trim() + "%");
            }
            if ((null != eLicense.getLinkmanMobile()) && (0 < eLicense.getLinkmanMobile().trim().length())){
                paraMap.put("linkmanMobile", "%" + eLicense.getLinkmanMobile().trim() + "%");
            }
            if ((null != eLicense.getProjectType()) && (0 < eLicense.getProjectType().trim().length())){
                paraMap.put("projectType", "%" + eLicense.getProjectType().trim() + "%");
            }
            if ((null != eLicense.getBindFlag()) && (0 < eLicense.getBindFlag().trim().length())){
                if ("1".equals(eLicense.getBindFlag())) {
                    paraMap.put("bindFlag", "1");
                }else {
                    paraMap.put("unbind", "0");
                }
            }
            if ((null != startTerm)){
                startTerm = java.sql.Date.valueOf(sdf.format(startTerm));
                paraMap.put("startTerm",startTerm);
            }
            if ((null != endTerm)){
                Date date = DateUtil.addDaysToDate(endTerm, 1);
                endTerm = java.sql.Date.valueOf(sdf.format(endTerm));
                paraMap.put("endTerm",endTerm);
            }
            if ((null != startBind)){
                startBind = java.sql.Date.valueOf(sdf.format(startBind));
                paraMap.put("startBind",startBind);
            }
            if ((null != endBind)){
//                Date date = DateUtil.addDaysToDate(endBind, 1);
                endBind = java.sql.Date.valueOf(sdf.format(DateUtil.addDaysToDate(endBind, 1)));
                paraMap.put("endBind",endBind);
            }

        }
        JsonConfig config = new JsonConfig();
        config.registerJsonValueProcessor(Date.class,new DateJsonValueProcessor());
        Map<String, String> codeMap = new HashMap<String, String>();
        //此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

        config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap));
        final String filter = "id|createTime|updateTime|delFlag|caseNo|orgId|orgName|deptYwRegNo|deptYwName|transactAffairName|status|dataSource|applicantName|applicantPaperCode|linkmanName|linkmanMobile|applyDate|internalNo|projectType|bindFlag|paymentLinkType|";
        if (filter != null && filter.length() > 1) {
            config.setJsonPropertyFilter(new PropertyFilter() {
                public boolean apply(Object source, String name, Object value) {
                    if (filter.indexOf(name + "|") != -1)
                        return false;
                    else
                        return true;
                }
            });
        }
        pagination = eLicenseService.findByPage(pagination, paraMap);

        convObjectToJson(pagination, config);
    }

    public String eLicenseList() {
        return SUCCESS;
    }
    public String paymentLink() {
        return SUCCESS;
    }

    public String paymentLinkCheck() {
//        System.out.println(111);
        ELicense byId = eLicenseService.getById(eLicense.getId());
        byId.setPaymentLinkType(eLicense.getPaymentLinkType());
        if ("3".equals(eLicense.getPaymentLinkType())) {
            byId.setPaymentLinkDays(eLicense.getPaymentLinkDays());
        }
        eLicenseService.update(byId);
        return RELOAD;
    }


    public String selectDataList() {
        return SUCCESS;
    }
    public String yzsList() {
        return SUCCESS;
    }
    public String ptfList() {
        eLicense = eLicenseService.getById(eLicense.getId());
        return SUCCESS;
    }

    public String view() {
        if (null != eLicense && StringUtils.isNotBlank(eLicense.getId())) {
            eLicense = eLicenseService.getById(eLicense.getId());
            Map<String, Object> fileMap = new HashMap<>();
            fileMap.put("eLicenseId", eLicense.getId());
            eLicenseFileList = eLicenseFileService.findELicenseFileList(fileMap);
            if (!"1".equals(eLicense.getBindFlag())) {
                return SUCCESS;
            }
            if ("1".equals(eLicense.getProjectType()) || "2".equals(eLicense.getProjectType())) {
                //配套费
                jktzs = jktzsService.getById(eLicense.getJktzsId());
                xmxxb = xmxxbService.getById(jktzs.getXmbzj());
            }
            else if ("3".equals(eLicense.getProjectType()) || "4".equals(eLicense.getProjectType())) {
                zzhxmJktzs = zzhxmJktzsService.getById(eLicense.getZzhxmId());
                zzhxm = zzhxmService.getById(zzhxmJktzs.getZzhxmid());
                Map<String, Object> paraMap = new HashMap<>();
                paraMap.put("jfdmwybh", zzhxmJktzs.getJfdmwybh());
                zzhxmSfxx = zzhxmSfxxService.findZzhxmSfxx(paraMap);
            }
        }
        return SUCCESS;
    }


    // 2020-12-8 start ------------------------------------------------------

    /**
     * 检查是否已经绑定
     */
    public void checkBinding() throws IOException {
        if (null != eLicense && StringUtils.isNotBlank(eLicense.getId())) {
            if (null != zzhxmJktzs && StringUtils.isNotBlank(zzhxmJktzs.getId())) {
                if (eLicenseService.hasContacted(zzhxmJktzs.getId(), eLicense.getId())) {
                    this.getResponse().getWriter().println("{\"result\":false}");
                }else {
                    this.getResponse().getWriter().println("{\"result\":true}");
                }
            }
            if (null != jktzs && StringUtils.isNotBlank(jktzs.getId())) {
                if (eLicenseService.hasContacted(jktzs.getId(), eLicense.getId())) {
                    this.getResponse().getWriter().println("{\"result\":false}");
                }else {
                    this.getResponse().getWriter().println("{\"result\":true}");
                }
            }

        }
//        this.getResponse().getWriter().println("{\"result\":false}");
    }

    /**
     * 绑定项目
     * 配套费 一站式 两种
     */
    public void bindingProject() throws IOException {
        if (null != eLicense && StringUtils.isNotBlank(eLicense.getId())) {
            ELicense updateData = eLicenseService.getById(eLicense.getId());
            updateData.setBindTime(new Date());
            // 绑定一站式
            if (null != zzhxmJktzs && StringUtils.isNotBlank(zzhxmJktzs.getId())) {
                updateData.setZzhxmId(zzhxmJktzs.getId());
                updateData.setBindFlag("1");
//                eLicenseService.update(updateData);
                //

                eLicenseService.bindingProject(updateData, 21);
                this.getResponse().getWriter().println("{\"result\":true}");
                return;
            }
            // 绑定配套费
            if (null != jktzs && StringUtils.isNotBlank(jktzs.getId())) {
                updateData.setJktzsId(jktzs.getId());
                updateData.setBindFlag("1");
//                eLicenseService.update(updateData);
                eLicenseService.bindingProject(updateData, 11);
                this.getResponse().getWriter().println("{\"result\":true}");
                return;
            }
        }
        this.getResponse().getWriter().println("{\"result\":false}");
    }

    /**
     * 解绑
     * @throws IOException
     */
    public void unBindingProject() throws IOException {
        if (null != eLicense && StringUtils.isNotBlank(eLicense.getId())) {
            int type = 0;
            ELicense model = eLicenseService.getById(eLicense.getId());
            if ("1".equals(model.getProjectType()) || "2".equals(model.getProjectType())) {
                type = 10;
            }
            if ("3".equals(model.getProjectType()) || "4".equals(model.getProjectType())) {
                type = 20;
            }
//            eLicenseService.update(model);
            eLicenseService.bindingProject(model, type);
            this.getResponse().getWriter().println("{\"result\":true}");
            return;
        }
        this.getResponse().getWriter().println("{\"result\":false}");
    }

    /**
     * 推送建委
     */
    public void pushELience() {
        // TODO
    }




    /**
     * 接收Y报文并判断补正或者推送至内网
     * @return
     */
    public void receiveMsg(){
        String str = "{ \"message\": \"调用失败\",\"code\": \"1000\"}";
        Map<String,Object> returnMap = new HashMap<>();
        try {
            String messageParam = Struts2Util.getRequest().getParameter("message");
            String sign =  Struts2Util.getRequest().getParameter("sign");
            String publicKey =  Struts2Util.getRequest().getParameter("publicKey");

            if(messageParam == null){
                getResponse().setStatus(301);
                System.out.println();
                return;
            }
            if(sign == null){
                getResponse().setStatus(302);
                return;
            }
            if(publicKey == null){
                getResponse().setStatus(303);
                return;
            }
            boolean isSign = false;
            //验签
            try {
                isSign = RSASignature.doCheck(messageParam, sign, publicKey);
            } catch (Exception e) {
                getResponse().setStatus(304);
                logger.error(e.getMessage(), e);
            }
//            if (true) {
            if (isSign) {
                String privateKey = SysPropertiesUtil.getProperty("privateKey");
                System.out.println("**************开始解密********************");
                String message = new String(RSAEncrypt.decrypt(RSAEncrypt.loadPrivateKeyByStr(privateKey), Util.hexStringToBytes(messageParam)), "UTF-8");
                System.out.println("解密出来的message是：" + message);
//                JSONObject jsYResult = JSONObject.fromObject(messageParam);
                JSONObject jsYResult = JSONObject.fromObject(message);
                JSONObject jsHeader = new JSONObject();
                jsHeader = jsYResult.getJSONObject("HEADER");
                JSONObject jsBody = new JSONObject();
                jsBody = jsYResult.getJSONObject("BODY");
                System.out.println("message中的BODY是：" + jsBody);
                String status = jsBody.getString("STATUS");
//				String status = "B";
                System.out.println("此次办件状态结果是：" + status);
                String note = jsBody.getString("NOTE");
                String YIatime = jsHeader.getString("A_TIME");
                String BJ_STATU = jsHeader.getString("BJ_STATU");
                //				String BJ_STATU = "I";         System.out.println("此次办件返回状态是" + BJ_STATU);
                String INTERNAL_NO = jsHeader.getString("INTERNAL_NO");//唯一办件编号
                JsonConfig jsonConfig = new JsonConfig();
                jsonConfig.setRootClass(ELicense.class);
                JSONUtils.getMorpherRegistry().registerMorpher(new DateMorpher(new String[] {"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss"}));
//                ELicense eLicense =(ELicense)JSONObject.toBean(jsBody, jsonConfig);
//                Object o = JSONObject.toBean(jsBody, ELicense.class);
//                Object parse = com.alibaba.fastjson.JSONObject.toJavaObject(jsBody.toString(), ELicense.class);
                com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject(jsBody.toString());

                ELicense model =  com.alibaba.fastjson.JSONObject.parseObject(jsBody.toString(),ELicense.class);
                //设置事项编码
                model.setInternalNo(INTERNAL_NO);
                model.setDelFlag(0);
                model.setBindFlag("0");
                String caseType = checkCaseType(model.getDeptYwRegNo());
                if ("0".equals(caseType)) {
                    str = "{ \"message\": \"调用失败,业务编码有误\",\"code\": \"1000\"}";
                    logger.info("调用失败, 业务编码有误, {}", model.getDeptYwRegNo());
                }else {
                    model.setProjectType(caseType);
                    // 入库
                    eLicenseService.save(model);
                    str = "{ \"message\": \"调用成功\",\"code\": \"200\"}";
                    logger.info("调用成功, {}", model.getId());
                }
            }
            Thread.sleep(1000);
        }catch (DataIntegrityViolationException e) {
            e.printStackTrace();
            str = "{ \"message\": \"调用失败,违反唯一约束\",\"code\": \"1000\"}";
        }catch (Exception e){
            e.printStackTrace();
            logger.error(e.getMessage(),e);
            getResponse().setStatus(305);
        }finally {
            this.outputObjectToJson(str);
        }
    }

    private static final String PTF1 = "11320100012947752P332041700100001"; //直接缴费
    private static final String PTF2 = "11320100012947752P332041700100002"; //减免
//    private static final String YZS1 = "11320100012947752P33220NK06900001"; //综合缴费
    private static final String YZS1 = "11320100012947752P33220NJB6400001"; //综合缴费
//    private static final String YZS2 = "11320100012947752P33220NK12300001"; //综合开票
    private static final String YZS2 = "11320100012947752P33220NJ85800001"; //综合开票

    private String checkCaseType(String internalNo) {
        if (StringUtils.isBlank(internalNo)) {
            return "0";
        }
        List<CodeValue> taxType = codeService.findCodeValueByCode("1");
        // 遍历四种类型匹配当前internalNo返回对应的类型值
        for (CodeValue codeValue : taxType) {
            // 11320100012947752P332041700100001
            String itemCode = codeValue.getItemCode();
            // 1
            String itemValue = codeValue.getItemValue();
            // 11320100012947752P332041700100001
            String itemComment = codeValue.getComment();
            if (internalNo.equalsIgnoreCase(itemComment)) {
                return itemValue;
            }
        }
        return "0";
    }


    // 2020-12-8 end --------------------------------------------------------

    private List<File> file1 ;
    private List<String> file1FileName ;
    private String allFileName;
    private String originFileName;

    private ELicenseFile eLicenseFile = new ELicenseFile();

    private String flag;
    private List<String> showName;


    public String eLicenseFileSave() throws Exception{
        //再上一级目录+新建文件夹名
        String path= SysPropertiesUtil.jdlj(this.getRequest())+ File.separator+ "uploads" + File.separator + Constant.ZSLC_CASE + File.separator;
        // 写到指定的路径中
        JSONObject jsonObject = JSONObject.fromObject(allFileName);
        JSONObject jsonObject1= JSONObject.fromObject(originFileName);
        String fileName = "";
        if(file1!=null) {
            for(int i = 0 ; i < file1.size() ; i++ ) {
                fileName = FileUtils.uploadFile(file1.get(i),file1FileName.get(i), path,UUID.randomUUID().toString());
                String attachType = fileName.substring(fileName.lastIndexOf(".")+1);
                /*paraMapfj.put("attachType", attachType);
                paraMapfj.put("bizrowid", zzhxm.getId()+"-"+zzhxmsfxx.getSfxmmc());//无项目编号主键,先用手动建档的ID
                paraMapfj.put("xmType", "收费信息");

                FawenAttach att = new FawenAttach();
                att.setDelFlag(0);*/
                //					att.setAttachname(file1FileName.get(i));
//                    eLicenseFile.seteLicenseId(eLicense.getId());
                Map<String, Object> paraMap = new HashMap<>();
                paraMap.put("eLicenseId", eLicense.getId());
                paraMap.put("showName", showName.get(i));
                List<ELicenseFile> exist = eLicenseFileService.findELicenseFileList(paraMap);
                // 如果存在则更新,不存在则新增
//                    ELicenseFile model = exist.size()>0?exist.get(0):new ELicenseFile();
                ELicenseFile model = new ELicenseFile();
                if (exist.size()>0) {
                    model = exist.get(0);
                    model.setAttachname(file1FileName.get(i));
                    model.setUrldz(fileName);
                    model.setFilePath(path);
                    model.setAttachType(attachType);
                    eLicenseFileService.update(model);
                }else {
                    model.seteLicenseId(eLicense.getId());
                    model.setDelFlag(0);
                    model.setAttachname(file1FileName.get(i));
                    model.setShowName(showName.get(i));
                    //					att.setAttachpath(fileName);
                    model.setUrldz(fileName);
                    //					att.setBizrowid(zzhxmid+"-"+zzhxmsfxx.getSfxmmc());
                    model.setFilePath(path);
                    //					att.setCreateTime(new Date());
                    model.setAttachType(attachType);
                    //				att.setAttachType(attachType);
                    //				att.setXmType("收费信息");
                    model.setXmType("证照附件");
                    //								att.setWdno(jsonObject1.getString(file1FileName.get(i)));
                    //				fawenAttachService.save(att);
                    eLicenseFileService.save(model);
                }
            }
        }
        return RELOAD;
    }

    /**
     * 下载收费信息附件
     * @return
     */
    public String downloadFile() throws IOException{
        if (StringUtil.isNotEmpty(ids))
        {
            try
            {
                ELicenseFile eLicenseFile = eLicenseFileService.getById(ids);
                if (null != eLicenseFile)
                {
                    // 服务器路径,创建文件夹
                    // 得到当前路径
                    String filename = eLicenseFile.getUrldz();
//					String str = ServletActionContext.getServletContext().getRealPath("");
//					int i = "zhengshouWebRoot".length() + 2;
//					String path = str.substring(1, i);
//					String url = path + SysPropertiesUtil.getProperty("filePath") + File.separator + filename;
                    String cc = this.getRequest().getSession().getServletContext()
                            .getRealPath(File.separator);
                    File ff = new File(cc);
                    String ab=ff.getParent();
                    String path=new File(ab).getParent()+File.separator+ "uploads" + File.separator + Constant.ZSLC_CASE + File.separator+ filename;
//					String path = sfxx.getFilePath() + sfxx.getUrldz();
//					String url = ServletActionContext.getServletContext().getRealPath("/" +SysPropertiesUtil.getProperty("filePath")) +File.separator + filename;
                    String url = path.replaceAll("\\\\", "/").trim();
//					String url = path;
                    File file = new File(url);
                    System.out.println(url);
                    System.out.println(file.exists());
                    // if (file.exists()) {
                    downFileName = java.net.URLEncoder.encode(eLicenseFile.getShowName() + "." + eLicenseFile.getAttachType(), "UTF-8");
                    // downFileStream =
                    // ServletActionContext.getServletContext().getResourceAsStream("uploads/"
                    // + filename);
                    InputStream inputStream = null;
                    byte[] contents = null;
                    try {
                        inputStream = new FileInputStream(file);
                        contents = new byte[inputStream.available()];
                        inputStream.read(contents);
                    } catch (FileNotFoundException e) {
                        this.getResponse().getWriter().println("{\"result\":false,\"message\":\""+"系统异常,请联系管理员!"+"\"}");
                        e.printStackTrace();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                    // downFileName = java.net.URLEncoder.encode(att
                    // .getAttachname(), "UTF-8");
                    downFileStream = getDownLoadFileStream(contents);
                    // }
                }
            } catch (Exception ex){
                logger.error(ex.toString());
                this.getResponse().getWriter().println("{\"result\":false,\"message\":\""+"系统异常,请联系管理员!"+"\"}");
//				throw new BasalException(BasalException.ERROR, "系统异常,请联系管理员!");
            }
        }
        return SUCCESS;
    }

    /**
     * 将文件转换成输入流，提供struts下载参数
     * @param bytes 需要下载的文件路径
     * @return
     */
    public InputStream getDownLoadFileStream(byte[] bytes)
    {
        try
        {
            // 将得到的字节输出流转换成字节数组——>字节输入流
            downFileStream = new ByteArrayInputStream(bytes);
        } catch (Exception e)
        {
            return null;
        }
        return downFileStream;
    }



    /**
     *
     * TODO 将一个对象输出为json
     * @author lilu
     * @param obj
     * @return
     */
    public String outputObjectToJson(Object obj) {
        StringBuilder data = new StringBuilder("");
        try {
            JSONObject json = JSONObject.fromObject(obj);
            data.append(json.toString());
            getResponse().setContentType("application/json;charset=UTF-8");
            getResponse().setCharacterEncoding(ENCODING);
            getResponse().setHeader("Charset", ENCODING);
            getResponse().setHeader("Cache-Control", "no-cache");
            getResponse().getWriter().println(data);
        } catch (Exception e) {
            logger.error(JSON_ERROR, e);
        }
        return data.toString();
    }
    public static void main(String[] args) {
//        this.outputObjectToJson("{ \"message\": \"调用成功\",\"code\": \"200\"}");
//        ELicenseFile model = true?exist.get(0):new ELicenseFile();

    }


    public String getIds() {
        return ids;
    }

    public void setIds(String ids) {
        this.ids = ids;
    }

    public Date getStartTerm() {
        return startTerm;
    }

    public void setStartTerm(Date startTerm) {
        this.startTerm = startTerm;
    }

    public Date getEndTerm() {
        return endTerm;
    }

    public void setEndTerm(Date endTerm) {
        this.endTerm = endTerm;
    }

    public ELicense geteLicense() {
        return eLicense;
    }

    public void seteLicense(ELicense eLicense) {
        this.eLicense = eLicense;
    }

    public Pagination getPagination() {
        return pagination;
    }

    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }



    public static String getPTF1() {
        return PTF1;
    }

    public static String getPTF2() {
        return PTF2;
    }

    public static String getYZS1() {
        return YZS1;
    }

    public static String getYZS2() {
        return YZS2;
    }

    public ZzhxmJktzs getZzhxmJktzs() {
        return zzhxmJktzs;
    }

    public void setZzhxmJktzs(ZzhxmJktzs zzhxmJktzs) {
        this.zzhxmJktzs = zzhxmJktzs;
    }

    public Jktzs getJktzs() {
        return jktzs;
    }

    public void setJktzs(Jktzs jktzs) {
        this.jktzs = jktzs;
    }

    public Zzhxm getZzhxm() {
        return zzhxm;
    }

    public void setZzhxm(Zzhxm zzhxm) {
        this.zzhxm = zzhxm;
    }

    public List<ZzhxmSfxx> getZzhxmSfxx() {
        return zzhxmSfxx;
    }

    public void setZzhxmSfxx(List<ZzhxmSfxx> zzhxmSfxx) {
        this.zzhxmSfxx = zzhxmSfxx;
    }

    public List<File> getFile1() {
        return file1;
    }

    public void setFile1(List<File> file1) {
        this.file1 = file1;
    }

    public List<String> getFile1FileName() {
        return file1FileName;
    }

    public void setFile1FileName(List<String> file1FileName) {
        this.file1FileName = file1FileName;
    }

    public String getAllFileName() {
        return allFileName;
    }

    public void setAllFileName(String allFileName) {
        this.allFileName = allFileName;
    }

    public String getOriginFileName() {
        return originFileName;
    }

    public void setOriginFileName(String originFileName) {
        this.originFileName = originFileName;
    }

    public ELicenseFile geteLicenseFile() {
        return eLicenseFile;
    }

    public void seteLicenseFile(ELicenseFile eLicenseFile) {
        this.eLicenseFile = eLicenseFile;
    }

    public String getFlag() {
        return flag;
    }

    public void setFlag(String flag) {
        this.flag = flag;
    }

    public List<ELicenseFile> geteLicenseFileList() {
        return eLicenseFileList;
    }

    public void seteLicenseFileList(List<ELicenseFile> eLicenseFileList) {
        this.eLicenseFileList = eLicenseFileList;
    }

    public String getDownFileName() {
        return downFileName;
    }

    public void setDownFileName(String downFileName) {
        this.downFileName = downFileName;
    }

    public InputStream getDownFileStream() {
        return downFileStream;
    }

    public void setDownFileStream(InputStream downFileStream) {
        this.downFileStream = downFileStream;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getShowName() {
        return showName;
    }

    public void setShowName(List<String> showName) {
        this.showName = showName;
    }

    public Xmxxb getXmxxb() {
        return xmxxb;
    }

    public void setXmxxb(Xmxxb xmxxb) {
        this.xmxxb = xmxxb;
    }

    public Date getStartBind() {
        return startBind;
    }

    public void setStartBind(Date startBind) {
        this.startBind = startBind;
    }

    public Date getEndBind() {
        return endBind;
    }

    public void setEndBind(Date endBind) {
        this.endBind = endBind;
    }
}
