package com.jshx.elicense.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.jshx.core.base.entity.BaseModel;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 *  2020-12-8 对接共享平台
 */
@Entity
@Table(name="E_LICENSE")
public class ELicense extends BaseModel {

    /**
     * NO : 60cb952e6b5a41409956ad1694e6ed3f
     * ORG_ID : 11320100012947154USUN
     * ORG_NAME : 发改委
     * DEPT_YW_REG_NO : 32010100100100000000100100001001
     * DEPT_YW_NAME : 测试事项
     * TRANSACT_AFFAIR_NAME :
     * CONTENT :
     * STATUS : A
     * RESULT_NO :
     * NOTE :
     * CREATE_DATE : 2017-10-12 17:44:49
     * DATA_SOURCES : 2
     * RESULTNAME :
     * IF_URGENT :
     * SQ_WAY :
     * APPLICANT_TYPE :
     * APPLICANT_NAME :
     * APPLICANT_PAPER_TYPE :
     * APPLICANT_PAPER_CODE :
     * APPLICANT_MOBILE :
     * APPLICANT_PHONE :
     * APPLICANT_ADDRESS :
     * APPLICANT_ZIPCODE :
     * APPLICANT_EMALL :
     * OPER_MAN_NAME :
     * LINKMAN_NAME :
     * LINKMAN_PAPER_TYPE :
     * LINKMAN_PAPER_CODE :
     * LINKMAN_MOBILE :
     * LINKMAN_PHONE :
     * LINKMAN_ADDRESS :
     * LINKMAN_ZIPCODE :
     * LINKMAN_EMAIL :
     * YE_MS :
     * WAPPLY_DATE : 2017-10-12 16:40:04
     * APPLY_DATE : 2017-10-12 17:44:51
     * SYNC_DATE : 2017-10-12 17:45:04
     * FORMS :
     */


    private Integer delFlag;
    /**
     * 唯一标识
     */
    @JSONField(name="NO")
    private String caseNo;
    /**
     * 部门编码
     */
    @JSONField(name="ORG_ID")
    private String orgId;
    /**
     * 部门名称
     */
    @JSONField(name="ORG_NAME")
    private String orgName;
    /**
     * 权利业务编码
     */
    @JSONField(name="DEPT_YW_REG_NO")
    private String deptYwRegNo;
    /**
     * 权利业务名称
     */
    @JSONField(name="DEPT_YW_NAME")
    private String deptYwName;
    /**
     * 办件名称
     */
    @JSONField(name="TRANSACT_AFFAIR_NAME")
    private String transactAffairName;
    /**
     * 办件摘要
     */
    @JSONField(name="CONTENT")
    private String content;
    /**
     * 本环节办理结果
     */
    @JSONField(name="STATUS")
    private String status;
    /**
     * 许可/不予许可文号
     */
    @JSONField(name="RESULT_NO")
    private String resultNo;
    /**
     * 办理意见
     */
    @JSONField(name="NOTE")
    private String note;
    /**
     * 决定时间
     */
    @JSONField(name="CREATE_DATE")
    private String decideDate;
    /**
     * 数据来源
     */
    @JSONField(name="DATA_SOURCES")
    private String dataSources;
    /**
     * 审批结果名称
     */
    @JSONField(name="RESULTNAME")
    private String resultName;
    /**
     * 是否加急
     */
    @JSONField(name="IF_URGENT")
    private String ifUrgent;
    /**
     * 申请方式
     */
    @JSONField(name="SQ_WAY")
    private String sqWay;
    /**
     * 申请者类型
     */
    @JSONField(name="APPLICANT_TYPE")
    private String applicantType;
    /**
     * 申请者名称
     */
    @JSONField(name="APPLICANT_NAME")
    private String applicantName;
    /**
     * 申请者证件类型
     */
    @JSONField(name="APPLICANT_PAPER_TYPE")
    private String applicantPaperType;
    /**
     * 申请者证件号码
     */
    @JSONField(name="APPLICANT_PAPER_CODE")
    private String applicantPaperCode;
    /**
     * 申请者手机号
     */
    @JSONField(name="APPLICANT_MOBILE")
    private String applicantMobile;
    /**
     * 申请者电话
     */
    @JSONField(name="APPLICANT_PHONE")
    private String applicantPhone;
    /**
     * 申请者地址
     */
    @JSONField(name="APPLICANT_ADDRESS")
    private String applicantAddress;
    /**
     * 申请者邮编
     */
    @JSONField(name="APPLICANT_ZIPCODE")
    private String applicantZipcode;
    /**
     * 电子邮箱
     */
    @JSONField(name="APPLICANT_EMALL")
    private String applicantEmail;
    /**
     * 法定代表人姓名
     */
    @JSONField(name="OPER_MAN_NAME")
    private String operManName;
    /**
     * 联系人姓名
     */
    @JSONField(name="LINKMAN_NAME")
    private String linkmanName;
    /**
     * 联系人证件类型
     */
    @JSONField(name="LINKMAN_PAPER_TYPE")
    private String linkmanPaperType;
    /**
     * 联系人证件号码
     */
    @JSONField(name="LINKMAN_PAPER_CODE")
    private String linkmanPaperCode;
    /**
     * 联系人手机
     */
    @JSONField(name="LINKMAN_MOBILE")
    private String linkmanMobile;
    /**
     * 联系人电话
     */
    @JSONField(name="LINKMAN_PHONE")
    private String linkmanPhone;
    /**
     * 联系人地址
     */
    @JSONField(name="LINKMAN_ADDRESS")
    private String linkmanAddress;
    /**
     * 联系人邮编
     */
    @JSONField(name="LINKMAN_ZIPCODE")
    private String linkmanZipcode;
    /**
     * 联系人电子邮箱
     */
    @JSONField(name="LINKMAN_EMAIL")
    private String linkmanEmail;
    /**
     * 办件业务说明
     */
    @JSONField(name="YE_MS")
    private String YEMS;
    /**
     * 网上申请时间
     */
    @JSONField(name="WAPPLY_DATE")
    private Date wapplyDate;
    /**
     * 收件时间
     */
    @JSONField(name="APPLY_DATE")
    private Date applyDate;
    /**
     * 信息推送时间
     */
    @JSONField(name="SYNC_DATE")
    private Date syncDate;
    /**
     * 受理填报信息
     */
    @JSONField(name="FORMS")
    private String forms;

    /**
     * 办件编码
     */
    private String internalNo;


    /**
     * 办件类型
     * 1 配套费
     * 2 一站式
     */
    private String projectType;

    /**
     * 绑定的配套费项目id
     *
     */
    private String jktzsId;
    /**
     * 绑定的一站式缴款通知书id
     *
     */
    private String zzhxmId;
    /**
     * 信息表编号
     * TODO 暂不清晰是否需要,先保留 (只跟配套费相关)
     */
    private String xxbbh;

    /**
     * 绑定标记
     * 0 未绑定(初始化)
     * 1 已绑定
     * 2 解绑
     */
    private String bindFlag;

    /**
     * 绑定时间
     */
    private Date bindTime;

    /**
     * 是否推送
     * 1是
     * 主要是做后续推送过后不允许再进行操作修改
     */
    private String pushFlag;

    /**
     * 规划许可证号
     * 绑定时候同步更新该字段
     */
    private String ghxkz;

    /**
     * 建设单位名称
     * 绑定时同步
     */
    private String jsdwmc;

    /**
     * 工程项目名称
     * 帮定时同步
     */
    private String gcxmmc;

    /**
     * 窗口编号
     * 绑定时同步
     */
    private String ckbh;

    /**
     * 承诺缴费环节type
     * 1 施工前许可前
     * 2 竣工验收前
     * 3 收到通知N日内
     */
    private String paymentLinkType;

    /**
     *  when paymentLinkType=3时此字段有值,值等于N
     */
    private String paymentLinkDays;


    public ELicense(){}

    public ELicense(Integer delFlag, String caseNo, String orgId, String orgName, String deptYwRegNo, String deptYwName, String transactAffairName, String content, String status, String resultNo, String note, String decideDate, String dataSources, String resultName, String ifUrgent, String sqWay, String applicantType, String applicantName, String applicantPaperType, String applicantPaperCode, String applicantMobile, String applicantPhone, String applicantAddress, String applicantZipcode, String applicantEmail, String operManName, String linkmanName, String linkmanPaperType, String linkmanPaperCode, String linkmanMobile, String linkmanPhone, String linkmanAddress, String linkmanZipcode, String linkmanEmail, String YEMS, Date wapplyDate, Date applyDate, Date syncDate, String forms, String internalNo, String projectType, String jktzsId, String zzhxmId, String xxbbh, String bindFlag, Date bindTime, String pushFlag, String ghxkz, String jsdwmc, String gcxmmc, String ckbh, String paymentLinkType, String paymentLinkDays) {
        this.delFlag = delFlag;
        this.caseNo = caseNo;
        this.orgId = orgId;
        this.orgName = orgName;
        this.deptYwRegNo = deptYwRegNo;
        this.deptYwName = deptYwName;
        this.transactAffairName = transactAffairName;
        this.content = content;
        this.status = status;
        this.resultNo = resultNo;
        this.note = note;
        this.decideDate = decideDate;
        this.dataSources = dataSources;
        this.resultName = resultName;
        this.ifUrgent = ifUrgent;
        this.sqWay = sqWay;
        this.applicantType = applicantType;
        this.applicantName = applicantName;
        this.applicantPaperType = applicantPaperType;
        this.applicantPaperCode = applicantPaperCode;
        this.applicantMobile = applicantMobile;
        this.applicantPhone = applicantPhone;
        this.applicantAddress = applicantAddress;
        this.applicantZipcode = applicantZipcode;
        this.applicantEmail = applicantEmail;
        this.operManName = operManName;
        this.linkmanName = linkmanName;
        this.linkmanPaperType = linkmanPaperType;
        this.linkmanPaperCode = linkmanPaperCode;
        this.linkmanMobile = linkmanMobile;
        this.linkmanPhone = linkmanPhone;
        this.linkmanAddress = linkmanAddress;
        this.linkmanZipcode = linkmanZipcode;
        this.linkmanEmail = linkmanEmail;
        this.YEMS = YEMS;
        this.wapplyDate = wapplyDate;
        this.applyDate = applyDate;
        this.syncDate = syncDate;
        this.forms = forms;
        this.internalNo = internalNo;
        this.projectType = projectType;
        this.jktzsId = jktzsId;
        this.zzhxmId = zzhxmId;
        this.xxbbh = xxbbh;
        this.bindFlag = bindFlag;
        this.bindTime = bindTime;
        this.pushFlag = pushFlag;
        this.ghxkz = ghxkz;
        this.jsdwmc = jsdwmc;
        this.gcxmmc = gcxmmc;
        this.ckbh = ckbh;
        this.paymentLinkType = paymentLinkType;
        this.paymentLinkDays = paymentLinkDays;
    }

    @Column(name = "delflag")
    public Integer getDelFlag() {
        return delFlag;
    }

    public void setDelFlag(Integer delFlag) {
        this.delFlag = delFlag;
    }

    @Column(name = "case_no")
    public String getCaseNo() {
        return caseNo;
    }

    public void setCaseNo(String caseNo) {
        this.caseNo = caseNo;
    }

    @Column(name = "org_id")
    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    @Column(name = "org_name")
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @Column(name = "dept_yw_reg_no")
    public String getDeptYwRegNo() {
        return deptYwRegNo;
    }

    public void setDeptYwRegNo(String deptYwRegNo) {
        this.deptYwRegNo = deptYwRegNo;
    }

    @Column(name = "dept_yw_name")
    public String getDeptYwName() {
        return deptYwName;
    }

    public void setDeptYwName(String deptYwName) {
        this.deptYwName = deptYwName;
    }

    @Column(name = "transact_affair_name")
    public String getTransactAffairName() {
        return transactAffairName;
    }

    public void setTransactAffairName(String transactAffairName) {
        this.transactAffairName = transactAffairName;
    }

    @Column(name = "content")
    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Column(name = "status")
    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Column(name = "result_no")
    public String getResultNo() {
        return resultNo;
    }

    public void setResultNo(String resultNo) {
        this.resultNo = resultNo;
    }

    @Column(name = "note")
    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    @Column(name = "decide_date")
    public String getDecideDate() {
        return decideDate;
    }

    public void setDecideDate(String decideDate) {
        this.decideDate = decideDate;
    }

    @Column(name = "data_sources")
    public String getDataSources() {
        return dataSources;
    }

    public void setDataSources(String dataSources) {
        this.dataSources = dataSources;
    }

    @Column(name = "result_name")
    public String getResultName() {
        return resultName;
    }

    public void setResultName(String resultName) {
        this.resultName = resultName;
    }

    @Column(name = "if_urgent")
    public String getIfUrgent() {
        return ifUrgent;
    }

    public void setIfUrgent(String ifUrgent) {
        this.ifUrgent = ifUrgent;
    }

    @Column(name = "sq_way")
    public String getSqWay() {
        return sqWay;
    }

    public void setSqWay(String sqWay) {
        this.sqWay = sqWay;
    }

    @Column(name = "applicant_type")
    public String getApplicantType() {
        return applicantType;
    }

    public void setApplicantType(String applicantType) {
        this.applicantType = applicantType;
    }

    @Column(name = "applicant_name")
    public String getApplicantName() {
        return applicantName;
    }

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }

    @Column(name = "applicant_paper_type")
    public String getApplicantPaperType() {
        return applicantPaperType;
    }

    public void setApplicantPaperType(String applicantPaperType) {
        this.applicantPaperType = applicantPaperType;
    }

    @Column(name = "applicant_paper_code")
    public String getApplicantPaperCode() {
        return applicantPaperCode;
    }

    public void setApplicantPaperCode(String applicantPaperCode) {
        this.applicantPaperCode = applicantPaperCode;
    }

    @Column(name = "applicant_mobile")
    public String getApplicantMobile() {
        return applicantMobile;
    }

    public void setApplicantMobile(String applicantMobile) {
        this.applicantMobile = applicantMobile;
    }

    @Column(name = "applicant_phone")
    public String getApplicantPhone() {
        return applicantPhone;
    }

    public void setApplicantPhone(String applicantPhone) {
        this.applicantPhone = applicantPhone;
    }

    @Column(name = "applicant_address")
    public String getApplicantAddress() {
        return applicantAddress;
    }

    public void setApplicantAddress(String applicantAddress) {
        this.applicantAddress = applicantAddress;
    }

    @Column(name = "applicant_zipcode")
    public String getApplicantZipcode() {
        return applicantZipcode;
    }

    public void setApplicantZipcode(String applicantZipcode) {
        this.applicantZipcode = applicantZipcode;
    }

    @Column(name = "applicant_email")
    public String getApplicantEmail() {
        return applicantEmail;
    }

    public void setApplicantEmail(String applicantEmail) {
        this.applicantEmail = applicantEmail;
    }

    @Column(name = "operMan_name")
    public String getOperManName() {
        return operManName;
    }

    public void setOperManName(String operManName) {
        this.operManName = operManName;
    }

    @Column(name = "linkman_name")
    public String getLinkmanName() {
        return linkmanName;
    }

    public void setLinkmanName(String linkmanName) {
        this.linkmanName = linkmanName;
    }

    @Column(name = "linkman_paper_type")
    public String getLinkmanPaperType() {
        return linkmanPaperType;
    }

    public void setLinkmanPaperType(String linkmanPaperType) {
        this.linkmanPaperType = linkmanPaperType;
    }

    @Column(name = "linkman_paper_code")
    public String getLinkmanPaperCode() {
        return linkmanPaperCode;
    }

    public void setLinkmanPaperCode(String linkmanPaperCode) {
        this.linkmanPaperCode = linkmanPaperCode;
    }

    @Column(name = "linkman_mobile")
    public String getLinkmanMobile() {
        return linkmanMobile;
    }

    public void setLinkmanMobile(String linkmanMobile) {
        this.linkmanMobile = linkmanMobile;
    }

    @Column(name = "linkman_phone")
    public String getLinkmanPhone() {
        return linkmanPhone;
    }

    public void setLinkmanPhone(String linkmanPhone) {
        this.linkmanPhone = linkmanPhone;
    }

    @Column(name = "linkman_address")
    public String getLinkmanAddress() {
        return linkmanAddress;
    }

    public void setLinkmanAddress(String linkmanAddress) {
        this.linkmanAddress = linkmanAddress;
    }

    @Column(name = "linkman_zipcode")
    public String getLinkmanZipcode() {
        return linkmanZipcode;
    }

    public void setLinkmanZipcode(String linkmanZipcode) {
        this.linkmanZipcode = linkmanZipcode;
    }

    @Column(name = "linkman_email")
    public String getLinkmanEmail() {
        return linkmanEmail;
    }

    public void setLinkmanEmail(String linkmanEmail) {
        this.linkmanEmail = linkmanEmail;
    }

    @Column(name = "ye_ms")
    public String getYEMS() {
        return YEMS;
    }

    public void setYEMS(String YEMS) {
        this.YEMS = YEMS;
    }

    @Column(name = "wapply_date")
    public Date getWapplyDate() {
        return wapplyDate;
    }

    public void setWapplyDate(Date wapplyDate) {
        this.wapplyDate = wapplyDate;
    }

    @Column(name = "apply_date")
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }

    @Column(name = "sync_date")
    public Date getSyncDate() {
        return syncDate;
    }

    public void setSyncDate(Date syncDate) {
        this.syncDate = syncDate;
    }

    @Column(name = "forms")
    public String getForms() {
        return forms;
    }

    public void setForms(String forms) {
        this.forms = forms;
    }

    @Column(name = "INTERNAL_NO")
    public String getInternalNo() {
        return internalNo;
    }

    public void setInternalNo(String internalNo) {
        this.internalNo = internalNo;
    }

    @Column(name = "jktzs_id")
    public String getJktzsId() {
        return jktzsId;
    }

    public void setJktzsId(String jktzsId) {
        this.jktzsId = jktzsId;
    }

    @Column(name = "xxbbh")
    public String getXxbbh() {
        return xxbbh;
    }

    public void setXxbbh(String xxbbh) {
        this.xxbbh = xxbbh;
    }

    @Column(name = "project_type")
    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    @Column(name = "zzhxm_id")
    public String getZzhxmId() {
        return zzhxmId;
    }

    public void setZzhxmId(String zzhxmId) {
        this.zzhxmId = zzhxmId;
    }

    @Column(name = "bind_flag")
    public String getBindFlag() {
        return bindFlag;
    }

    public void setBindFlag(String bindFlag) {
        this.bindFlag = bindFlag;
    }

    @Column(name = "push_flag")
    public String getPushFlag() {
        return pushFlag;
    }

    public void setPushFlag(String pushFlag) {
        this.pushFlag = pushFlag;
    }

    @Column(name = "ghxkz")
    public String getGhxkz() {
        return ghxkz;
    }

    public void setGhxkz(String ghxkz) {
        this.ghxkz = ghxkz;
    }

    @Column(name = "jsdwmc")
    public String getJsdwmc() {
        return jsdwmc;
    }

    public void setJsdwmc(String jsdwmc) {
        this.jsdwmc = jsdwmc;
    }

    @Column(name = "gcxmmc")
    public String getGcxmmc() {
        return gcxmmc;
    }

    public void setGcxmmc(String gcxmmc) {
        this.gcxmmc = gcxmmc;
    }

    @Column(name = "ckbh")
    public String getCkbh() {
        return ckbh;
    }

    public void setCkbh(String ckbh) {
        this.ckbh = ckbh;
    }

    @Column(name = "payment_link_type")
    public String getPaymentLinkType() {
        return paymentLinkType;
    }

    public void setPaymentLinkType(String paymentLinkType) {
        this.paymentLinkType = paymentLinkType;
    }

    @Column(name = "payment_link_days")
    public String getPaymentLinkDays() {
        return paymentLinkDays;
    }

    public void setPaymentLinkDays(String paymentLinkDays) {
        this.paymentLinkDays = paymentLinkDays;
    }

    @Column(name = "bind_time")
    public Date getBindTime() {
        return bindTime;
    }

    public void setBindTime(Date bindTime) {
        this.bindTime = bindTime;
    }
}
