package com.jshx.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.apache.log4j.Logger;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;

public class SFTPChannel {
    Session session = null;
    Channel channel = null;

    private static final Logger LOG = Logger.getLogger(SFTPChannel.class.getName());

    public  ChannelSftp getChannel(Map<String, String> sftpDetails, int timeout) throws JSchException {

        String ftpHost = sftpDetails.get(SFTPConstants.SFTP_REQ_HOST);
        String port = sftpDetails.get(SFTPConstants.SFTP_REQ_PORT);
        String ftpUserName = sftpDetails.get(SFTPConstants.SFTP_REQ_USERNAME);
        String ftpPassword = sftpDetails.get(SFTPConstants.SFTP_REQ_PASSWORD);

        int ftpPort = SFTPConstants.SFTP_DEFAULT_PORT;
        if (port != null && !port.equals("")) {
            ftpPort = Integer.valueOf(port);
        }

        JSch jsch = new JSch(); // 创建JSch对象
        session = jsch.getSession(ftpUserName, ftpHost, ftpPort); // 根据用户名，主机ip，端口获取一个Session对象
        LOG.debug("Session created.");
        if (ftpPassword != null) {
            session.setPassword(ftpPassword); // 设置密码
        }
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        session.setConfig(config); // 为Session对象设置properties
        session.setTimeout(timeout); // 设置timeout时间
        session.connect(); // 通过Session建立链接
        LOG.debug("Session connected.");

        LOG.debug("Opening Channel.");
        channel = session.openChannel("sftp"); // 打开SFTP通道
        channel.connect(); // 建立SFTP通道的连接
        LOG.debug("Connected successfully to ftpHost = " + ftpHost + ",as ftpUserName = " + ftpUserName
                + ", returning: " + channel);
        return (ChannelSftp) channel;
    }

    public void closeChannel() throws Exception {
        if (channel != null) {
            channel.disconnect();
        }
        if (session != null) {
            session.disconnect();
        }
    }
    
    /**
     * sftpDetails  设置主机ip，端口，用户名，密码
     * timeout    设置timeout时间
     * @throws JSchException 
     * */
    public static void uploadFile(String src,String dst,int mode) throws Exception
    {
    	Map<String, String> sftpDetails = new HashMap<String, String>();
        // 设置主机ip，端口，用户名，密码
        sftpDetails.put(SFTPConstants.SFTP_REQ_HOST, SysPropertiesUtil.getProperty("host"));
        sftpDetails.put(SFTPConstants.SFTP_REQ_USERNAME, SysPropertiesUtil.getProperty("username"));
        sftpDetails.put(SFTPConstants.SFTP_REQ_PASSWORD, SysPropertiesUtil.getProperty("password"));
        sftpDetails.put(SFTPConstants.SFTP_REQ_PORT, SysPropertiesUtil.getProperty("port"));
    	SFTPChannel sFTPChannel = new SFTPChannel();
  
    	 File file = new File(src);      
           ChannelSftp chSftp;
 		try {
 			chSftp = sFTPChannel.getChannel(sftpDetails, 60000);
 			chSftp.setFilenameEncoding("UTF-8");
 			createDir(dst,chSftp);
// 		   OutputStream out = chSftp.put(dst, new MyProgressMonitor(file.length()),mode); // 使用OVERWRITE模式
// 	        byte[] buff = new byte[1024 * 256]; // 设定每次传输的数据块大小为256KB
// 	        int read;
// 	        if (out != null) {
// 	            System.out.println("Start to read input stream");
// 	            InputStream is = new FileInputStream(src);
// 	            do {
// 	                read = is.read(buff, 0, buff.length);
// 	                if (read > 0) {
// 	                    out.write(buff, 0, read);
// 	                }
// 	                out.flush();
// 	            } while (read >= 0);
// 	            System.out.println("input stream read done.");
// 	        }
 			
 			chSftp.put(src, dst,mode); // 代码段2
 		    chSftp.quit();
 		    sFTPChannel.closeChannel();
 		} catch (JSchException e) {
 			throw new JSchException(e.toString());
 		} catch (SftpException  e) {
 			throw new Exception(e.toString());
 		} catch (Exception  e) {
 			throw new Exception(e.toString());
 		} 
    }
    
    
    /** 
     * 创建目录 
     * @param createpath 
     * @return 
     */  
    public static boolean createDir(String createpath,ChannelSftp sftp)  
    {  
        try  
        {  
            if (isDirExist(createpath,sftp))  
            {  
                sftp.cd(createpath);  
                return true;  
            }  
            String pathArry[] = createpath.split("/");  
            StringBuffer filePath = new StringBuffer("/");  
            for (String path : pathArry)  
            {  
                if (path.equals(""))  
                {  
                    continue;  
                }  
                filePath.append(path + "/");  
                if (isDirExist(filePath.toString(),sftp))  
                {  
                    sftp.cd(filePath.toString());  
                }  
                else  
                {  
                    // 建立目录  
                    sftp.mkdir(filePath.toString());  
                    // 进入并设置为当前目录  
                    sftp.cd(filePath.toString());  
                }  
  
            }  
            sftp.cd(createpath);  
            return true;  
        }  
        catch (SftpException e)  
        {  
            e.printStackTrace();  
        }  
        return false;  
    }  
  
    /** 
     * 判断目录是否存在 
     * @param directory 
     * @return 
     */  
    public static boolean isDirExist(String directory,ChannelSftp sftp)  
    {  
        boolean isDirExistFlag = false;  
        try  
        {  
            SftpATTRS sftpATTRS = sftp.lstat(directory);  
            isDirExistFlag = true;  
            return sftpATTRS.isDir();  
        }  
        catch (Exception e)  
        {  
        	
            if (e.toString().toLowerCase().equals("no such file"))  
            {  
                isDirExistFlag = false;  
            }  
        }  
        return isDirExistFlag;  
    }  
    public static void main(String[] args) {
    	

        String src = "D:\\档案系统.docx"; // 本地文件名
        String dst = "/home/danan/gdwj/"; // 目标文件名
       try {
		src= new String(src.getBytes(),"utf-8");
	} catch (UnsupportedEncodingException e1) {
		// TODO Auto-generated catch block
		e1.printStackTrace();
	}
        int mode =  ChannelSftp.OVERWRITE;
        try {
			SFTPChannel.uploadFile(src, dst, mode);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

        
      
	}
}