package com.jshx.constantset.entity;

import java.sql.Blob;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import com.jshx.core.base.entity.BaseModel;


/**
 * 实体类模板（目前仅适配MS-SQLServer数据库）
 * @author
 *
 */
@SuppressWarnings("serial")
@Entity
@Table(name="CONSTANT_SET")
public class ConstantSet extends BaseModel
{
	/**
	 * 部门代码
	 */
	private String deptId;

	/**
	 * 删除标记
	 */
	private Integer delFlag;

	
	/**
	 * 常量名称
	 */
	private String constantName;

	/**
	 * 常量值
	 */
	private String constantValue;

	/**
	 * 描述信息
	 */
	private String constantDescription;

	/**
	 * 常量类型
	 */
	private String constantType;

	
	public ConstantSet(){
	}
	
	public ConstantSet(String id, String constantName, String constantValue, String constantDescription, String constantType){
this.id = id;

this.constantName = constantName;

this.constantValue = constantValue;

this.constantDescription = constantDescription;

this.constantType = constantType;
}


	@Column
	public String getDeptId()
	{
		return deptId;
	}

	public void setDeptId(String deptId)
	{
		this.deptId = deptId;
	}

	@Column
	public Integer getDelFlag()
	{
		return delFlag;
	}

	public void setDelFlag(Integer delFlag)
	{
		this.delFlag = delFlag;
	}

	
	@Column(name="CONSTANT_NAME")
	public String getConstantName()
	{
		return this.constantName;
	}

	public void setConstantName(String constantName)
	{
		this.constantName = constantName;
	}

	@Column(name="CONSTANT_VALUE")
	public String getConstantValue()
	{
		return this.constantValue;
	}

	public void setConstantValue(String constantValue)
	{
		this.constantValue = constantValue;
	}

	@Column(name="CONSTANT_DESCRIPTION")
	public String getConstantDescription()
	{
		return this.constantDescription;
	}

	public void setConstantDescription(String constantDescription)
	{
		this.constantDescription = constantDescription;
	}

	@Column(name="CONSTANT_TYPE")
	public String getConstantType()
	{
		return this.constantType;
	}

	public void setConstantType(String constantType)
	{
		this.constantType = constantType;
	}

}
