package com.jshx.common.utils;

import jxl.Sheet;

import org.apache.commons.lang.StringUtils;

public class ValidUtils {
	final static String YEAR_REG = "^(19|20|21)\\d{2}$";
	final static String YEAR_MONTH_REG = "^(19|20|21)\\d{2}-([1-9]|1[0-2])$";
	final static String YEAR_QUARTER_REG = "^(19|20|21)\\d{2}\\u5e74(0[1-4])\\u5b63\\u5ea6$";
	
	/**
	 * 校验年份
	 * @param str
	 * @return
	 */
	public static boolean validYear(String str){
		if (str.matches(YEAR_REG)){
			return false;
		} else {
			return true;
		}
	}
	
	/**
	 * 校验年月
	 * @param str
	 * @return
	 */
	public static boolean validYearMonth(String str){
		if (str.matches(YEAR_MONTH_REG)){
			return false;
		} else {
			return true;
		}
	}
	
	/**
	 * 校验年季度
	 * @param str
	 * @return
	 */
	public static boolean validYearQuarter(String str){
		if (str.matches(YEAR_QUARTER_REG)){
			return false;
		} else {
			return true;
		}
	}
	
	
	/**判断是否为非负浮点数
	 * @param value
	 * @return
	 */
	public static boolean isPositive(String value) {
		try {
			double val = Double.valueOf(value);
			if(val>=0){
				return true;
			}else{
				return false;
			}
		} catch (Exception e) {
			return false;
		}
	}
	
	/**判断是否为浮点数
	 * @param value
	 * @return
	 */
	public static boolean isNumber(String value) {
		try {
			Double.valueOf(value);
			return true;
		} catch (Exception e) {
			return false;
		}
	}
	
	/**
	 * 判断是否为正整数
	 * @param value
	 * @returnW
	 */
	public static boolean isInt(String value) {
		try {
			int val = Integer.valueOf(value);
			if(val>=0){
				return true;
			}else
			{
				return false;
			}
		} catch (Exception e) {
			return false;
		}
	}
	
	public static long getRealRows(Sheet sheet,long rowCount,long colCount){
		long afterRows = rowCount;
		for (int i = 1; i < rowCount; i++) {
			// 统计行中为空的单元格数
			int nullCellNum = 0;
			for (int j = 0; j < colCount; j++) {
				String val = sheet.getCell(j, i).getContents();
				val = StringUtils.trimToEmpty(val);
				if (StringUtils.isBlank(val))
					nullCellNum++;
			}
			if (nullCellNum >= colCount) { // 如果nullCellNum大于或等于总的列数
				afterRows--; // 行数减一
			}
		}
			return afterRows;
	}
		
}
