package com.jshx.cktzs.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.lxrinfo.entity.Lxrinfo;
import com.jshx.lxrinfo.service.LxrinfoService;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.zsdw.entity.Zsdw;
import com.jshx.zsdw.service.ZsdwService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.cktzs.entity.Cktzs;
import com.jshx.cktzs.service.CktzsService;

public class CktzsAction extends BaseAction
{
	private String id;
	
	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Cktzs cktzs = new Cktzs();
	private Lxrinfo lxrinfo=new Lxrinfo();

	/**
	 * 业务类
	 */
	@Autowired
	private CktzsService cktzsService;
	@Autowired
        private LxrinfoService lxrinfoService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	
	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	@Autowired
	private ZsdwService zsdwService;
	
	private String currentDate;

	private String delayDay;
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != cktzs){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != cktzs.getSlbh()) && (0 < cktzs.getSlbh().trim().length())){
				paraMap.put("slbh", "%" + cktzs.getSlbh().trim() + "%");
			}

			if ((null != cktzs.getXxbbh()) && (0 < cktzs.getXxbbh().trim().length())){
				paraMap.put("xxbbh", "%" + cktzs.getXxbbh().trim() + "%");
			}
			if ((null != cktzs.getIsjk()) && (0 < cktzs.getIsjk().trim().length())&&!"99".equals(cktzs.getIsjk())){
				paraMap.put("isjk", "%" + cktzs.getIsjk().trim() + "%");
			}
			if ((null != cktzs.getIscj()) && (0 < cktzs.getIscj().trim().length())&&!"99".equals(cktzs.getIscj())){
				if("0".equals(cktzs.getIscj())){
					paraMap.put("iscj", "%" + cktzs.getIscj().trim() + "%");
				}
				if("1".equals(cktzs.getIscj())){
					paraMap.put("iscjnull", "%" + cktzs.getIscj().trim() + "%");
				}
				
			}

			if ((null != cktzs.getDwmc()) && (0 < cktzs.getDwmc().trim().length())){
				paraMap.put("dwmc", "%" + cktzs.getDwmc().trim() + "%");
			}

			if ((null != cktzs.getXmmc()) && (0 < cktzs.getXmmc().trim().length())){
				paraMap.put("xmmc", "%" + cktzs.getXmmc().trim() + "%");
			}

			if ((null != cktzs.getXmdd()) && (0 < cktzs.getXmdd().trim().length())){
				paraMap.put("xmdd", "%" + cktzs.getXmdd().trim() + "%");
			}

			if ((null != cktzs.getCkbh()) && (0 < cktzs.getCkbh().trim().length())){
				paraMap.put("ckbh", "%" + cktzs.getCkbh().trim() + "%");
			}

			if ((null != cktzs.getDwdm()) && (0 < cktzs.getDwdm().trim().length())){
				paraMap.put("dwdm", "%" + cktzs.getDwdm().trim() + "%");
			}

			if ((null != cktzs.getGhxkz()) && (0 < cktzs.getGhxkz().trim().length())){
				paraMap.put("ghxkz", "%" + cktzs.getGhxkz().trim() + "%");
			}

			if ((null != cktzs.getLianxiren()) && (0 < cktzs.getLianxiren().trim().length())){
				paraMap.put("lianxiren", "%" + cktzs.getLianxiren().trim() + "%");
			}

			if ((null != cktzs.getDkslh()) && (0 < cktzs.getDkslh().trim().length())){
				paraMap.put("dkslh", "%" + cktzs.getDkslh().trim() + "%");
			}

			if ((null != cktzs.getIsqtfy()) && (0 < cktzs.getIsqtfy().trim().length())){
				paraMap.put("isqtfy", "%" + cktzs.getIsqtfy().trim() + "%");
			}

		}
		
		
		   String dwdm="";
	         if(!this.getLoginUser().getIsSuperAdmin()){
	           dwdm=zsdwService.getDwdm(this.getLoginUserDepartmentId());
	         }
	         if(!"".equals(dwdm)){
	        	paraMap.put("dwdm", dwdm);
	         }
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|xxbbh|dzbh|xmmc|xmdd|ckbh|ghxkz|zjzmj|csptf|jfje|jfmj|dwmc|mjmj|mjje|lianxiren|phone|xqtyj|createTime|rfyj|byyj|dkslh|dkmj|dycs|slbh|isjk|iscj|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = cktzsService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != cktzs)&&(null != cktzs.getId()))
			cktzs = cktzsService.getById(cktzs.getId());
		SimpleDateFormat outSdf = new SimpleDateFormat("yyyyMMdd");
		currentDate = outSdf.format(new Date());
		setDelayDay(SysPropertiesUtil.getProperty("delayDay"));
		Zsdw zsdwxx = zsdwService.getzsdw(this.getLoginUserDepartmentId());
		lxrinfo=lxrinfoService.getBybhdwdm("002", zsdwxx.getZsdm());
		this.setRequestAttribute("zsdwxx", zsdwxx);
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		if ("add".equalsIgnoreCase(this.flag)){
			cktzs.setDeptId(this.getLoginUserDepartmentId());
			cktzs.setDelFlag(0);
			cktzsService.save(cktzs);
		}else{
			cktzsService.update(cktzs);
		}
		
		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != cktzs)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到cktzs中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			cktzsService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public void updatePrintTimes(){
		cktzs = cktzsService.getById(id);
		Long times = Long.parseLong(cktzs.getDycs()) + 1;
		cktzs.setDycs(times.toString());
		cktzsService.update(cktzs);
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Cktzs getCktzs(){
		return this.cktzs;
	}

	public void setCktzs(Cktzs cktzs){
		this.cktzs = cktzs;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

	public String getCurrentDate() {
		return currentDate;
	}

	public void setCurrentDate(String currentDate) {
		this.currentDate = currentDate;
	}

	public String getDelayDay() {
		return delayDay;
	}

	public void setDelayDay(String delayDay) {
		this.delayDay = delayDay;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

    public Lxrinfo getLxrinfo() {
        return lxrinfo;
    }

    public void setLxrinfo(Lxrinfo lxrinfo) {
        this.lxrinfo = lxrinfo;
    }
       
    
}
