package com.jshx.cjjlb.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.activiti.engine.IdentityService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.paymentItemDelay.entity.PaymentItemDelay;
import com.jshx.paymentItemDelay.service.PaymentItemDelayService;
import com.jshx.spjkjl.entity.Spjkjl;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.zsdw.service.ZsdwService;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.activiti.service.ActivitiService;
import com.jshx.cjjlb.entity.Cjjlb;
import com.jshx.cjjlb.service.CjjlbService;
import com.jshx.cktzs.entity.Cktzs;
import com.jshx.cktzs.service.CktzsService;

public class CjjlbAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Cjjlb cjjlb = new Cjjlb();
	
	private Cktzs cktzs=new Cktzs();
	private PaymentItemDelay paymentItemDelay=new PaymentItemDelay();

	/**
	 * 业务类
	 */
	@Autowired
	private CjjlbService cjjlbService;
	  @Autowired
	    private IdentityService identityService;
	   @Autowired
	    protected RuntimeService runtimeService;
	   @Autowired
	    protected TaskService taskService;
	    @Autowired
	    private ActivitiService activitiService;
		@Autowired
		private PaymentItemDelayService paymentItemDelayService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;
	private String slbh;
	private String taskId;
	private String comment;
	private String caozuo;
	
	
	

	public String getCaozuo() {
		return caozuo;
	}

	public void setCaozuo(String caozuo) {
		this.caozuo = caozuo;
	}

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public String getTaskId() {
		return taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	public String getSlbh() {
		return slbh;
	}

	public void setSlbh(String slbh) {
		this.slbh = slbh;
	}

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	
	private Date queryFhsjStart;

	private Date queryFhsjEnd;

	private Date querySysjStart;

	private Date querySysjEnd;

	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	@Autowired
	private CktzsService cktzsService;
	@Autowired
	private ZsdwService zsdwService;
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		  String dwdm="";
	         if(!this.getLoginUser().getIsSuperAdmin()){
	           dwdm=zsdwService.getDwdm(this.getLoginUserDepartmentId());
	         }
	         if(!"".equals(dwdm)){
	        	paraMap.put("dwdm", dwdm);
	         }
		

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		
		if(null!=cktzs){
			Map<String, Object> paraMapck = new HashMap<String, Object>();
			Map<String, Object> paraMaphj = new HashMap<String, Object>();
		
			boolean ischax=false;
			if ((null != cktzs.getXxbbh()) && (0 < cktzs.getXxbbh().trim().length())){
				paraMapck.put("xxbbh", "%" + cktzs.getXxbbh().trim() + "%");
				ischax=true;
			}
			if ((null != cktzs.getIsjk()) && (0 < cktzs.getIsjk().trim().length())&&!"99".equals(cktzs.getIsjk())){
				paraMapck.put("isjk", "%" + cktzs.getIsjk().trim() + "%");
				ischax=true;
				if("2".equals(cktzs.getIsjk().trim())||"3".equals(cktzs.getIsjk().trim())){
					paraMapck.put("hjk", "333");
				}
				
			}
			if ((null != cktzs.getDwmc()) && (0 < cktzs.getDwmc().trim().length())){
				paraMapck.put("dwmcc", "%" + cktzs.getDwmc().trim() + "%");
				paraMaphj.put("dwmc", "%" + cktzs.getDwmc().trim() + "%");
				ischax=true;
			}

			if ((null != cktzs.getXmmc()) && (0 < cktzs.getXmmc().trim().length())){
				paraMapck.put("xmmc", "%" + cktzs.getXmmc().trim() + "%");
				paraMaphj.put("xmmc", "%" + cktzs.getXmmc().trim() + "%");
				ischax=true;
			}

			if ((null != cktzs.getXmdd()) && (0 < cktzs.getXmdd().trim().length())){
				paraMapck.put("xmdd", "%" + cktzs.getXmdd().trim() + "%");
				ischax=true;
			}
			if(ischax){
				paraMapck.put("dwdm", dwdm);
				paraMaphj.put("dwdm", dwdm);
				List<Cktzs> lcks=	cktzsService.findByall1(paraMapck);
				List<PaymentItemDelay> lpp=paymentItemDelayService.findall(paraMaphj);
				List slbhs=new ArrayList<>();
				
				if(null!=lcks&&lcks.size()>0){
					for (Cktzs bean : lcks) {
						slbhs.add(bean.getSlbh());
					}
				}
				if(null!=lpp&&lpp.size()>0){
					for (PaymentItemDelay be : lpp) {
						slbhs.add(be.getSlbh());
					}
				}
               if(null!=slbhs&&slbhs.size()>0){
            					
            	paraMap.put("slbhs",slbhs);
               }else if((null == cjjlb.getSlbh()) || (0 <= cjjlb.getSlbh().trim().length())){
            		   paraMap.put("slbhs","123");
            	   }
            	   
               
				
			}
			
		}
		if(null != cjjlb){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != cjjlb.getSlbh()) && (0 < cjjlb.getSlbh().trim().length())){
				paraMap.put("slbh", "%" + cjjlb.getSlbh().trim() + "%");
			}

		}
	
		
		
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|createTime|cjrz|slbh|fhyj|syyj|xxylb|jsdw|xmmc|xmdz|jkrq|jksbh|cjjg|dyshu|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = cjjlbService.findByPage(pagination, paraMap);
		List<Cjjlb> lcs=pagination.list;
		if(lcs.size()>0){
			for (Cjjlb cjbean : lcs) {
				if(cjbean.getSlbh().length()>16){
					//正常项目
					Map<String, Object> zcs = new HashMap<String, Object>();
					zcs.put("slbh", cjbean.getSlbh());
					List<Cktzs> lcktszs=cktzsService.findByall1(zcs);
					 if(null!=lcktszs&&lcktszs.size()>0){
						 cjbean.setXxylb(lcktszs.get(0).getXxbbh());
						 cjbean.setJsdw(lcktszs.get(0).getDwmc());
						 cjbean.setXmmc(lcktszs.get(0).getXmmc());
						 cjbean.setXmdz(lcktszs.get(0).getXmdd());
						 SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd"); 
						 cjbean.setJkrq(sdf.format(lcktszs.get(0).getCreateTime()));
						 cjbean.setJksbh(lcktszs.get(0).getDzbh());
						 cjbean.setCjjg(lcktszs.get(0).getIsjk());
						 cjbean.setDyshu(lcktszs.get(0).getDycs());
					 }
					
				}else{
					Map<String, Object> hj = new HashMap<String, Object>();
					hj.put("slbh", cjbean.getSlbh());
					hj.put("dwdm", dwdm);
					List<PaymentItemDelay> lps=paymentItemDelayService.findall(hj);
					 if(null!=lps&&lps.size()>0){
//						 cjbean.setXxylb();
						 cjbean.setJsdw(lps.get(0).getDwmc());
						 cjbean.setXmmc(lps.get(0).getXmmc());
//						 cjbean.setXmdz();
//						 SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd"); 
//						 cjbean.setJkrq(sdf.format(lcktszs.get(0).getCreateTime()));
//						 cjbean.setJksbh(lcktszs.get(0).getDzbh());
						 
						 //催缴结果  4已核销、5未核销
						 if("0".equals(lps.get(0).getHjye())||"0.0".equals(lps.get(0).getHjye())||"0.00".equals(lps.get(0).getHjye())){
							 cjbean.setCjjg("4");
						 }else{
							 cjbean.setCjjg("5");
							 
						 }
					 }
					//缓缴项目
				}
			}
		}
		
		
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != cjjlb)&&(null != cjjlb.getId())){
			cjjlb = cjjlbService.getById(cjjlb.getId());
		}
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("slbh", cjjlb.getSlbh() );
		if(cjjlb.getSlbh().length()>16){
			List<Cktzs> li=cktzsService.findByall1(paraMap);
			if(null!=li&&li.size()>0){
				cktzs=li.get(0);
                cjjlb.setJsdw(cktzs.getDwmc());				
                cjjlb.setXmmc(cktzs.getXmmc());				
			}
		}else{
			List<PaymentItemDelay> lps=paymentItemDelayService.findall(paraMap);
			if(null!=lps&&lps.size()>0){
				cjjlb.setJsdw(lps.get(0).getDwmc());
				cjjlb.setXmmc(lps.get(0).getXmmc());
			}
		}
		
		
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	
	    return EDIT;
	}
	public String initEdit1() throws Exception{
		if(!"".equals(slbh)){
			Map<String, Object> paraMap = new HashMap<String, Object>();
			paraMap.put("slbh", slbh );
			List<Cktzs> li=cktzsService.findByall(paraMap);
			cktzs=li.get(0);
		}
		return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		if ("add".equalsIgnoreCase(this.flag)){
			cjjlb.setDeptId(this.getLoginUserDepartmentId());
			cjjlb.setDelFlag(0);
			cjjlb.setJbr(this.getLoginUser().getDisplayName());
			cjjlbService.save(cjjlb);
			Map<String, Object> paraMap = new HashMap<String, Object>();
			paraMap.put("xmbzj", cjjlb.getXmxxbzj() );
			List<Cktzs> li=cktzsService.findByall1(paraMap);
			if(null!=li&&li.size()>0){
				Cktzs ck=li.get(0);
				//催缴记录是否已经催款
				if(null==ck.getIscj()||"".equals(ck.getIscj())){
					ck.setIscj("0");
					cktzsService.update(ck);
				}
			}
			
//			String businessKey=cjjlb.getXmxxbzj();
		      try {
		          identityService.setAuthenticatedUserId(this.getLoginUser().getLoginId());
		          ProcessInstance processInstance = runtimeService.startProcessInstanceByKey("cjrz", cjjlb.getId());
		          String aaa=processInstance.getProcessInstanceId();
		          cjjlb.setGzlsl(aaa);
		          cjjlbService.update(cjjlb);
		          //获取实例ID,并判断是否直接打印并生成应缴金额
		          //slxxb.setGzlbh(aaa);
		      
		         // List<ProcessInstance> pi=  runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(businessKey).list();
		      } finally {
		          identityService.setAuthenticatedUserId(null);
		      }
			
			
		}else{
			cjjlbService.update(cjjlb);
		}
		
		return RELOAD;
	}

	//复核
	public  String cjfh(){
		Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
		ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
		String businessKey =  processInstance.getBusinessKey();
		cjjlb=cjjlbService.getById(businessKey);
				
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("xmbzj", cjjlb.getXmxxbzj() );
		List<Cktzs> li=cktzsService.findByall1(paraMap);
		   cktzs=li.get(0);
		return SUCCESS;
	}
	//复核通过
	public void fhtg() throws Exception{
	    try {
	        Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
	        ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
	        String businessKey =  processInstance.getBusinessKey();
	        cjjlb=cjjlbService.getById(businessKey);
		    cjjlb.setFhyj(comment);
		    cjjlb.setFhsj(new Date());
		    cjjlb.setFhr(this.getLoginUser().getDisplayName());
		    cjjlbService.update(cjjlb);
	        activitiService.addComment(task, this.getLoginUser().getLoginId(), comment);
	        if("1".equals(caozuo)){
	              runtimeService.deleteProcessInstance(processInstance.getProcessInstanceId(), "人工终止");
	            }else{
	            	taskService.complete(taskId);
	            } 
//	        taskService.complete(taskId);
	        this.getResponse().getWriter().println("{\"result\":true}");
	    }catch (Exception e) {
	        this.getResponse().getWriter().println("{\"result\":false}");
	    }
	}
	//审阅
	public  String cjsy(){
		Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
		ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
		String businessKey =  processInstance.getBusinessKey();
		cjjlb=cjjlbService.getById(businessKey);
		
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("xmbzj", cjjlb.getXmxxbzj() );
		List<Cktzs> li=cktzsService.findByall1(paraMap);
		cktzs=li.get(0);
		return SUCCESS;
	}
	//审阅通过
	public void sytg() throws Exception{
		try {
			Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
			ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
			String businessKey =  processInstance.getBusinessKey();
			cjjlb=cjjlbService.getById(businessKey);
			cjjlb.setSyyj(comment);
			cjjlb.setSysj(new Date());
			cjjlb.setSyr(this.getLoginUser().getDisplayName());
			cjjlbService.update(cjjlb);
			activitiService.addComment(task, this.getLoginUser().getLoginId(), comment);
			   Map<String, Object> variables = new HashMap<String, Object>();
		          if("0".equals(caozuo)){
		        	//确认
		         	variables.put("sypd", "0");
		          }else{
		         	 //退回
		         	variables.put("sypd", "1");
		          }
			taskService.complete(taskId,variables);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch (Exception e) {
			this.getResponse().getWriter().println("{\"result\":false}");
		}
	}
	
	
	
	
	
	
	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != cjjlb)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到cjjlb中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			cjjlbService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	/**
	 * 缓缴款日志
	 * @return
	 * @throws Exception
	 */
	public String hjkjb() throws Exception{
		try{
			Map<String, Object> paraMap = new HashMap<String, Object>();
			paraMap.put("slbh", slbh);
			List<PaymentItemDelay> lps=paymentItemDelayService.findall(paraMap);
			if(lps.size()>0){
				PaymentItemDelay pid=lps.get(0);
				Cjjlb cj=new Cjjlb();
				cj.setDelFlag(0);
				cj.setSlbh(slbh);
				cj.setJbr(this.getLoginUser().getDisplayName());
				cj.setCjrz(comment);
				  String dwdm="sf";
			         if(!this.getLoginUser().getIsSuperAdmin()){
			           dwdm=zsdwService.getDwdm(this.getLoginUserDepartmentId());
			         }
				cj.setDwdm(dwdm);
			    cjjlbService.save(cj);
			    identityService.setAuthenticatedUserId(this.getLoginUser().getLoginId());
		          ProcessInstance processInstance = runtimeService.startProcessInstanceByKey("hjrz", cj.getId());
		          String aaa=processInstance.getProcessInstanceId();
		          cj.setGzlsl(aaa);
		          cjjlbService.update(cj);
			}
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		} finally {
	          identityService.setAuthenticatedUserId(null);
	      }
		return null;
	}
	    //缓缴复核
		public  String hjfh(){
			Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
			ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
			String businessKey =  processInstance.getBusinessKey();
			cjjlb=cjjlbService.getById(businessKey);
					
			Map<String, Object> paraMap = new HashMap<String, Object>();
			paraMap.put("slbh", cjjlb.getSlbh());
			List<PaymentItemDelay> li=paymentItemDelayService.findall(paraMap);
			if(li.size()>0){
				paymentItemDelay=li.get(0);
			}
			return SUCCESS;
		}
		//缓缴复核通过
		public void hjfhtg() throws Exception{
		    try {
		        Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
		        ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
		        String businessKey =  processInstance.getBusinessKey();
		        cjjlb=cjjlbService.getById(businessKey);
			    cjjlb.setFhyj(comment);
			    cjjlb.setFhsj(new Date());
			    cjjlb.setFhr(this.getLoginUser().getDisplayName());
			    cjjlbService.update(cjjlb);
		        activitiService.addComment(task, this.getLoginUser().getLoginId(), comment);
		        if("1".equals(caozuo)){
		              runtimeService.deleteProcessInstance(processInstance.getProcessInstanceId(), "人工终止");
		              cjjlbService.deleteWithFlag(cjjlb.getId());
		            }else{
		            	taskService.complete(taskId);
		            } 
		        this.getResponse().getWriter().println("{\"result\":true}");
		    }catch (Exception e) {
		        this.getResponse().getWriter().println("{\"result\":false}");
		    }
		}
		//缓缴审阅
		public  String hjsy(){
			Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
			ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
			String businessKey =  processInstance.getBusinessKey();
			cjjlb=cjjlbService.getById(businessKey);
			
			Map<String, Object> paraMap = new HashMap<String, Object>();
			paraMap.put("slbh", cjjlb.getSlbh());
			List<PaymentItemDelay> li=paymentItemDelayService.findall(paraMap);
			if(li.size()>0){
				paymentItemDelay=li.get(0);
			}
			return SUCCESS;
		}
		//缓缴审阅通过
		public void hjsytg() throws Exception{
			try {
				Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
				ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
				String businessKey =  processInstance.getBusinessKey();
				cjjlb=cjjlbService.getById(businessKey);
				cjjlb.setSyyj(comment);
				cjjlb.setSysj(new Date());
				cjjlb.setSyr(this.getLoginUser().getDisplayName());
				cjjlbService.update(cjjlb);
				activitiService.addComment(task, this.getLoginUser().getLoginId(), comment);
				   Map<String, Object> variables = new HashMap<String, Object>();
			          if("0".equals(caozuo)){
			        	//确认
			         	variables.put("sypd", "0");
			          }else{
			         	 //退回
			         	variables.put("sypd", "1");
			          }
				taskService.complete(taskId,variables);
				this.getResponse().getWriter().println("{\"result\":true}");
			}catch (Exception e) {
				this.getResponse().getWriter().println("{\"result\":false}");
			}
		}
	
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Cjjlb getCjjlb(){
		return this.cjjlb;
	}

	public void setCjjlb(Cjjlb cjjlb){
		this.cjjlb = cjjlb;
	}
    
	public Cktzs getCktzs() {
		return cktzs;
	}

	public void setCktzs(Cktzs cktzs) {
		this.cktzs = cktzs;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }
       
    
	public Date getQueryFhsjStart(){
		return this.queryFhsjStart;
	}

	public void setQueryFhsjStart(Date queryFhsjStart){
		this.queryFhsjStart = queryFhsjStart;
	}

	public Date getQueryFhsjEnd(){
		return this.queryFhsjEnd;
	}

	public void setQueryFhsjEnd(Date queryFhsjEnd){
		this.queryFhsjEnd = queryFhsjEnd;
	}

	public Date getQuerySysjStart(){
		return this.querySysjStart;
	}

	public void setQuerySysjStart(Date querySysjStart){
		this.querySysjStart = querySysjStart;
	}

	public Date getQuerySysjEnd(){
		return this.querySysjEnd;
	}

	public void setQuerySysjEnd(Date querySysjEnd){
		this.querySysjEnd = querySysjEnd;
	}

	public PaymentItemDelay getPaymentItemDelay() {
		return paymentItemDelay;
	}

	public void setPaymentItemDelay(PaymentItemDelay paymentItemDelay) {
		this.paymentItemDelay = paymentItemDelay;
	}
   
   
}
