package com.jshx.billPayment.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.neusoft.egov.utils.billendnumber;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.billManager.entity.Indeticur;
import com.jshx.billPayment.entity.Bill;
import com.jshx.billPayment.entity.Billpayment;
import com.jshx.billPayment.service.BillpaymentService;

public class BillpaymentAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	/**
	 * 实体类
	 */
	private Billpayment billpayment = new Billpayment();

	/**
	 * 业务类
	 */
	@Autowired
	private BillpaymentService billpaymentService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	
	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	
    public String execute()
    {
    	return SUCCESS;
    }
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != billpayment){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != billpayment.getEndno()) && (0 < billpayment.getEndno().trim().length())){
				paraMap.put("endno", "%" + billpayment.getEndno().trim() + "%");
			}

			if ((null != billpayment.getStartno()) && (0 < billpayment.getStartno().trim().length())){
				paraMap.put("startno", "%" + billpayment.getStartno().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|startno|endno|sequentid|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = billpaymentService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != billpayment)&&(null != billpayment.getId()))
			billpayment = billpaymentService.getById(billpayment.getId());
		
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		view();
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		List<Bill>  list = new ArrayList<Bill>();
		FileInputStream in = null;
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		if ("add".equalsIgnoreCase(this.flag)){
			String startNo =billpayment.getStartno();
			String endNo = billpayment.getEndno();
			int count = Integer.parseInt(endNo)-Integer.parseInt(startNo);
			if(count>10000)
			{
				throw new Exception("一次最多只能入库一万张！");
			}
			int length =billpayment.getStartno().length();
			int end = Integer.valueOf(billpayment.getEndno());
			 String uuid =UUID.randomUUID().toString().replaceAll("-", "");
			for(int i=Integer.parseInt(startNo);i<=end;i++)
			{
				String no = buwei(String.valueOf(i),length);
				Bill 	indeticur = new Bill();
				indeticur.setDelFlag(0);
				indeticur.setIsrece(0);
				indeticur.setNo(no);
				indeticur.setSort(i);
				indeticur.setRkTime(sdf.format(new Date()));
				indeticur.setSequenceID(uuid);
				list.add(indeticur);
				
			}
			billpaymentService.batchupdate(list);
			billpayment.setDeptId(this.getLoginUserDepartmentId());
			billpayment.setDelFlag(0);
			billpayment.setSequentid(uuid);
			billpaymentService.save(billpayment);
			
		}else{
			billpaymentService.update(billpayment);
		}
		
		return RELOAD;
	}
	private String buwei(String no,int length)
	{
		String s ="";
		 StringBuffer sb = null;
		 while (no.length() < length) {
	           sb = new StringBuffer();
	           sb.append("0").append(no);// 左补0
	           no = sb.toString();
	          
	     }

		 s = no;
		 return s;
	}
	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != billpayment)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到billpayment中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
	    	String[] id = ids.split("\\|");
	    	for(int i=0;i<id.length;i++)
	    	{
	    		billpayment = billpaymentService.getById(id[i]);
	    		
	    	}
			billpaymentService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public Billpayment getBillpayment(){
		return this.billpayment;
	}

	public void setBillpayment(Billpayment billpayment){
		this.billpayment = billpayment;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }
       
    
}
