package com.jshx.billPayment.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.billPayment.dao.BillpaymentDao;
import com.jshx.billPayment.entity.Bill;
import com.jshx.billPayment.entity.Billpayment;
import com.jshx.billPayment.service.BillpaymentService;

@Service("billpaymentService")
public class BillpaymentServiceImpl extends BaseServiceImpl implements BillpaymentService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("billpaymentDao")
	private BillpaymentDao billpaymentDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return billpaymentDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Billpayment getById(String id)
	{
		return billpaymentDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Billpayment billpayment)
	{
		billpaymentDao.save(billpayment);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Billpayment billpayment)
	{
		billpaymentDao.update(billpayment);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=billpaymentDao.findBillpayment(paraMap);
		
		billpaymentDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    billpaymentDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public void save(Bill model) {
		billpaymentDao.save(model);
		
	}

	@Override
	public void update(Bill model) {
		billpaymentDao.update(model);
		
	}

	@Override
	public void batchupdate(List<Bill> list) {
		// TODO Auto-generated method stubreturn billpaymentDao.getById(id);
	    billpaymentDao.batchupdate(list);
	}

	@Override
	public Bill getBillByNo(Map<String, Object> paraMap) {
		Bill bill = (Bill) billpaymentDao.findObjectByFieldsMap(Bill.class,paraMap);
		return bill;
	}

	@Override
	public int findcountByMap(Map<String, Object> paraMap) {
		return billpaymentDao.findcountByMap(paraMap);
	}
}
