package com.jshx.billPayment.service;

import java.util.List;
import java.util.Map;

import com.jshx.core.base.service.BaseService;
import com.jshx.core.base.vo.Pagination;
import com.jshx.billManager.entity.Indeticur;
import com.jshx.billPayment.entity.Bill;
import com.jshx.billPayment.entity.Billpayment;

public interface BillpaymentService extends BaseService
{

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap);

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Billpayment getById(String id);

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Billpayment model);
	public void save(Bill model);
	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Billpayment model);
	public void update(Bill model);
	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	public void delete(String[] ids);

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	public void deleteWithFlag(String ids);
	public void batchupdate(List<Bill> list);
	
	public Bill  getBillByNo(Map<String, Object> paraMap);
	public int findcountByMap(Map<String, Object> paraMap);
	
}
