package com.jshx.billManager.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.sql.Blob;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.neusoft.egov.utils.billendnumber;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.billManager.entity.BillManager;
import com.jshx.billManager.entity.Indeticur;
import com.jshx.billManager.service.BillManagerService;

public class BillManagerAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;
	private String message;
	/**
	 * 实体类
	 */
	private BillManager billManager = new BillManager();

	/**
	 * 业务类
	 */
	@Autowired
	private BillManagerService billManagerService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;
	
	private List<Indeticur> indeticurList;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	
	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	
	public String execute()
	{
		
		return SUCCESS;
	}
	public String execute1()
	{
		
		return SUCCESS;
	}
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != billManager){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != billManager.getStartno()) && (0 < billManager.getStartno().trim().length())){
				paraMap.put("startno", "%" + billManager.getStartno().trim() + "%");
			}

			if ((null != billManager.getRktime()) && (0 < billManager.getRktime().trim().length())){
				paraMap.put("rktime", "%" + billManager.getRktime().trim() + "%");
			}

		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|startno|endno|rktime|sequentID|totalCount|alreadyUse|notUse|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = billManagerService.findByPage(pagination, paraMap);
		List<BillManager> indeticurlist = pagination.list;
		for(BillManager BillManager:indeticurlist) {
			BillManager.setStartno((BillManager.getStartno().length()<15)?BillManager.getStartno().substring(0, 9):BillManager.getStartno().substring(0, 19));
			BillManager.setEndno((BillManager.getEndno().length()<15)?BillManager.getEndno().substring(0, 9):BillManager.getEndno().substring(0, 19));
			BillManager.setTotalCount(Integer.parseInt((BillManager.getEndno().length()<15)?BillManager.getEndno():BillManager.getEndno().substring(11))-Integer.parseInt((BillManager.getStartno().length()<15)?BillManager.getStartno():BillManager.getStartno().substring(11))+1);
			
			Map<String, Object> paraMap1 = new HashMap<String, Object>();
			Pagination pagination1 = new Pagination(this.getRequest());
			paraMap1.put("sequenceID", BillManager.getSequentID());
			paraMap1.put("isrece", 1);
			pagination1 = billManagerService.findByIndeticurPage(pagination1, paraMap1);
			BillManager.setAlreadyUse(pagination1.getTotalCount());
			BillManager.setNotUse(BillManager.getTotalCount()-pagination1.getTotalCount());
		}

		pagination.list=indeticurlist;
		convObjectToJson(pagination, config);
	}
	
	public void list1() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != billManager){
		    //设置查询条件，开发人员可以在此增加过滤条件
			if ((null != billManager.getStartno()) && (0 < billManager.getStartno().trim().length())){
				paraMap.put("no",  billManager.getStartno().trim()+billendnumber.getCode(billManager.getStartno().trim()) );
			}


		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		paraMap.put("sequenceID", ids);
		paraMap.put("isrece", 0);
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|no|zsdw|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = billManagerService.findByIndeticurPage(pagination, paraMap);
		List<Map> indeticurlist = pagination.list;
		for(Map map:indeticurlist)
		{
			String no = (String) map.get("NO");
			map.put("no", (no.length()<15)?no.substring(0, 9):no.substring(0, 19));
		}
		pagination.list=indeticurlist;
		convObjectToJson(pagination, config);
	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != billManager)&&(null != billManager.getId())) {
			billManager = billManagerService.getById(billManager.getId());
		}
		billManager.setStartno((billManager.getStartno().length()<15)?billManager.getStartno().substring(0, 9):billManager.getStartno().substring(0, 19));
		billManager.setEndno((billManager.getEndno().length()<15)?billManager.getEndno().substring(0, 9):billManager.getEndno().substring(0, 19));
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception{
		//view();
	    return EDIT;
	}

	public String initEdit1() throws Exception{
		//view();
	    return EDIT;
	}
	
	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		FileInputStream in = null;
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Map<String, Object> paraMap = new HashMap<String, Object>();
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	
		if ("add".equalsIgnoreCase(this.flag)){
			String startNo =billManager.getStartno().substring(0, 9);
			int length =billManager.getStartno().length();
			int end = Integer.parseInt(startNo)+Integer.parseInt(billManager.getCount())-1;
			String endNO = String.valueOf(end);
			endNO= buwei(endNO,length);
			 String uuid =UUID.randomUUID().toString().replaceAll("-", "");
			for(int i=Integer.parseInt(startNo);i<=end;i++)
			{
				String no = buwei(String.valueOf(i),length);
				paraMap.put("no", no);
				paraMap.put("sequenceID", billManager.getSequentID());
				paraMap.put("isrece", 0);
				Indeticur indeticur = billManagerService.findIndeticurByNo(paraMap);
				indeticur.setIsrece(1);
				billManagerService.update(indeticur);
			}
		}else{
			billManagerService.update(billManager);
		}
		
		return RELOAD;
	}
	
	private static final int MAX_INSERT_COUNT = 10000;
	public String save1() throws Exception{
		
		List<Indeticur>  list = new ArrayList<Indeticur>();
		FileInputStream in = null;
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
	try
	{
		if ("add".equalsIgnoreCase(this.flag)){
			String startNo =billManager.getStartno();
			String endNo = billManager.getEndno();
			int count = Integer.parseInt(endNo)-Integer.parseInt(startNo);
			if(count>10000)
			{
				throw new Exception("一次最多只能入库一万张！");
			}
			int length =billManager.getStartno().length();
			int end = Integer.valueOf(billManager.getEndno());
			 String uuid =UUID.randomUUID().toString().replaceAll("-", "");
			for(int i=Integer.parseInt(startNo);i<=end;i++)
			{
				String no = buwei(String.valueOf(i),length);
				Indeticur 	indeticur = new Indeticur();
				indeticur.setDelFlag(0);
				indeticur.setIsrece(0);
				indeticur.setNo(no);
				indeticur.setIsprint("0");
				indeticur.setSort(i);
				indeticur.setRkTime(sdf.format(new Date()));
				indeticur.setSequenceID(uuid);
				list.add(indeticur);
				//billManagerService.save(indeticur);
			}
			// 批量插入indeticur然后更新billManager
			billManagerService.batchupdate(list);
			billManager.setDeptId(this.getLoginUserDepartmentId());
			billManager.setDelFlag(0);
			billManager.setEndno(endNo+billendnumber.getCode(endNo));
			billManager.setRktime(sdf.format(new Date()));
			billManager.setStartno(startNo+billendnumber.getCode(startNo));
			billManager.setSequentID(uuid);
			billManagerService.save(billManager);
			
		}else{
			billManagerService.update(billManager);
		}
	}catch(Exception e)
	{
		logger.error(e.getMessage());
		 message = "出错了！" + e.getMessage();
	}
		return RELOAD;
	}
	
	public void isExit() throws Exception
	{
		 JSONObject jsonObject = new JSONObject();
		getResponse().setContentType("application/json;charset=UTF-8");
		getResponse().setCharacterEncoding("utf-8");
		getResponse().setHeader("Charset", "utf-8");
		getResponse().setHeader("Cache-Control", "no-cache");
		try
		{
			String no = ids+billendnumber.getCode(ids);
			Map<String, Object> paraMap = new HashMap<String, Object>();
			paraMap.put("no", no);
			Indeticur indeticur = billManagerService.findIndeticurByNo(paraMap);
			if(indeticur!=null)
			{
				jsonObject.put("result", true);
				jsonObject.put("info", "票据号"+ids+"已经存在！");
				getResponse().getWriter().println(jsonObject.toString());
			}else
			{
				jsonObject.put("result", false);
				getResponse().getWriter().println(jsonObject.toString());
			}
		}catch(Exception e)
		{
			jsonObject.put("result", true);
			jsonObject.put("info", e.getMessage());
			getResponse().getWriter().println(jsonObject.toString());
		}
	}
	private String buwei(String no,int length)
	{
		String s ="";
		 StringBuffer sb = null;
		 while (no.length() < length) {
	           sb = new StringBuffer();
	           sb.append("0").append(no);// 左补0
	           no = sb.toString();
	          
	     }

		 s = no+billendnumber.getCode(no);
		 return s;
	}
	// 针对二十位计算补位
	private String buwei1(String no) {
		return no + billendnumber.getCode(no);
	}
	private String buwei2(String no, int length	) {
		String s ="";
		StringBuffer sb = null;
		while (no.length() < length) {
			sb = new StringBuffer();
			sb.append("0").append(no);// 左补0
			no = sb.toString();
		}
		return no;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != billManager)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到billManager中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			billManagerService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public BillManager getBillManager(){
		return this.billManager;
	}

	public void setBillManager(BillManager billManager){
		this.billManager = billManager;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

	public List<Indeticur> getIndeticurList() {
		return indeticurList;
	}

	public void setIndeticurList(List<Indeticur> indeticurList) {
		this.indeticurList = indeticurList;
	}
	public String getMessage() {
		return message;
	}
	public void setMessage(String message) {
		this.message = message;
	}
    
    
    
}
