package com.jshx.billManager.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.entity.BaseModel;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.HibernateUtil;
import com.jshx.billManager.entity.BillManager;
import com.jshx.billManager.entity.Indeticur;
import com.jshx.billManager.dao.BillManagerDao;

@Component("billManagerDao")
public class BillManagerDaoImpl extends BaseDaoImpl implements BillManagerDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findBillManagerByMap", paraMap, page);
	}
	@Override
	public List findByIndeticurPage(Map<String, Object> paraMap) {
		return this.findListBySqlIdReturnMap("findIndeticurByMap3", paraMap);
	}
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findBillManager(Map<String, Object> paraMap){
		return this.findListByHqlId("findIndeticurByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public BillManager getById(String id)
	{
		return (BillManager)this.getObjectById(BillManager.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(BillManager billManager)
	{
		billManager.setId(null);
		this.saveOrUpdateObject(billManager);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(BillManager billManager)
	{
		this.saveOrUpdateObject(billManager);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(BillManager.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		BillManager billManager = (BillManager)this.getObjectById(BillManager.class, id);
		billManager.setDelFlag(1);
		this.saveObject(billManager);
	}

	@Override
	public void save(Indeticur model) {
		model.setId(null);
		this.saveOrUpdateObject(model);
		
	}

	@Override
	public String findNo(Map<String, Object> paraMap) {
		List list = this.findListByHqlId("findIndeticurByMap", paraMap);
		Indeticur Indeticur = (com.jshx.billManager.entity.Indeticur) list.get(0);
		return Indeticur.getNo();
	}

	@Override
	public int findcountByMap(Map<String, Object> paraMap) {
		List list = this.findListByHqlId("findIndeticurByMap", paraMap);
		return list.size();
	}

	@Override
	public Indeticur findIndeticurByNo(Map<String, Object> paraMap) {
		List list = this.findListByHqlId("findIndeticurByMap", paraMap);
		
		if(list.size()>0)
		{
			Indeticur   Indeticur = (Indeticur)list.get(0);
			return Indeticur;
		}
		return null;
	}

	@Override
	public void update(Indeticur model) {
		this.saveOrUpdateObject(model);
		
	}
	@Override
	public Indeticur getIndeticurById(String id) {
		return (Indeticur)this.getObjectById(Indeticur.class, id);
	}
	@Override
	public void batchupdate(List<Indeticur> list) {
	    Session session = null;  
        if (list != null && list.size() > 0) {  
            try {  
                session = HibernateUtil.getSession();   
                session.beginTransaction(); 
                Indeticur Indeticur = null; 
               
                for (int i = 0; i < list.size(); i++) {  
                	Indeticur = list.get(i); 
                    session.saveOrUpdate(Indeticur); 
                    if (i % 100 == 0) {  
                        session.flush();  
                        session.clear();  
                    }  
                }  
                session.getTransaction().commit(); // 提交事物  
            } catch (Exception e) {  
                e.printStackTrace(); // 打印错误信息  
                session.getTransaction().rollback(); // 出错将回滚事物  
            } 
        }  
    }
	@Override
	public Pagination findByIndeticurPage(Pagination page, Map<String, Object> paraMap) {
//		return this.findPageByHqlId("findIndeticurByMap2", paraMap, page);
		return this.findPageBySqlIdReturnMap("findIndeticurByMap2", paraMap, page);
	}




	
}
