package com.jshx.account.paymentVoucherHis.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.exception.BasalException;
import com.jshx.paymentItemDelayHis.dao.PaymentItemDelayHisDao;
import com.jshx.paymentItemDelayHis.entity.PaymentItemDelayHis;
import com.jshx.paymentItemHis.dao.PaymentItemHisDao;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.account.paymentVoucherHis.dao.PaymentVoucherHisDao;
import com.jshx.account.paymentVoucherHis.entity.PaymentVoucherHis;
import com.jshx.account.paymentVoucherHis.service.PaymentVoucherHisService;
import com.jshx.common.utils.Constant;

@Service("paymentVoucherHisService")
public class PaymentVoucherHisServiceImpl extends BaseServiceImpl implements PaymentVoucherHisService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("paymentVoucherHisDao")
	private PaymentVoucherHisDao paymentVoucherHisDao;
	
	@Autowired()
	private PaymentItemHisDao paymentItemHisDao;
	
	@Autowired()
	private PaymentItemDelayHisDao paymentItemDelayHisDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return paymentVoucherHisDao.findByPage(page, paraMap);
	}
	
	/**
	 * 不分页查询
	 * @param paraMap
	 * @return
	 */
	public List findPaymentVoucherHis(Map<String, Object> paraMap)
	{
		return paymentVoucherHisDao.findPaymentVoucherHis(paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public PaymentVoucherHis getById(String id)
	{
		return paymentVoucherHisDao.getById(id);
	}
	
	/**
	 * 根据票据编码查询信息
	 * @param voucherCode
	 * @return
	 */
	public PaymentVoucherHis getByVoucherCode(String voucherCode)
	{
		Map<String,Object> paraMap = new HashMap<String,Object>();
		paraMap.put("voucherCode", voucherCode);
		paraMap.put("delFlag", 0);
		PaymentVoucherHis paymentVoucherHis = (PaymentVoucherHis)paymentVoucherHisDao.findObjectByFieldsMap(PaymentVoucherHis.class, paraMap);
		return paymentVoucherHis;
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(PaymentVoucherHis paymentVoucherHis)
	{
		paymentVoucherHisDao.save(paymentVoucherHis);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(PaymentVoucherHis paymentVoucherHis)
	{
		paymentVoucherHisDao.update(paymentVoucherHis);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=paymentVoucherHisDao.findPaymentVoucherHis(paraMap);
		
		paymentVoucherHisDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
		try{
			PaymentVoucherHis paymentVoucherHis = paymentVoucherHisDao.getById(ids);
			if("0".equals(paymentVoucherHis.getType())){//非缓缴项目
				PaymentItemHis paymentItemHis = paymentItemHisDao.getById(paymentVoucherHis.getRelateId());
				paymentItemHis.setNonTaxStatus(Constant.NON_TAX_STATUS_0);
				paymentItemHisDao.update(paymentItemHis);
	    	}else if("1".equals(paymentVoucherHis.getType())){//缓缴项目
	    		PaymentItemDelayHis paymentItemDelayHis = paymentItemDelayHisDao.getById(paymentVoucherHis.getRelateId());
	    		paymentItemDelayHis.setNonTaxStatus(Constant.NON_TAX_STATUS_0);
	    		paymentItemDelayHisDao.update(paymentItemDelayHis);
	    	}
			paymentVoucherHisDao.deleteWithFlag(ids);
		}catch(Exception e){
			throw new BasalException(BasalException.ERROR, "数据异常");
		}
		
	}

	@Override
	public PaymentVoucherHis getPayMentByorderId(String orderid) {
		Map<String,Object> paraMap = new HashMap<String,Object>();
		paraMap.put("orderId", orderid);
		paraMap.put("applyStatus", "0");
		PaymentVoucherHis PaymentVoucherHis = (PaymentVoucherHis)paymentVoucherHisDao.findObjectByFieldsMap(PaymentVoucherHis.class, paraMap);

		return PaymentVoucherHis;
	}


}
