package com.jshx.account.paymentVoucherHis.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.account.paymentVoucherHis.entity.PaymentVoucherHis;
import com.jshx.account.paymentVoucherHis.dao.PaymentVoucherHisDao;

@Component("paymentVoucherHisDao")
public class PaymentVoucherHisDaoImpl extends BaseDaoImpl implements PaymentVoucherHisDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findPaymentVoucherHisByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findPaymentVoucherHis(Map<String, Object> paraMap){
		return this.findListByHqlId("findPaymentVoucherHisByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public PaymentVoucherHis getById(String id)
	{
		return (PaymentVoucherHis)this.getObjectById(PaymentVoucherHis.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(PaymentVoucherHis paymentVoucherHis)
	{
		paymentVoucherHis.setId(null);
		this.saveOrUpdateObject(paymentVoucherHis);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(PaymentVoucherHis paymentVoucherHis)
	{
		this.saveOrUpdateObject(paymentVoucherHis);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(PaymentVoucherHis.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		PaymentVoucherHis paymentVoucherHis = (PaymentVoucherHis)this.getObjectById(PaymentVoucherHis.class, id);
		paymentVoucherHis.setDelFlag(1);
		this.saveObject(paymentVoucherHis);
	}
}
