package com.jshx.account.paymentVoucher.web;

import com.jshx.account.paymentVoucher.service.PaymentVoucherService;
import com.jshx.account.paymentVoucherHis.entity.PaymentVoucherHis;
import com.jshx.account.paymentVoucherHis.service.PaymentVoucherHisService;
import com.jshx.billManager.entity.BillManager;
import com.jshx.billManager.entity.Indeticur;
import com.jshx.billManager.service.BillManagerService;
import com.jshx.billlq.entity.Billlq;
import com.jshx.billlq.service.BilllqService;
import com.jshx.cktzs.entity.Cktzs;
import com.jshx.cktzs.service.CktzsService;
import com.jshx.common.utils.Constant;
import com.jshx.common.utils.NumberToCN;
import com.jshx.core.base.action.BaseAction;
import com.jshx.kpsjgl.entity.Kpsjgl;
import com.jshx.kpsjgl.service.KpsjglService;
import com.jshx.paymentItemDelay.entity.PaymentItemDelay;
import com.jshx.paymentItemDelay.service.PaymentItemDelayService;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.paymentItemHis.service.PaymentItemHisService;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.zsdw.entity.Zsdw;
import com.jshx.zsdw.service.ZsdwService;
import com.neusoft.egov.utils.billendnumber;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

public class PaymentVoucherNewAction extends BaseAction {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    private PaymentVoucherHis paymentVoucherHis = new PaymentVoucherHis();

    private PaymentItemHis paymentItemHis = new PaymentItemHis();
    private Xmxxb xmxxb = new Xmxxb();

    @Autowired
    private KpsjglService kpsjglService;

    @Autowired
    private PaymentItemHisService paymentItemHisService;
    @Autowired
    private PaymentVoucherHisService paymentVoucherHisService;
    @Autowired
    private BillManagerService billManagerService;
    @Autowired
    private ZsdwService zsdwService;
    @Autowired
    private PaymentVoucherService paymentVoucherService;
    @Autowired
    private BilllqService billlqService;
    @Autowired
    private XmxxbService xmxxbService;
    @Autowired
    private CktzsService cktzsService;
    @Autowired
    private PaymentItemDelayService paymentItemDelayService;

    /**
     * 主键ID，用于接收页面提交的主键ID信息
     */

    public String id;

    public String mode;

    private String flag;
    /**
     * 征收单位
     */
    private String zsdw;

    /**
     * 征收单位编码
     */
    private String zsdwbm;

    /**
     * 区划码
     */
    private String qhm;

    /**
     * 收款人全称
     */
    private String skrqc;
    /**
     * 收款人账户
     */
    private String skrzh;

    /**
     * 收款人开户行
     */
    private String skrkhh;

    /**
     * 项目编码
     */
    private String xmbm;

    /**
     * 收入项目名称
     */
    private String srxmmc;

    /**
     * 项目数量
     */
    private String xmsl;

    /**
     * 项目金额
     */
    private String xmje;

    /**
     * 作废标识
     */
    private String zfbz;

    /**
     * 单位名称
     */
    private String dwmc;

    /**
     * 金额大写
     */
    private String amount_CN;
    private String pjhm;
    private String isDelay;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String test111() {
        try{
            //暂时将数据存在配置文件内
//			zsdw = SysPropertiesUtil.getProperty("Zsdw");
//			zsdwbm = SysPropertiesUtil.getProperty("Zsdwbm");
//			qhm = SysPropertiesUtil.getProperty("Qhm");
//			skrqc = SysPropertiesUtil.getProperty("Skrqc");
//			skrzh = SysPropertiesUtil.getProperty("Skrzh");
//			skrkhh = SysPropertiesUtil.getProperty("Skrkhh");
//			xmbm = SysPropertiesUtil.getProperty("Xmbm");
//			srxmmc = SysPropertiesUtil.getProperty("Srxmmc");

            Kpsjgl kp=kpsjglService.findbygllb("001");
            zsdw = kp.getZsdw();
            zsdwbm = kp.getZsdwbm();
            qhm = kp.getQhm();
            skrqc = kp.getKrqc();
            skrzh = kp.getSkrzh();
            skrkhh = kp.getSkrkhh();
            xmbm = kp.getXmbm();
            srxmmc = kp.getSrxmmc();
            paymentItemHis = paymentItemHisService.getById(id);
            if(null!=paymentItemHis){
                //获取项目信息
                amount_CN = NumberToCN.number2CNMontrayUnit(new BigDecimal(paymentItemHis.getPtyjje()));
            }
        }catch(Exception e){
            logger.error(e.getMessage());
        }
        return SUCCESS;
    }

    //特殊录入批量校验
    public void checkVoucherCodetb2() throws Exception{
        int result = 0;
        String message="";
        try {
            String []resu=pjhm.split("\\,");
            if(resu.length>0){
                for (int i = 0; i < resu.length; i++) {
                    String pj=resu[i];
                    if (pj.length()>15) {
                        break;
                    }
                    if(validVoucherCode(pj)){
                        //校验票据是否被使用
                        if(IsExistVoucherCode(pj)){
                            //校验此票据是否已入库被领用
                            if(IsStoredCode(pj)){
                                result = 0;
                            }else{
                                result = 3;
                                message=pj;
                                break;
                            }
                        }else{
                            result = 2;
                            message=pj;
                            break;
                        }
                    }else{
                        result = 1;
                        message=pj;
                        break;
                    }
                }
            }
            else{
                result = 5;
            }
            this.getResponse().getWriter().println("{\"result\":"+result+",\"message\":\"" + message + "\"}");

        } catch (Exception e) {
            result = 4;
            e.printStackTrace();
            logger.error(e.getMessage());
            this.getResponse().getWriter().println("{\"result\":"+ result +"}");
        }
    }

    /**
     * 校验项目情况（审批是否通过、单位是否有逾期费用未缴清）
     * @throws Exception
     */
    public void checkPoject2() throws Exception{
        boolean result = true;
        String message = "成功！";
        paymentItemHis = paymentItemHisService.getById(id);
        //根据项目表主键查询此项目是否审批通过 （此项目存在审核未通过先缴费的情况）
        xmxxb = xmxxbService.getById(paymentItemHis.getXmbzj());
        if(null != xmxxb){
            if(!"0".equals(xmxxb.getIssptg())){
                result = false;
                message = "该项目审批未通过，暂时无法打印！";
            }else{
                //判断此项目是否解锁，若解锁则无需判断此单位的催缴记录（业务要求：有催缴记录的单位未缴清费用之前所有项目不允许打印）
                if(!Constant.STATUS_LOCK_2.equals(paymentItemHis.getLockFlag())){
                    if(hasDelayProject(paymentItemHis.getDwmc())){
                        result = false;
                        message = "该单位有逾期未缴清的项目，暂时无法打印！";
                    }
                }
            }
        }else{
            result = false;
            message = "该项目不存在，请联系管理员！";
        }
        Kpsjgl kp=kpsjglService.findbygllb("001");
        if(kp.getBdjg()==1){
            result = false;
            message = "非税基础数据同步有误,请联系管理员!";
        }

        this.getResponse().getWriter().println("{\"result\":" + result + ",\"message\":\"" + message + "\"}");
    }

    /**
     * 不上传非税系统
     * @throws Exception
     */
    public String uploadVoucherInfotb2() throws Exception{
//		String result ="1|成功";
        String[] splits = paymentVoucherHis.getVoucherCode().split("\\,");
        paymentVoucherHis.setDelFlag(0);
        paymentVoucherHis.setDeptId(this.getLoginUserDepartmentId());
        paymentVoucherHis.setOperator(this.getLoginUser().getDisplayName());
        paymentVoucherHis.setPrintDate(new Date());

        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String pjbz="";
        pjbz="关联编号:"+paymentVoucherHis.getVoucherCode()+".";
        paymentVoucherHis.setDestroyStatus(Constant.VOUCHER_DESTROY_STATUS_0);//默认未缴销
        //四位全局校验码
        for (int i = 0; i < splits.length; i++) {
            StringBuffer source = new StringBuffer();
            BigDecimal areaBd = new BigDecimal(paymentVoucherHis.getArea());
            String area = areaBd.setScale(2, BigDecimal.ROUND_HALF_UP).toString();
            BigDecimal amountBd = new BigDecimal(paymentVoucherHis.getAmount());
            String amount = amountBd.setScale(2, BigDecimal.ROUND_HALF_UP).toString();
            if(i==0){
                source.append(splits[0]).append(format.format(new Date())).append(paymentVoucherHis.getZsdwbm()).append(paymentVoucherHis.getPayerName()).append(paymentVoucherHis.getSkrzh()).append(paymentVoucherHis.getPayType()).append(paymentVoucherHis.getXmbm()).append(area).append(amount);
                paymentVoucherHis.setApplyStatus(Constant.VOUCHER_USE_STATUS_0);
                paymentVoucherHis.setMessage("上报：成功");
            }else{
                source.append(splits[i]).append(format.format(new Date())).append(paymentVoucherHis.getZsdwbm()).append(paymentVoucherHis.getPayerName()).append(paymentVoucherHis.getSkrzh()).append(paymentVoucherHis.getPayType()).append(paymentVoucherHis.getXmbm()).append(area).append(amount);
                paymentVoucherHis.setApplyStatus(Constant.VOUCHER_USE_STATUS_1);
                paymentVoucherHis.setMessage("作废：成功");
            }
            if(splits[i].length()<15) {
                String validCode = billendnumber.calculateBillMac(source.toString());
                paymentVoucherHis.setValidCode(validCode);//全票面信息校验码
            }
            //模拟票据领取发放功能
			List<Indeticur> list = new ArrayList<Indeticur>();
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			String startNo =splits[i];
			String endNo = splits[i];
			String uuid = UUID.randomUUID().toString().replaceAll("-", "");
			String no = splits[i];
			Indeticur indeticur = new Indeticur();
			indeticur.setDelFlag(0);
			indeticur.setIsrece(0);
			indeticur.setNo(no);
			indeticur.setIsprint("0");
			indeticur.setSort(0);
			indeticur.setRkTime(sdf.format(new Date()));
			indeticur.setSequenceID(uuid);

			indeticur.setIsrece(1);
			indeticur.setPerson(this.getLoginUser().getDisplayName());
			indeticur.setState("0");
			indeticur.setZsdw("市收费处");
			list.add(indeticur);
			// 批量插入indeticur然后更新billManager
			billManagerService.batchupdate(list);
			BillManager billManager = new BillManager();
//		billManager.setCount("1");
			billManager.setDeptId(this.getLoginUser().getDept().getId());
			billManager.setDelFlag(0);
			billManager.setEndno(endNo);
			billManager.setRktime(sdf.format(new Date()));
			billManager.setStartno(startNo);
			billManager.setSequentID(uuid);
			billManagerService.save(billManager);

			Billlq billlq = new Billlq();
			billlq.setCount("1");
			billlq.setPerson(this.getLoginUser().getDisplayName());
			billlq.setDeptId(this.getLoginUser().getDept().getId());
			billlq.setZsdw(this.getLoginUser().getDept().getDeptName());
			billlq.setDelFlag(0);
			billlq.setStartno(startNo);
			billlq.setEndno(endNo);
			billlq.setLqtime(sdf.format(new Date()));
			billlqService.save(billlq);
			paymentVoucherHis.setVoucherCode(splits[i]);
			paymentVoucherService.addtb(paymentVoucherHis, "1", isDelay, id,pjbz);
        }

        return RELOAD;
    }
    /**
     * 校验票据号码正确性
     * @param voucherCode
     * @return
     */
    private boolean validVoucherCode(String voucherCode){
        String validNo = billendnumber.getCode(voucherCode.substring(0, voucherCode.length()-1));
        //校验位
        String lastNo = voucherCode.substring(voucherCode.length()-1, voucherCode.length());
        if(validNo.equals(lastNo)){
            return true;
        }
        return false;
    }

    /**
     * 判断此票号是否已使用
     * @param voucherCode
     * @return
     */
    private boolean IsExistVoucherCode(String voucherCode){
        Map<String,Object> paraMap = new HashMap<String,Object>();
        paraMap.put("code", voucherCode);
        List list = paymentVoucherHisService.findPaymentVoucherHis(paraMap);
        if(null!=list && list.size()>0){
            return false;
        }
        return true;
    }

    /**
     * 判断此票据是否已入库被领用
     * @param voucherCode
     * @return
     */
    private boolean IsStoredCode(String voucherCode){
        Map<String,Object> paraMap = new HashMap<String,Object>();
        Zsdw dwdm=zsdwService.getzsdw(this.getLoginUserDepartmentId());
        paraMap.put("isrece", 1);
        paraMap.put("zsdw", "%"+dwdm.getZsdw()+"%");
        paraMap.put("no", voucherCode);
        Indeticur ind = billManagerService.findIndeticurByNo(paraMap);
        if(null != ind){
            return true;
        }
        return false;
    }

    /**
     * 查询是否有催缴项目记录
     * @param dwmc 单位名称
     * @throws Exception
     */
    private boolean hasDelayProject(String dwmc) throws Exception{
        Map<String, Object> paraMap = new HashMap<String, Object>();
        Map<String, Object> paraMap2 = new HashMap<String, Object>();
        //单位名称
        paraMap.put("dwmc",dwmc);
        paraMap.put("isjk","0");
        //查询催款记录表
        List<Cktzs> cklist=cktzsService.findByall(paraMap);
        paraMap2.put("dwmc2",dwmc);
        List<PaymentItemDelay> delayHis = paymentItemDelayService.findall(paraMap2);
        if(null!=cklist && cklist.size()>0)
            return true;
        else if(null!=delayHis && delayHis.size()>0)
            return true;
        else
            return false;
    }


    /**
     * 开票数据录入
     * @return
     */
    public String dataRecordAdd(){
        try{
            //暂时将数据存在配置文件内
//			zsdw = SysPropertiesUtil.getProperty("Zsdw");
//			zsdwbm = SysPropertiesUtil.getProperty("Zsdwbm");
//			qhm = SysPropertiesUtil.getProperty("Qhm");
//			skrqc = SysPropertiesUtil.getProperty("Skrqc");
//			skrzh = SysPropertiesUtil.getProperty("Skrzh");
//			skrkhh = SysPropertiesUtil.getProperty("Skrkhh");
//			xmbm = SysPropertiesUtil.getProperty("Xmbm");
//			srxmmc = SysPropertiesUtil.getProperty("Srxmmc");

            Kpsjgl kp=kpsjglService.findbygllb("001");
            zsdw = kp.getZsdw();
            zsdwbm = kp.getZsdwbm();
            qhm = kp.getQhm();
            skrqc = kp.getKrqc();
            skrzh = kp.getSkrzh();
            skrkhh = kp.getSkrkhh();
            xmbm = kp.getXmbm();
            srxmmc = kp.getSrxmmc();
            paymentItemHis = paymentItemHisService.getById(id);
            if(null!=paymentItemHis){
                //获取项目信息
                amount_CN = NumberToCN.number2CNMontrayUnit(new BigDecimal(paymentItemHis.getPtyjje()));
            }
        }catch(Exception e){
            logger.error(e.getMessage());
        }
        return SUCCESS;
    }

    public PaymentVoucherHis getPaymentVoucherHis() {
        return paymentVoucherHis;
    }

    public void setPaymentVoucherHis(PaymentVoucherHis paymentVoucherHis) {
        this.paymentVoucherHis = paymentVoucherHis;
    }

    public PaymentItemHis getPaymentItemHis() {
        return paymentItemHis;
    }

    public void setPaymentItemHis(PaymentItemHis paymentItemHis) {
        this.paymentItemHis = paymentItemHis;
    }

    public String getFlag() {
        return flag;
    }

    public void setFlag(String flag) {
        this.flag = flag;
    }

    public String getZsdw() {
        return zsdw;
    }

    public void setZsdw(String zsdw) {
        this.zsdw = zsdw;
    }

    public String getZsdwbm() {
        return zsdwbm;
    }

    public void setZsdwbm(String zsdwbm) {
        this.zsdwbm = zsdwbm;
    }

    public String getQhm() {
        return qhm;
    }

    public void setQhm(String qhm) {
        this.qhm = qhm;
    }

    public String getSkrqc() {
        return skrqc;
    }

    public void setSkrqc(String skrqc) {
        this.skrqc = skrqc;
    }

    public String getSkrzh() {
        return skrzh;
    }

    public void setSkrzh(String skrzh) {
        this.skrzh = skrzh;
    }

    public String getSkrkhh() {
        return skrkhh;
    }

    public void setSkrkhh(String skrkhh) {
        this.skrkhh = skrkhh;
    }

    public String getXmbm() {
        return xmbm;
    }

    public void setXmbm(String xmbm) {
        this.xmbm = xmbm;
    }

    public String getSrxmmc() {
        return srxmmc;
    }

    public void setSrxmmc(String srxmmc) {
        this.srxmmc = srxmmc;
    }

    public String getXmsl() {
        return xmsl;
    }

    public void setXmsl(String xmsl) {
        this.xmsl = xmsl;
    }

    public String getXmje() {
        return xmje;
    }

    public void setXmje(String xmje) {
        this.xmje = xmje;
    }

    public String getZfbz() {
        return zfbz;
    }

    public void setZfbz(String zfbz) {
        this.zfbz = zfbz;
    }

    public String getDwmc() {
        return dwmc;
    }

    public void setDwmc(String dwmc) {
        this.dwmc = dwmc;
    }

    public String getAmount_CN() {
        return amount_CN;
    }

    public void setAmount_CN(String amount_CN) {
        this.amount_CN = amount_CN;
    }

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getPjhm() {
        return pjhm;
    }

    public void setPjhm(String pjhm) {
        this.pjhm = pjhm;
    }

    public String getIsDelay() {
        return isDelay;
    }

    public void setIsDelay(String isDelay) {
        this.isDelay = isDelay;
    }

    public Xmxxb getXmxxb() {
        return xmxxb;
    }

    public void setXmxxb(Xmxxb xmxxb) {
        this.xmxxb = xmxxb;
    }
}
