package com.jshx.account.accountBank.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.account.accountBank.entity.AccountBank;
import com.jshx.account.accountBank.dao.AccountBankDao;

@Component("accountBankDao")
public class AccountBankDaoImpl extends BaseDaoImpl implements AccountBankDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findAccountBankByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findAccountBank(Map<String, Object> paraMap){
		return this.findListByHqlId("findAccountBankByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public AccountBank getById(String id)
	{
		return (AccountBank)this.getObjectById(AccountBank.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(AccountBank accountBank)
	{
		accountBank.setId(null);
		this.saveOrUpdateObject(accountBank);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(AccountBank accountBank)
	{
		this.saveOrUpdateObject(accountBank);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(AccountBank.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		AccountBank accountBank = (AccountBank)this.getObjectById(AccountBank.class, id);
		accountBank.setDelFlag(1);
		this.saveObject(accountBank);
	}
}
