/*     */ package cn.com.jshx.smgp.message;
/*     */ 
/*     */ import cn.com.jshx.smgp.bean.Submit;
/*     */ import cn.com.jshx.smgp.protocol.RequestId;
/*     */ import cn.com.jshx.smgp.protocol.Tlv;
/*     */ import cn.com.jshx.smgp.protocol.TlvId;
/*     */ import cn.com.jshx.smgp.protocol.TlvUtil;
/*     */ import cn.com.jshx.util.TypeConvert;
/*     */ 
/*     */ public class SubmitMessage extends Message
/*     */ {
/*     */   private Submit submit;
/*     */ 
/*     */   public SubmitMessage(byte[] buffer)
/*     */   {
/*  15 */     this.sequence_Id = TypeConvert.byte2int(buffer, 4);
/*  16 */     this.submit = new Submit();
/*  17 */     this.submit.setMsgType(buffer[8]);
/*  18 */     this.submit.setNeedReport(buffer[9]);
/*  19 */     this.submit.setPriority(buffer[10]);
/*  20 */     this.submit.setServiceID(TypeConvert.getString(buffer, 11, 0, 10));
/*  21 */     this.submit.setFeetype(TypeConvert.getString(buffer, 21, 0, 2));
/*  22 */     this.submit.setFeeCode(TypeConvert.getString(buffer, 23, 0, 6));
/*  23 */     this.submit.setFixedFee(TypeConvert.getString(buffer, 29, 0, 6));
/*  24 */     this.submit.setMsgFormat(buffer[35]);
/*  25 */     this.submit.setValidTime(TypeConvert.getString(buffer, 36, 0, 17));
/*  26 */     this.submit.setAtTime(TypeConvert.getString(buffer, 53, 0, 17));
/*  27 */     this.submit.setSrcTermid(TypeConvert.getString(buffer, 70, 0, 21));
/*  28 */     this.submit.setChargeTermid(TypeConvert.getString(buffer, 91, 0, 21));
/*  29 */     this.submit.setDestTermIDCountOnly4Server(buffer[112]);
/*     */ 
/*  31 */     int cur = 113;
/*  32 */     if (this.submit.getDestTermIDCount() == 1) {
/*  33 */       this.submit.setDestTermid(TypeConvert.getString(buffer, cur, 0, 21));
/*  34 */       cur += 21;
/*     */     } else {
/*  36 */       String[] destTermidArray = new String[this.submit.getDestTermIDCount()];
/*  37 */       for (int i = 0; i < this.submit.getDestTermIDCount(); i++) {
/*  38 */         destTermidArray[i] = TypeConvert.getString(buffer, cur, 0, 21);
/*  39 */         cur += 21;
/*     */       }
/*  41 */       this.submit.setDestTermIDArrayOnly4Server(destTermidArray);
/*     */     }
/*  43 */     this.submit.setMsgLength(buffer[cur] & 0xFF);
/*  44 */     cur++;
/*     */ 
/*  46 */     byte[] message = new byte[this.submit.getMsgLength()];
/*  47 */     System.arraycopy(buffer, cur, message, 0, message.length);
/*  48 */     this.submit.setMsgContent(message);
/*  49 */     cur += message.length;
/*  50 */     byte[] reserv = new byte[8];
/*  51 */     System.arraycopy(buffer, cur, reserv, 0, reserv.length);
/*  52 */     cur += 8;
/*     */ 
/*  54 */     if (cur < buffer.length)
/*     */     {
/*  56 */       byte[] tlv = new byte[buffer.length - cur];
/*  57 */       System.arraycopy(buffer, cur, tlv, 0, tlv.length);
/*  58 */       Tlv[] otherTlv = TlvUtil.TlvAnalysis(tlv);
/*  59 */       this.submit.setOtherTlvArray(otherTlv);
/*  60 */       for (int i = 0; i < otherTlv.length; i++)
/*  61 */         if (otherTlv[i].Tag == TlvId.LinkID)
/*  62 */           this.submit.setLinkID(otherTlv[i].Value);
/*  63 */         else if (otherTlv[i].Tag == TlvId.Mserviceid)
/*  64 */           this.submit.setProductID(otherTlv[i].Value);
/*  65 */         else if (otherTlv[i].Tag == TlvId.TP_udhi)
/*  66 */           this.submit.setTP_udhi(Integer.parseInt(otherTlv[i].Value));
/*     */     }
/*     */   }
/*     */ 
/*     */   public SubmitMessage(int msgtype, int needreport, int priority, String serviceid, String feetype, String feecode, String fixedfee, int msgformat, String validtime, String attime, String srctermid, String chargetermid, String[] desttermid, int msglength, byte[] msgcontent, byte[] reserve, Tlv[] tlvarray, int SequenceId)
/*     */   {
/*  79 */     this.sequence_Id = SequenceId;
/*  80 */     int tlvlength = 0;
/*     */ 
/*  85 */     for (int i = 0; i < tlvarray.length; i++) {
/*  86 */       tlvlength += tlvarray[i].TlvBuf.length;
/*     */     }
/*     */ 
/*  89 */     int len = 126 + 21 * desttermid.length + msgcontent.length + tlvlength;
/*  90 */     this.buf = new byte[len];
/*     */ 
/*  92 */     TypeConvert.int2byte(len, this.buf, 0);
/*  93 */     TypeConvert.int2byte(RequestId.Submit, this.buf, 4);
/*  94 */     TypeConvert.int2byte(this.sequence_Id, this.buf, 8);
/*  95 */     this.buf[12] = ((byte)msgtype);
/*  96 */     this.buf[13] = ((byte)needreport);
/*  97 */     this.buf[14] = ((byte)priority);
/*  98 */     System.arraycopy(serviceid.getBytes(), 0, this.buf, 15, serviceid.length());
/*  99 */     System.arraycopy(feetype.getBytes(), 0, this.buf, 25, feetype.length());
/* 100 */     System.arraycopy(feecode.getBytes(), 0, this.buf, 27, feecode.length());
/* 101 */     System.arraycopy(fixedfee.getBytes(), 0, this.buf, 33, fixedfee.length());
/* 102 */     this.buf[39] = ((byte)msgformat);
/* 103 */     if ((validtime != null) && (validtime.length() > 0))
/* 104 */       System.arraycopy(validtime.getBytes(), 0, this.buf, 40, 16);
/* 105 */     if ((attime != null) && (attime.length() > 0))
/* 106 */       System.arraycopy(attime.getBytes(), 0, this.buf, 57, 16);
/* 107 */     System.arraycopy(srctermid.getBytes(), 0, this.buf, 74, srctermid.length());
/* 108 */     System.arraycopy(chargetermid.getBytes(), 0, this.buf, 95, chargetermid
/* 109 */       .length());
/* 110 */     this.buf[116] = ((byte)desttermid.length);
/* 111 */     int i = 0;
/* 112 */     for (i = 0; i < desttermid.length; i++) {
/* 113 */       System.arraycopy(desttermid[i].getBytes(), 0, this.buf, 117 + i * 21, 
/* 114 */         desttermid[i].length());
/*     */     }
/* 116 */     int loc = 117 + i * 21;
/*     */ 
/* 119 */     this.buf[loc] = ((byte)msgcontent.length);
/* 120 */     System.arraycopy(msgcontent, 0, this.buf, loc + 1, msgcontent.length);
/* 121 */     loc = loc + msgcontent.length + 1;
/* 122 */     if (reserve != null)
/* 123 */       System.arraycopy(reserve, 0, this.buf, loc, reserve.length);
/* 124 */     loc += 8;
/*     */ 
/* 127 */     for (i = 0; i < tlvarray.length; i++)
/*     */     {
/* 130 */       System.arraycopy(tlvarray[i].TlvBuf, 0, this.buf, loc, 
/* 131 */         tlvarray[i].TlvBuf.length);
/* 132 */       loc += tlvarray[i].TlvBuf.length;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Submit getSubmit()
/*     */   {
/* 140 */     return this.submit;
/*     */   }
/*     */ }

/* Location:           C:\Users\Administrator\Desktop\message-1.0.1.jar
 * Qualified Name:     cn.com.jshx.smgp.message.SubmitMessage
 * JD-Core Version:    0.6.2
 */