/*     */ package cn.com.jshx.smgp.connect;
/*     */ 
/*     */ import cn.com.jshx.smgp.Exception.SubmitException;
/*     */ import cn.com.jshx.smgp.bean.Deliver;
/*     */ import cn.com.jshx.smgp.bean.LongDeliver;
/*     */ import cn.com.jshx.smgp.bean.Result;
/*     */ import cn.com.jshx.smgp.bean.Submit;
/*     */ import cn.com.jshx.smgp.bean.SubmitBatch;
/*     */ import cn.com.jshx.smgp.bean.SubmitResp;
/*     */ import cn.com.jshx.smgp.inf.ClientEventInterface;
/*     */ import cn.com.jshx.smgp.message.ActiveTestRespMessage;
/*     */ import cn.com.jshx.smgp.message.DeliverMessage;
/*     */ import cn.com.jshx.smgp.message.DeliverRespMessage;
/*     */ import cn.com.jshx.smgp.message.ExitMessage;
/*     */ import cn.com.jshx.smgp.message.LoginMessage;
/*     */ import cn.com.jshx.smgp.message.LoginRespMessage;
/*     */ import cn.com.jshx.smgp.message.Package;
/*     */ import cn.com.jshx.smgp.message.SubmitMessage;
/*     */ import cn.com.jshx.smgp.message.SubmitRespMessage;
/*     */ import cn.com.jshx.smgp.protocol.RequestId;
/*     */ import cn.com.jshx.smgp.protocol.Tlv;
/*     */ import cn.com.jshx.smgp.protocol.TlvId;
/*     */ import cn.com.jshx.util.DateUtil;
/*     */ import cn.com.jshx.util.Hex;
/*     */ import cn.com.jshx.util.TypeConvert;
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.FileWriter;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.net.Socket;
/*     */ import java.net.UnknownHostException;
/*     */ import java.security.NoSuchAlgorithmException;
/*     */ import java.text.SimpleDateFormat;
/*     */ import java.util.Calendar;
/*     */ import java.util.Date;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import java.util.Vector;
/*     */ 
/*     */ public class PConnectEvent extends Thread
/*     */ {
/*     */   private ClientEventInterface clientEventInterface;
/*  48 */   private HashMap<Integer, SubmitResp> tmpSubmitResp = new HashMap();
/*  49 */   private int submitRespTimeOut = 60000;
/*  50 */   private int CheckSubmitRespInterval = 600000;
/*  51 */   private Long LastCheckSubmitTime = Long.valueOf(0L);
/*     */   private String Host;
/*     */   private int Port;
/*     */   private Socket GwSocket;
/*     */   private DataInputStream in;
/*     */   private DataOutputStream out;
/*  64 */   private boolean HasConnect = false;
/*     */   private int LoginMode;
/*     */   private String ClientID;
/*     */   private String ClientPasswd;
/*     */   private String SPID;
/*  75 */   private int DisplayMode = 1;
/*  76 */   private int FirstLogin = 0;
/*  77 */   private int HasLogin = 0;
/*  78 */   private int Logout = 0;
/*     */   private FileWriter LogFile;
/*  88 */   private Package CurPack = new Package();
/*  89 */   private Vector<Package> undoPack = new Vector();
/*     */ 
/*  91 */   private int SequenceId = 0;
/*     */ 
/*  96 */   private HashMap<String, LongDeliver> longsmsbuffer = new HashMap();
/*  97 */   private int LongSmsOverTime = 60;
/*     */ 
/*     */   public PConnectEvent(ClientEventInterface clientEventInterface, String host, int port, int loginmode, String clientid, String clientpasswd, String spid, int displaymode)
/*     */   {
/* 102 */     this.clientEventInterface = clientEventInterface;
/* 103 */     this.Host = host;
/* 104 */     this.Port = port;
/* 105 */     this.LoginMode = loginmode;
/* 106 */     this.ClientID = clientid;
/* 107 */     this.ClientPasswd = clientpasswd;
/* 108 */     this.SPID = spid;
/* 109 */     this.DisplayMode = displaymode;
/* 110 */     this.SequenceId = GetStartSeq();
/* 111 */     this.HasConnect = Connect();
/*     */   }
/*     */ 
/*     */   public PConnectEvent(ClientEventInterface clientEventInterface, String host, int port, int loginmode, String clientid, String clientpasswd, String spid)
/*     */   {
/* 118 */     this.clientEventInterface = clientEventInterface;
/* 119 */     this.Host = host;
/* 120 */     this.Port = port;
/* 121 */     this.LoginMode = loginmode;
/* 122 */     this.ClientID = clientid;
/* 123 */     this.ClientPasswd = clientpasswd;
/* 124 */     this.SPID = spid;
/* 125 */     this.SequenceId = GetStartSeq();
/* 126 */     this.HasConnect = Connect();
/*     */   }
/*     */ 
/*     */   public void setDisplayMode(int displaymode)
/*     */   {
/* 131 */     this.DisplayMode = displaymode;
/*     */   }
/*     */ 
/*     */   public void SetLogFile(String LogFile) throws IOException {
/* 135 */     this.LogFile = new FileWriter(LogFile);
/*     */   }
/*     */ 
/*     */   private boolean Connect() {
/*     */     try {
/* 140 */       this.GwSocket = new Socket(this.Host, this.Port);
/* 141 */       this.GwSocket.setSoTimeout(60000);
/* 142 */       this.in = new DataInputStream(this.GwSocket.getInputStream());
/* 143 */       this.out = new DataOutputStream(this.GwSocket.getOutputStream());
/* 144 */       this.FirstLogin += 1;
/*     */     }
/*     */     catch (UnknownHostException e)
/*     */     {
/* 148 */       e.printStackTrace();
/*     */     }
/*     */     catch (IOException e) {
/* 151 */       if (this.FirstLogin > 0) {
/*     */         try {
/* 153 */           Thread.sleep(5000L);
/* 154 */           if (this.DisplayMode >= 2)
/* 155 */             System.out.println("Connect Fail!Reconneted");
/*     */         }
/*     */         catch (InterruptedException e1)
/*     */         {
/* 159 */           e1.printStackTrace();
/*     */         }
/* 161 */         return Connect();
/*     */       }
/* 163 */       return false;
/*     */     }
/*     */ 
/* 167 */     return true;
/*     */   }
/*     */ 
/*     */   private void ReConnect(int ms) {
/* 171 */     if (this.Logout == 0)
/*     */       try {
/* 173 */         Thread.sleep(ms);
/* 174 */         System.out.println("Try Reconnect!");
/* 175 */         Connect();
/* 176 */         System.out.println("Try Login!");
/*     */ 
/* 179 */         LoginMessage lm = new LoginMessage(this.ClientID, 
/* 180 */           this.ClientPasswd, this.LoginMode);
/* 181 */         SendBuf(lm.getBuf());
/*     */       }
/*     */       catch (InterruptedException e)
/*     */       {
/* 187 */         e.printStackTrace();
/*     */       }
/*     */       catch (IllegalArgumentException e) {
/* 190 */         e.printStackTrace();
/*     */       }
/*     */       catch (NoSuchAlgorithmException e) {
/* 193 */         e.printStackTrace();
/*     */       }
/*     */       catch (IOException e) {
/* 196 */         e.printStackTrace();
/*     */       }
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/*     */     while (true)
/*     */     {
/*     */       try {
/* 205 */         int PackLen = this.in.readInt();
/* 206 */         byte[] Message = new byte[PackLen - 4];
/*     */ 
/* 208 */         this.in.read(Message);
/*     */ 
/* 211 */         if (this.LogFile != null) {
/* 212 */           this.LogFile.write("[" + GetTime() + "]" + "Recv:" + 
/* 213 */             Hex.rhex(TypeConvert.int2byte(PackLen)) + 
/* 214 */             Hex.rhex(Message) + "\n");
/* 215 */           this.LogFile.flush();
/*     */         }
/*     */ 
/* 220 */         this.CurPack = new Package(Message);
/* 221 */         if (this.DisplayMode >= 2)
/* 222 */           DisplayPackage(PackLen, Message, 0);
/* 223 */         switch (this.CurPack.ReqestId) {
/*     */         case 4:
/* 225 */           SendBuf(new ActiveTestRespMessage().getBuf());
/*     */ 
/* 227 */           if (this.DisplayMode >= 3) {
/* 228 */             DisplayPackage(new ActiveTestRespMessage().getBuf(), 
/* 229 */               1);
/*     */           }
/* 231 */           break;
/*     */         case 3:
/* 233 */           DeliverMessage dm = new DeliverMessage(this.CurPack.Message);
/* 234 */           DeliverRespMessage drm = new DeliverRespMessage(
/* 235 */             dm.MsgID_BCD, dm.getSequence_Id(), 0);
/* 236 */           SendBuf(drm.getBuf());
/*     */ 
/* 239 */           if (this.DisplayMode >= 2) {
/* 240 */             DisplayPackage(drm.getBuf(), 1);
/*     */           }
/*     */ 
/* 244 */           if (dm.TP_udhi == 1)
/*     */           {
/* 246 */             AddLongSms(dm);
/*     */           }
/*     */           else
/*     */           {
/* 251 */             onDeliver(dm);
/*     */           }
/*     */ 
/* 254 */           break;
/*     */         case -2147483647:
/* 256 */           break;
/*     */         case -2147483646:
/* 258 */           SubmitRespMessage submitRespMessage = new SubmitRespMessage(
/* 259 */             this.CurPack.Message);
/* 260 */           onSubmitResp(submitRespMessage);
/* 261 */           break;
/*     */         case -2147483642:
/* 263 */           break;
/*     */         }
/*     */ 
/* 270 */         checkSubmitResp();
/*     */ 
/* 272 */         if ((this.CurPack.ReqestId != RequestId.Deliver) && 
/* 273 */           (this.CurPack.ReqestId != RequestId.Login_Resp) && 
/* 275 */           (this.CurPack.ReqestId != RequestId.Exit_Resp) && 
/* 276 */           (!CheckLongSmsOverTime(this.LongSmsOverTime))) continue;
/* 277 */         if ((this.CurPack.ReqestId == RequestId.Login_Resp) || 
/* 278 */           (this.CurPack.ReqestId == RequestId.Exit_Resp))
/* 279 */           this.undoPack.add(this.CurPack);
/* 280 */         synchronized (this) {
/* 281 */           notify();
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 289 */         if ((this.DisplayMode >= 1) && (this.Logout == 0))
/* 290 */           System.out.println("Lost Connect,ReConnect");
/*     */       }
/* 292 */       if (this.Logout == 0)
/* 293 */         ReConnect(1000);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setLSmsOverTime(int second)
/*     */   {
/* 302 */     this.LongSmsOverTime = second;
/*     */   }
/*     */ 
/*     */   private void AddLongSms(DeliverMessage dm)
/*     */   {
/* 307 */     if (this.longsmsbuffer.get(dm.SrcTermID) != null) {
/* 308 */       int curstat = ((LongDeliver)this.longsmsbuffer.get(dm.SrcTermID)).AddDeliver(dm);
/*     */ 
/* 313 */       if (curstat == 0)
/* 314 */         return;
/* 315 */       if (curstat == 1)
/*     */       {
/* 322 */         onDeliver(((LongDeliver)this.longsmsbuffer.get(dm.SrcTermID))
/* 323 */           .MergeDeliver());
/* 324 */         this.longsmsbuffer.remove(dm.SrcTermID);
/* 325 */       } else if (curstat == -1) {
/* 326 */         DeliverMessage[] tmpdeliver = ((LongDeliver)this.longsmsbuffer.get(
/* 327 */           dm.SrcTermID)).popDeliver();
/* 328 */         for (int i = 0; i < tmpdeliver.length; i++) {
/* 329 */           onDeliver(tmpdeliver[i]);
/*     */         }
/*     */ 
/* 332 */         this.longsmsbuffer.put(dm.SrcTermID, new LongDeliver(dm));
/*     */       }
/*     */     } else {
/* 335 */       this.longsmsbuffer.put(dm.SrcTermID, new LongDeliver(dm));
/*     */     }
/*     */   }
/*     */ 
/*     */   private boolean CheckLongSmsOverTime(int second)
/*     */   {
/* 354 */     Iterator spit = this.longsmsbuffer.keySet().iterator();
/*     */ 
/* 356 */     while (spit.hasNext())
/*     */     {
/* 358 */       String key = "";
/*     */       DeliverMessage[] tmpDeliverMsg;
/* 359 */       if ((tmpDeliverMsg = ((LongDeliver)this.longsmsbuffer.get(
/* 360 */         key = (String)spit.next())).CheckIfOverTime(second)) != null) {
/* 361 */         for (int i = 0; i < tmpDeliverMsg.length; i++)
/*     */         {
/* 363 */           onDeliver(tmpDeliverMsg[i]);
/*     */         }
/*     */ 
/* 366 */         this.longsmsbuffer.remove(key);
/* 367 */         return true;
/*     */       }
/*     */     }
/*     */ 
/* 371 */     return false;
/*     */   }
/*     */ 
/*     */   public synchronized void LogOut() {
/* 375 */     ExitMessage em = new ExitMessage();
/* 376 */     this.Logout = 1;
/*     */     try {
/* 378 */       SendBuf(em.getBuf());
/*     */ 
/* 380 */       long sendTime = getTimeStamp().longValue();
/* 381 */       Package tmppack = new Package();
/* 382 */       while ((getTimeStamp().longValue() - sendTime < 60000L) && 
/* 383 */         ((tmppack = checkPackage(0, RequestId.Exit_Resp)) != null)) {
/*     */         try {
/* 385 */           synchronized (this) {
/* 386 */             wait(60000L);
/*     */           }
/*     */         }
/*     */         catch (RuntimeException e)
/*     */         {
/* 391 */           e.printStackTrace();
/*     */         }
/*     */         catch (InterruptedException e) {
/* 394 */           e.printStackTrace();
/*     */         }
/*     */       }
/*     */ 
/* 398 */       this.GwSocket.close();
/* 399 */       if (this.LogFile != null) {
/* 400 */         this.LogFile.close();
/*     */       }
/* 402 */       stop();
/*     */     }
/*     */     catch (IOException e) {
/* 405 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   private synchronized void onDeliver(DeliverMessage deliverMessage)
/*     */   {
/* 411 */     Deliver dm = new Deliver(deliverMessage);
/* 412 */     this.clientEventInterface.onDeliver(dm);
/*     */   }
/*     */ 
/*     */   private synchronized void onSubmitResp(SubmitRespMessage submitRespMessage) {
/* 416 */     int seq = submitRespMessage.getSequence_Id();
/* 417 */     SubmitResp submitResp = (SubmitResp)this.tmpSubmitResp.get(Integer.valueOf(seq));
/* 418 */     if (submitResp != null)
/* 419 */       this.tmpSubmitResp.remove(Integer.valueOf(seq));
/*     */     else {
/* 421 */       submitResp = new SubmitResp();
/*     */     }
/* 423 */     submitResp.setMsgID(submitRespMessage.getMsgID());
/* 424 */     submitResp.setResultCode(submitRespMessage.getStatus());
/* 425 */     submitResp.setSequenceID(submitRespMessage.getSequence_Id());
/*     */ 
/* 427 */     this.clientEventInterface.OnSubmitResp(submitResp);
/*     */   }
/*     */ 
/*     */   public synchronized Result Login()
/*     */   {
/* 432 */     Result result = new Result();
/*     */     try {
/* 434 */       LoginMessage lm = new LoginMessage(this.ClientID, 
/* 435 */         this.ClientPasswd, this.LoginMode);
/* 436 */       SendBuf(lm.getBuf());
/*     */ 
/* 439 */       while ((this.CurPack == null) || 
/* 440 */         (this.CurPack.ReqestId != RequestId.Login_Resp)) {
/*     */         try {
/* 442 */           synchronized (this) {
/* 443 */             wait();
/*     */           }
/*     */         }
/*     */         catch (RuntimeException e)
/*     */         {
/* 448 */           e.printStackTrace();
/*     */         }
/*     */       }
/*     */ 
/* 452 */       LoginRespMessage lrm = new LoginRespMessage(this.CurPack.Message);
/* 453 */       result.ErrorCode = lrm.getStatus();
/* 454 */       result.ErrorDescription = 
/* 455 */         ("SerVersion:" + lrm.getServerVersion() + 
/* 455 */         " ShareKey:" + Hex.rhex(lrm.getAuthenticatorServer()));
/*     */ 
/* 457 */       if (lrm.getStatus() == 0)
/* 458 */         this.HasLogin = 1;
/*     */     }
/*     */     catch (IllegalArgumentException e)
/*     */     {
/* 462 */       e.printStackTrace();
/*     */     }
/*     */     catch (NoSuchAlgorithmException e) {
/* 465 */       e.printStackTrace();
/*     */     }
/*     */     catch (IOException e) {
/* 468 */       e.printStackTrace();
/*     */     }
/*     */     catch (InterruptedException e) {
/* 471 */       e.printStackTrace();
/*     */     }
/* 473 */     return result;
/*     */   }
/*     */ 
/*     */   public synchronized Integer[] SendLong(Submit submit)
/*     */     throws SubmitException
/*     */   {
/* 479 */     Vector splitContent = SplitContent(submit.getMsgContent());
/* 480 */     Integer[] result = new Integer[splitContent.size()];
/*     */ 
/* 482 */     for (int i = 0; i < splitContent.size(); i++) {
/* 483 */       Submit tmpSubmit = submit;
/* 484 */       tmpSubmit.setMsgContent(addContentHeader((byte[])splitContent.get(i), 
/* 485 */         splitContent.size(), i + 1));
/*     */ 
/* 488 */       tmpSubmit.setTP_udhi(1);
/* 489 */       tmpSubmit.AddTlv(TlvId.PkNumber, String.valueOf(i + 1));
/* 490 */       tmpSubmit
/* 491 */         .AddTlv(TlvId.PkTotal, String.valueOf(splitContent.size()));
/* 492 */       result[i] = Integer.valueOf(Send(tmpSubmit));
/*     */     }
/*     */ 
/* 496 */     return result;
/*     */   }
/*     */ 
/*     */   private static byte[] addFlashSmsHeader(byte[] content)
/*     */   {
/* 501 */     byte[] newcontent = new byte[content.length + 2];
/* 502 */     newcontent[0] = 0;
/* 503 */     newcontent[1] = 1;
/* 504 */     System.arraycopy(content, 0, newcontent, 2, content.length);
/* 505 */     return newcontent;
/*     */   }
/*     */ 
/*     */   private static byte[] addContentHeader(byte[] content, int total, int num)
/*     */   {
/* 510 */     byte[] newcontent = new byte[content.length + 6];
/* 511 */     newcontent[0] = 5;
/* 512 */     newcontent[1] = 0;
/* 513 */     newcontent[2] = 3;
/* 514 */     newcontent[4] = ((byte)total);
/* 515 */     newcontent[5] = ((byte)num);
/* 516 */     System.arraycopy(content, 0, newcontent, 6, content.length);
/*     */ 
/* 518 */     return newcontent;
/*     */   }
/*     */ 
/*     */   private static Vector<byte[]> SplitContent(byte[] content) {
/* 522 */     ByteArrayInputStream buf = new ByteArrayInputStream(content);
/* 523 */     Vector tmpv = new Vector();
/*     */ 
/* 525 */     int msgCount = content.length / 134 + 1;
/* 526 */     int LeftLen = content.length;
/* 527 */     for (int i = 0; i < msgCount; i++) {
/* 528 */       byte[] tmp = new byte[''];
/* 529 */       if (LeftLen < 134)
/* 530 */         tmp = new byte[LeftLen];
/*     */       try {
/* 532 */         buf.read(tmp);
/* 533 */         tmpv.add(tmp);
/*     */       }
/*     */       catch (IOException e) {
/* 536 */         e.printStackTrace();
/*     */       }
/* 538 */       LeftLen -= tmp.length;
/*     */     }
/* 540 */     return tmpv;
/*     */   }
/*     */ 
/*     */   public synchronized int Send(Submit submit) throws SubmitException
/*     */   {
/* 545 */     if (submit.getMsgContent().length > 200)
/*     */     {
/* 547 */       throw new SubmitException(new Result(4, "Message too Long"));
/*     */     }
/*     */ 
/* 550 */     Vector tlv = new Vector();
/* 551 */     if ((this.SPID != null) && (!this.SPID.equals(""))) {
/* 552 */       tlv.add(new Tlv(TlvId.MsgSrc, this.SPID));
/*     */     }
/* 554 */     if ((submit.getProductID() != null) && (!submit.getProductID().equals(""))) {
/* 555 */       tlv.add(new Tlv(TlvId.Mserviceid, submit.getProductID()));
/*     */     }
/*     */ 
/* 558 */     if ((submit.getLinkID() != null) && (!submit.getLinkID().equals(""))) {
/* 559 */       tlv.add(new Tlv(TlvId.LinkID, submit.getLinkID()));
/*     */     }
/*     */ 
/* 562 */     if (submit.getOtherTlvArray() != null) {
/* 563 */       for (int i = 0; i < submit.getOtherTlvArray().length; i++) {
/* 564 */         tlv.add(submit.getOtherTlvArray()[i]);
/*     */       }
/*     */     }
/* 567 */     Tlv[] tlvarray = new Tlv[tlv.size()];
/*     */ 
/* 569 */     for (int i = 0; i < tlv.size(); i++)
/*     */     {
/* 571 */       tlvarray[i] = ((Tlv)tlv.get(i));
/*     */     }
/*     */ 
/* 574 */     String[] desttermidarray = new String[1];
/* 575 */     desttermidarray[0] = submit.getDestTermid();
/* 576 */     if (this.SequenceId++ == 8388607) {
/* 577 */       this.SequenceId = 0;
/*     */     }
/*     */ 
/* 580 */     int tmpseq = this.SequenceId;
/* 581 */     SubmitMessage sm = new SubmitMessage(submit.getMsgType(), submit
/* 582 */       .getNeedReport(), submit.getPriority(), submit.getServiceID(), 
/* 583 */       submit.getFeetype(), submit.getFeeCode(), submit.getFixedFee(), 
/* 584 */       submit.getMsgFormat(), submit.getValidTime(), submit
/* 585 */       .getAtTime(), submit.getSrcTermid(), submit
/* 586 */       .getChargeTermid(), desttermidarray, submit
/* 587 */       .getMsgLength(), submit.getMsgContent(), submit
/* 588 */       .getReserve(), tlvarray, tmpseq);
/*     */     try
/*     */     {
/* 591 */       SendBuf(sm.getBuf());
/*     */ 
/* 593 */       if (this.DisplayMode >= 2) {
/* 594 */         DisplayPackage(sm.getBuf(), 1);
/*     */       }
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 599 */       throw new SubmitException(new Result(-1, "Socket Error!"));
/*     */     }
/*     */ 
/* 603 */     this.tmpSubmitResp.put(Integer.valueOf(tmpseq), new SubmitResp(submit));
/*     */ 
/* 605 */     return tmpseq;
/*     */   }
/*     */ 
/*     */   private static Long getTimeStamp()
/*     */   {
/* 610 */     return Long.valueOf(new Date().getTime());
/*     */   }
/*     */ 
/*     */   public synchronized Result SendBatch(SubmitBatch submit)
/*     */   {
/* 615 */     Vector tlv = new Vector();
/* 616 */     if ((this.SPID != null) && (!this.SPID.equals(""))) {
/* 617 */       tlv.add(new Tlv(TlvId.MsgSrc, this.SPID));
/*     */     }
/* 619 */     if ((submit.getProductID() != null) && (!submit.getProductID().equals(""))) {
/* 620 */       tlv.add(new Tlv(TlvId.Mserviceid, submit.getProductID()));
/*     */     }
/*     */ 
/* 623 */     if ((submit.getLinkID() != null) && (!submit.getLinkID().equals(""))) {
/* 624 */       tlv.add(new Tlv(TlvId.LinkID, submit.getLinkID()));
/*     */     }
/*     */ 
/* 627 */     if (submit.getOtherTlvArray() != null) {
/* 628 */       for (int i = 0; i < submit.getOtherTlvArray().length; i++) {
/* 629 */         tlv.add(submit.getOtherTlvArray()[i]);
/*     */       }
/*     */     }
/* 632 */     Tlv[] tlvarray = new Tlv[tlv.size()];
/*     */ 
/* 634 */     for (int i = 0; i < tlv.size(); i++)
/*     */     {
/* 636 */       tlvarray[i] = ((Tlv)tlv.get(i));
/*     */     }
/*     */ 
/* 641 */     if (this.SequenceId++ == 8388607) {
/* 642 */       this.SequenceId = 0;
/*     */     }
/* 644 */     SubmitMessage sm = new SubmitMessage(submit.getMsgType(), submit
/* 645 */       .getNeedReport(), submit.getPriority(), submit.getServiceID(), 
/* 646 */       submit.getFeetype(), submit.getFeeCode(), submit.getFixedFee(), 
/* 647 */       submit.getMsgFormat(), submit.getValidTime(), submit
/* 648 */       .getAtTime(), submit.getSrcTermid(), submit
/* 649 */       .getChargeTermid(), submit.getDestTermid(), submit
/* 650 */       .getMsgLength(), submit.getMsgContent(), submit
/* 651 */       .getReserve(), tlvarray, this.SequenceId);
/*     */     try
/*     */     {
/* 654 */       SendBuf(sm.getBuf());
/*     */ 
/* 656 */       if (this.DisplayMode >= 2) {
/* 657 */         DisplayPackage(sm.getBuf(), 1);
/*     */       }
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 662 */       return new Result(-1, "Socket Error!");
/*     */     }
/*     */ 
/* 666 */     while ((this.CurPack == null) || 
/* 667 */       (this.CurPack.ReqestId != RequestId.Submit_Resp)) {
/*     */       try {
/* 669 */         synchronized (this) {
/* 670 */           wait();
/*     */         }
/*     */       }
/*     */       catch (RuntimeException e)
/*     */       {
/* 675 */         e.printStackTrace();
/*     */       }
/*     */       catch (InterruptedException e) {
/* 678 */         e.printStackTrace();
/*     */       }
/*     */     }
/*     */ 
/* 682 */     Result result = new Result();
/* 683 */     SubmitRespMessage srm = new SubmitRespMessage(this.CurPack.Message);
/*     */ 
/* 687 */     return new Result(srm.getStatus(), srm.getMsgID());
/*     */   }
/*     */ 
/*     */   private void DisplayPackage(int len, byte[] message, int sendOrReceive)
/*     */   {
/* 693 */     if (sendOrReceive == 0)
/* 694 */       System.out.println("-------------Receive Package-------------");
/*     */     else {
/* 696 */       System.out.println("--------------Send  Package--------------");
/*     */     }
/* 698 */     System.out.println("Length:" + len);
/* 699 */     System.out.println("Pack:" + Hex.rhex(message));
/*     */   }
/*     */ 
/*     */   private void DisplayPackage(byte[] message, int sendOrReceive) {
/* 703 */     int len = TypeConvert.byte2int(message, 0);
/* 704 */     byte[] messagetmp = new byte[message.length - 4];
/*     */ 
/* 706 */     System.arraycopy(message, 4, messagetmp, 0, messagetmp.length);
/*     */ 
/* 709 */     DisplayPackage(len, messagetmp, sendOrReceive);
/*     */   }
/*     */ 
/*     */   private synchronized void SendBuf(byte[] buf) throws IOException {
/* 713 */     this.out.write(buf);
/* 714 */     if (this.LogFile != null) {
/* 715 */       this.LogFile.write("[" + GetTime() + "]" + "Send:" + Hex.rhex(buf) + 
/* 716 */         "\n");
/* 717 */       this.LogFile.flush();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void checkSubmitResp() {
/* 722 */     if (DateUtil.getTimeStampL().longValue() - this.LastCheckSubmitTime.longValue() < this.CheckSubmitRespInterval)
/* 723 */       return;
/* 724 */     this.LastCheckSubmitTime = DateUtil.getTimeStampL();
/* 725 */     Iterator iteratorSubmitResp = this.tmpSubmitResp.keySet().iterator();
/* 726 */     while (iteratorSubmitResp.hasNext()) {
/* 727 */       int key = ((Integer)iteratorSubmitResp.next()).intValue();
/* 728 */       SubmitResp submitResp = (SubmitResp)this.tmpSubmitResp.get(Integer.valueOf(key));
/*     */ 
/* 730 */       if (DateUtil.getTimeStampL().longValue() - submitResp.getSendTime() > this.submitRespTimeOut) {
/* 731 */         this.tmpSubmitResp.remove(Integer.valueOf(key));
/* 732 */         System.out.println("SubmitResp��ʱ");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private Package checkPackage(int seq, int reqid)
/*     */   {
/* 740 */     for (int i = 0; i < this.undoPack.size(); i++) {
/* 741 */       Package pk = (Package)this.undoPack.get(i);
/*     */ 
/* 743 */       if ((pk.SequenceId == seq) && (pk.ReqestId == reqid)) {
/* 744 */         this.undoPack.remove(i);
/* 745 */         return pk;
/*     */       }
/* 747 */       if (new Date().getTime() - pk.timestamp > 60000L)
/*     */       {
/* 749 */         this.undoPack.remove(i);
/*     */       }
/*     */     }
/*     */ 
/* 753 */     return null;
/*     */   }
/*     */ 
/*     */   private static String GetTime() {
/* 757 */     String TimeStamp = "";
/* 758 */     Calendar now = Calendar.getInstance();
/*     */ 
/* 760 */     SimpleDateFormat bartDateFormat = new SimpleDateFormat(
/* 761 */       "yyyy-MM-dd HH:mm:ss");
/* 762 */     return bartDateFormat.format(now.getTime());
/*     */   }
/*     */ 
/*     */   private static int GetStartSeq()
/*     */   {
/* 774 */     SimpleDateFormat bartDateFormat = new SimpleDateFormat("HHmmss");
/* 775 */     Calendar now = Calendar.getInstance();
/*     */ 
/* 777 */     return Integer.parseInt(bartDateFormat.format(now.getTime()));
/*     */   }
/*     */ }

/* Location:           C:\Users\Administrator\Desktop\message-1.0.1.jar
 * Qualified Name:     cn.com.jshx.smgp.connect.PConnectEvent
 * JD-Core Version:    0.6.2
 */