/*    */ package cn.com.jshx.smgp.bean;
/*    */ 
/*    */ import cn.com.jshx.smgp.message.DeliverMessage;
/*    */ 
/*    */ public class LongDeliver
/*    */ {
/*    */   private DeliverMessage[] GDeliver;
/*    */   private long lastactivetime;
/*  8 */   private int Total = 0;
/*  9 */   private int Count = 0;
/* 10 */   private int TotalMsgLengh = 0;
/*    */ 
/*    */   public LongDeliver(DeliverMessage delivermsg) {
/* 13 */     this.lastactivetime = System.currentTimeMillis();
/* 14 */     byte[] tmp = new byte[6];
/* 15 */     System.arraycopy(delivermsg.MsgContent, 0, tmp, 0, 6);
/*    */ 
/* 17 */     this.Total = delivermsg.MsgContent[4];
/*    */ 
/* 19 */     this.GDeliver = new DeliverMessage[this.Total];
/* 20 */     int curnum = delivermsg.MsgContent[5];
/* 21 */     if (curnum <= this.Total) {
/* 22 */       this.GDeliver[(curnum - 1)] = delivermsg;
/* 23 */       this.TotalMsgLengh = (delivermsg.MsgContent.length - 6);
/*    */     }
/* 25 */     this.Count = 1;
/*    */   }
/*    */ 
/*    */   public int AddDeliver(DeliverMessage delivermsg)
/*    */   {
/* 34 */     this.lastactivetime = System.currentTimeMillis();
/* 35 */     if ((delivermsg.MsgContent[4] != this.Total) || 
/* 36 */       (this.GDeliver[(delivermsg.MsgContent[5] - 1)] != null))
/*    */     {
/* 38 */       return -1;
/*    */     }
/* 40 */     this.GDeliver[(delivermsg.MsgContent[5] - 1)] = delivermsg;
/* 41 */     this.TotalMsgLengh = 
/* 42 */       (this.TotalMsgLengh + 
/* 42 */       delivermsg.MsgContent.length - 6);
/* 43 */     this.Count += 1;
/*    */ 
/* 45 */     if (this.Count == this.Total) {
/* 46 */       return 1;
/*    */     }
/* 48 */     return 0;
/*    */   }
/*    */ 
/*    */   public DeliverMessage MergeDeliver()
/*    */   {
/* 54 */     byte[] mergeMsgContent = new byte[this.TotalMsgLengh];
/*    */ 
/* 56 */     int nav = 0;
/* 57 */     for (int i = 0; i < this.Total; i++) {
/* 58 */       System.arraycopy(this.GDeliver[i].MsgContent, 6, mergeMsgContent, 
/* 59 */         nav, this.GDeliver[i].MsgContent.length - 6);
/* 60 */       nav = nav + this.GDeliver[i].MsgContent.length - 6;
/*    */     }
/* 62 */     this.GDeliver[0].MsgContent = mergeMsgContent;
/* 63 */     this.GDeliver[0].MsgLength = this.GDeliver[0].MsgContent.length;
/* 64 */     return this.GDeliver[0];
/*    */   }
/*    */ 
/*    */   private static byte[] changeLongHeader(byte[] header) {
/* 68 */     return ("(" + header[5] + "/" + header[4] + ")").getBytes();
/*    */   }
/*    */ 
/*    */   private static byte[] mergeByte(byte[] newhead, byte[] srcmsg) {
/* 72 */     byte[] tmpbyte = new byte[newhead.length + srcmsg.length];
/* 73 */     System.arraycopy(newhead, 0, tmpbyte, 0, newhead.length);
/* 74 */     System.arraycopy(srcmsg, 6, tmpbyte, newhead.length, srcmsg.length - 6);
/* 75 */     return tmpbyte;
/*    */   }
/*    */ 
/*    */   public DeliverMessage[] popDeliver() {
/* 79 */     DeliverMessage[] returnDeliver = new DeliverMessage[this.Count];
/* 80 */     int j = 0;
/* 81 */     for (int i = 0; i < this.Total; i++) {
/* 82 */       if (this.GDeliver[i] != null) {
/* 83 */         returnDeliver[j] = this.GDeliver[i];
/* 84 */         returnDeliver[j].MsgContent = mergeByte(
/* 85 */           changeLongHeader(returnDeliver[j].MsgContent), 
/* 86 */           returnDeliver[j].MsgContent);
/* 87 */         returnDeliver[j].MsgLength = returnDeliver[j].MsgContent.length;
/* 88 */         j++;
/*    */       }
/*    */     }
/* 91 */     return returnDeliver;
/*    */   }
/*    */ 
/*    */   public DeliverMessage[] CheckIfOverTime(int second)
/*    */   {
/* 96 */     if (System.currentTimeMillis() - this.lastactivetime > second * 1000) {
/* 97 */       return popDeliver();
/*    */     }
/* 99 */     return null;
/*    */   }
/*    */ }

/* Location:           C:\Users\Administrator\Desktop\message-1.0.1.jar
 * Qualified Name:     cn.com.jshx.smgp.bean.LongDeliver
 * JD-Core Version:    0.6.2
 */