/*     */ package cn.com.jshx.sender;
/*     */ 
/*     */ import cn.com.jshx.sender.interfaces.Sender;
/*     */ import cn.com.jshx.smgp.Client;
/*     */ import cn.com.jshx.smgp.bean.Result;
/*     */ import cn.com.jshx.smgp.bean.Submit;
/*     */ import cn.com.jshx.util.Config;
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import java.util.Map;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ 
/*     */ public class SMGPSender
/*     */   implements Sender
/*     */ {
/*  19 */   private static final Log logger = LogFactory.getLog(SMGPSender.class);
/*  20 */   private static Client client = null;
/*     */ 
/*  22 */   private static final String SMGW_IP = Config.getProperty("smgp_ip");
/*  23 */   private static final int SMGW_PORT = Integer.parseInt(Config.getProperty("smgp_port"));
/*  24 */   private static final String SMGW_ACCOUNT = Config.getProperty("smgp_account");
/*  25 */   private static final String SMGW_PASSWD = Config.getProperty("smgp_passwd");
/*  26 */   private static final String SMGW_SPID = Config.getProperty("smgp_spid");
/*  27 */   private static final String SMGW_SPNUM = Config.getProperty("smgp_spnum");
/*     */ 
/*     */   static
/*     */   {
/*  31 */     client = new Client(SMGW_IP, SMGW_PORT, 2, SMGW_ACCOUNT, SMGW_PASSWD, SMGW_SPID, 2);
/*  32 */     client.Login();
/*     */   }
/*     */ 
/*     */   public int send(String mobile, String content)
/*     */   {
/*  37 */     Submit submit = new Submit();
/*  38 */     submit.setSrcTermid(SMGW_SPNUM);
/*  39 */     submit.setDestTermid(mobile);
/*     */     try
/*     */     {
/*  43 */       submit.setMsgContent(content.getBytes("gb2312"));
/*     */     }
/*     */     catch (UnsupportedEncodingException e)
/*     */     {
/*  47 */       logger.error("Send short message encoding format error.");
/*  48 */       e.printStackTrace();
/*     */     }
/*  50 */     submit.setMsgFormat(15);
/*  51 */     submit.setProductID("112000000000000001032");
/*  52 */     submit.setServiceID("106592052");
/*  53 */     submit.setChargeTermid("00000000000000000000");
/*     */ 
/*  56 */     if (submit.getMsgContent().length < 200)
/*     */     {
/*  59 */       Result result = client.Send(submit);
/*     */ 
/*  61 */       if (result == null)
/*     */       {
/*  63 */         logger.error("message send failed,result is null. phone:" + mobile);
/*  64 */         return 16777215;
/*     */       }
/*     */ 
/*  67 */       if (result.ErrorCode != 0)
/*     */       {
/*  69 */         logger.error("message send failed,phone:" + mobile);
/*  70 */         logger.error("description:" + result.ErrorDescription + ",ErrorCode:" + result.ErrorCode);
/*  71 */         return 16777215;
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/*  76 */       Result[] result = client.SendLong(submit);
/*     */ 
/*  78 */       if (result == null)
/*     */       {
/*  80 */         logger.error("message send failed,result is null. phone:" + mobile);
/*  81 */         return 16777215;
/*     */       }
/*     */ 
/*  84 */       for (int i = 0; i < result.length; i++)
/*     */       {
/*  86 */         if (result[i].ErrorCode != 0)
/*     */         {
/*  88 */           logger.error("message send failed,phone:" + mobile);
/*  89 */           logger.error("description:" + result[i].ErrorDescription + ",ErrorCode" + result[i].ErrorCode);
/*  90 */           return 16777215;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*  95 */     return 0;
/*     */   }
/*     */ 
/*     */   public int send(Map<String, String> map, String mobile, String content)
/*     */   {
/* 101 */     return 0;
/*     */   }
/*     */ }

/* Location:           C:\Users\Administrator\Desktop\message-1.0.1.jar
 * Qualified Name:     cn.com.jshx.sender.SMGPSender
 * JD-Core Version:    0.6.2
 */