package com.jshx.sensitive;

import com.jshx.core.exception.BasalException;
import com.jshx.core.security.XSSSecurityCon;
import com.jshx.core.utils.Constants;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Enumeration;
import java.util.Map;

/**
 * Created by chenjian on 16/3/8.
 */
public class SensitiveInterceptor extends AbstractInterceptor {

    private static final Logger logger = LoggerFactory.getLogger(SensitiveInterceptor.class);

    @Override
    public String intercept(ActionInvocation actionInvocation) throws Exception {

        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        String requestUri = request.getRequestURI();
        Map<String, String> urlMap = Constants.CODE_MAP.get(SensitiveWordUtil.SENSITIVE_FILTER_URL_CODE);
        if(urlMap.containsValue(requestUri)){
            Enumeration<String> params = request.getParameterNames();
            while(params.hasMoreElements()){
                String param = params.nextElement();
                String[] values = request.getParameterValues(param);
                for(String value: values){
                    if(SensitiveWordUtil.isContaintSensitiveWord(value, 1)){
                        logger.warn(value + "含有敏感词");
                        Throwable t = new Throwable(request.getRequestURI()+" - "+request.getQueryString());
                        BasalException e = new BasalException(2, "请求中包含敏感词", t);
                        request.getSession().setAttribute("exceptionObject", e);
                        response.setStatus(403);;
                        request.getRequestDispatcher(XSSSecurityCon.FILTER_ERROR_PAGE).forward(request, response);
                        return "sensitive";
                    }
                }
            }
        }

        return actionInvocation.invoke();
    }
}
