package com.jshx.log.listener;

import javax.annotation.PostConstruct;

import org.hibernate.SessionFactory;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.internal.SessionFactoryImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.Map;

public class HibernateEventWiring {

	private SessionFactory sessionFactory;

	private Map<String, Object> listeners;

	@PostConstruct
    public void registerListeners() {
		EventListenerRegistry registry = ((SessionFactoryImpl) sessionFactory).getServiceRegistry().getService(
		        EventListenerRegistry.class);
		Assert.notNull(sessionFactory);
		for (String key : listeners.keySet()) {
			EventType eventType = EventType.resolveEventTypeByName(key);
			try{
				registry.getEventListenerGroup(eventType).appendListener(listeners.get(key));
			}catch(Exception e){

			}
		}
	}

	public void setSessionFactory(SessionFactory sessionFactory) {
		this.sessionFactory = sessionFactory;
	}

	public void setListeners(Map<String, Object> listeners) {
		this.listeners = listeners;
	}
}
