package com.jshx.activiti.web;

import com.jshx.core.base.action.BaseAction;
import net.sf.json.JSONArray;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * Created by ian on 2016/8/16.
 */
public class ModlerAction extends BaseAction {

    @Autowired
    protected RepositoryService repositoryService;

    private static final Logger modlerLogger = LoggerFactory.getLogger(ModlerAction.class);

    public void getModles(){
        try {
            List<Model> modelList = repositoryService.createModelQuery().orderByCreateTime().desc().list();
            String json = JSONArray.fromObject(modelList).toString();

            getResponse().setContentType("application/json;charset=UTF-8");
            getResponse().setCharacterEncoding(ENCODING);
            getResponse().setHeader("Charset", ENCODING);
            getResponse().setHeader("Cache-Control", "no-cache");
            getResponse().getWriter().println(json);
        }catch(Exception e){
            modlerLogger.error("获取模型出错", e);
        }
    }
}
