package com.jshx.activiti.service.impl;

import com.jshx.activiti.entity.ActivitiMessage;
import com.jshx.activiti.service.ActivitiMessageService;
import com.jshx.activiti.service.ActivitiService;
import com.jshx.activiti.service.ActivitiSmsService;
import com.jshx.core.exception.BasalException;
import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.service.UserService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by chenjian on 16/7/1.
 */
@Service("activitiSmsService")
public class ActivitiSmsServiceImpl implements ActivitiSmsService {

    @Autowired
    private ActivitiService activitiService;

    @Autowired
    private UserService userService;

    @Autowired
    private RuntimeService runtimeService;

    @Autowired
    private ActivitiMessageService activitiMessageService;

    @Autowired
    private TaskService taskService;

    @Override
    public void sendNewTaskNotification(DelegateTask delegateTask) throws BasalException {
        User user = activitiService.getCreator(delegateTask.getProcessInstanceId());
        String sender = user.getDisplayName();

        List<String> receiverList = new ArrayList<>();
        String asignee = delegateTask.getAssignee();
        if(StringUtils.isNotEmpty(asignee)){
            user = userService.findUserByLoginId(asignee);
            if(StringUtils.isNotEmpty(user.getMobile())){
                receiverList.add(user.getMobile());
            }
        }

        List<User> candidateUsers = activitiService.getCandidate(delegateTask);
        candidateUsers.forEach(candidate -> {
            if(StringUtils.isNotEmpty(candidate.getMobile()))
                receiverList.add(candidate.getMobile());
        });

        String taskName = delegateTask.getName();
        ExecutionEntity pi = (ExecutionEntity)runtimeService.createProcessInstanceQuery().processInstanceId(delegateTask.getProcessInstanceId()).singleResult();
        String processName = pi.getProcessDefinition().getName();
        String content = MessageFormat.format(NEW_TASK_CONTENT, sender, processName, taskName);
        saveMessages(receiverList, content);
    }

    @Override
    public void sendNotification(String processInstanceId, String taskId, String buzzId) throws BasalException {
        User user = activitiService.getCreator(processInstanceId);
        String sender = user.getDisplayName();

        List<String> receiverList = new ArrayList<>();
        user = activitiService.getAssignee(taskId);
        if(user!=null && StringUtils.isNotBlank(user.getMobile())){
            receiverList.add(user.getMobile());
        }

        List<User> candidateUsers = activitiService.getCandidate(taskId);
        candidateUsers.forEach(candidate -> {
            if(StringUtils.isNotBlank(candidate.getMobile()))
                receiverList.add(candidate.getMobile());
        });
        Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
        String taskName = task.getName();
        ExecutionEntity pi = (ExecutionEntity)runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        String processName = pi.getProcessDefinition().getName();
        String content = MessageFormat.format(NEW_TASK_CONTENT, sender, processName, taskName);
        saveMessages(receiverList, content);
    }

    private void saveMessages(List<String> receiverList, String content){
        List<ActivitiMessage> messageList = new ArrayList<>();
        for(String receiver: receiverList){
            ActivitiMessage message = new ActivitiMessage();
            message.setReceiver(receiver);
            message.setContent(content);
            message.setStatus(0);
            message.setType(1);
            messageList.add(message);
        }
        activitiMessageService.saveMessages(messageList);
    }
}
