package com.jshx.activiti.service.impl;

import com.jshx.activiti.service.ActivitiMailService;
import com.jshx.activiti.service.ActivitiService;
import com.jshx.core.exception.BasalException;
import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.service.UserService;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.cfg.MailServerInfo;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.naming.NamingException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;

/**
 * 发送邮件服务
 *
 * Created by chenjian on 16/7/1.
 */
@Service("activitiMailService")
public class ActivitiMailServiceImpl implements ActivitiMailService {

    @Autowired
    private ActivitiService activitiService;

    @Autowired
    private UserService userService;

    @Autowired
    private RuntimeService runtimeService;

    @Autowired
    private TaskService taskService;
    
    @Autowired
    private ProcessEngineConfiguration processEngineConfiguration;

    @Override
    public void sendNewTaskNotification(DelegateTask delegateTask) throws BasalException {
        User user = activitiService.getCreator(delegateTask.getProcessInstanceId());
        if(user==null || StringUtils.isEmpty(user.getEmail()))
            throw new BasalException(BasalException.ERROR, "未能找到流程启动者邮箱");
        String from = user.getEmail();
        String sender = user.getDisplayName();

        StringBuilder sb = new StringBuilder();
        String asignee = delegateTask.getAssignee();
        if(StringUtils.isNoneEmpty(asignee)){
            user = userService.findUserByLoginId(asignee);
            if(StringUtils.isNotEmpty(user.getEmail())){
                sb.append(user.getEmail()).append(",");
            }
        }

        List<User> candidateUsers = activitiService.getCandidate(delegateTask);
        candidateUsers.forEach(candidate -> {
            if(StringUtils.isNotEmpty(candidate.getEmail()))
                sb.append(candidate.getEmail()).append(",");
        });

        String taskName = delegateTask.getName();
        ExecutionEntity pi = (ExecutionEntity)runtimeService.createProcessInstanceQuery().processInstanceId(delegateTask.getProcessInstanceId()).singleResult();
        String processName = pi.getProcessDefinition().getName();
        String content = MessageFormat.format(NEW_TASK_CONTENT, sender, processName, taskName);
        if(sb.length()>0)
            sendMail(from, sb.toString().split(","), content, NEW_TASK_TITLE, delegateTask.getTenantId());
    }

    @Override
    public void sendNotification(String processInstanceId, String taskId, String buzzId) throws BasalException{
        User user = activitiService.getCreator(processInstanceId);
        if(user==null || StringUtils.isEmpty(user.getEmail()))
            throw new BasalException(BasalException.ERROR, "未能找到流程启动者邮箱");
        String from = user.getEmail();
        String sender = user.getDisplayName();

        StringBuilder sb = new StringBuilder();
        user = activitiService.getAssignee(taskId);
        if(user!=null && StringUtils.isNotBlank(user.getEmail())){
            sb.append(user.getEmail()).append(",");
        }

        List<User> candidateUsers = activitiService.getCandidate(taskId);
        candidateUsers.forEach(candidate -> {
            if(StringUtils.isNotBlank(candidate.getEmail()))
                sb.append(candidate.getEmail()).append(",");
        });
        Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
        String taskName = task.getName();
        //ExecutionEntity pi = (ExecutionEntity)runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        //String processName = pi.getProcessDefinition().getName();
        String processName;
        if(task.getProcessDefinitionId() != null && !task.getProcessDefinitionId().isEmpty()){
            processName = task.getProcessDefinitionId().split(":")[0];
        }else{
        	processName = "{未能成功获取流程名称}";
        }
        
        if(taskName == null || taskName.isEmpty()){
        	taskName = "{未设置任务名称}";
        }

        String content = MessageFormat.format(DELAY_TASK_CONTENT, sender, processName, taskName);        
        
        if(sb.length()>0)
            sendMail(from, sb.toString().split(","), content, DELAY_TASK_TITLE, task.getTenantId());
    }

    private void sendMail(String from, String[] tos, String content, String title, String tenantId) throws BasalException{
        try{
            HtmlEmail email = new HtmlEmail();
            email.setTextMsg(content);
            email.setFrom(from);
            email.setSubject(title);
            setMailServerProperties(email, tenantId);

            for(String to: tos){
                if(StringUtils.isNotEmpty(to))
                    email.addTo(to);
            }
            email.send();
        }catch(EmailException e){
            throw new BasalException(3, "发送邮件失败", e);
        }
    }

    protected void setMailServerProperties(Email email, String tenantId) {

        boolean isMailServerSet = false;
        if (tenantId != null && tenantId.length() > 0) {
            if (processEngineConfiguration.getMailSessionJndi(tenantId) != null) {
                setEmailSession(email, processEngineConfiguration.getMailSessionJndi(tenantId));
                isMailServerSet = true;

            } else if (processEngineConfiguration.getMailServer(tenantId) != null) {
                MailServerInfo mailServerInfo = processEngineConfiguration.getMailServer(tenantId);
                String host = mailServerInfo.getMailServerHost();
                if (host == null) {
                    throw new ActivitiException("Could not send email: no SMTP host is configured for tenantId " + tenantId);
                }
                email.setHostName(host);

                email.setSmtpPort(mailServerInfo.getMailServerPort());

                email.setSSLOnConnect(mailServerInfo.isMailServerUseSSL());
                email.setStartTLSEnabled(mailServerInfo.isMailServerUseTLS());

                String user = mailServerInfo.getMailServerUsername();
                String password = mailServerInfo.getMailServerPassword();
                if (user != null && password != null) {
                    email.setAuthentication(user, password);
                }

                isMailServerSet = true;
            }
        }

        if (!isMailServerSet) {
            String mailSessionJndi = processEngineConfiguration.getMailSessionJndi();
            if (mailSessionJndi != null) {
                setEmailSession(email, mailSessionJndi);

            } else {
                String host = processEngineConfiguration.getMailServerHost();
                if (host == null) {
                    throw new ActivitiException("Could not send email: no SMTP host is configured");
                }
                email.setHostName(host);

                int port = processEngineConfiguration.getMailServerPort();
                email.setSmtpPort(port);

                email.setSSLOnConnect(processEngineConfiguration.getMailServerUseSSL());
                email.setStartTLSEnabled(processEngineConfiguration.getMailServerUseTLS());

                String user = processEngineConfiguration.getMailServerUsername();
                String password = processEngineConfiguration.getMailServerPassword();
                if (user != null && password != null) {
                    email.setAuthentication(user, password);
                }
            }
        }
    }

    protected void setEmailSession(Email email, String mailSessionJndi) {
        try {
            email.setMailSessionFromJNDI(mailSessionJndi);
        } catch (NamingException e) {
            throw new ActivitiException("Could not send email: Incorrect JNDI configuration", e);
        }
    }
}
