/**
 * Copyright 2013 hongxin 
 * Change Revision
 * ---------------------------------------------------------------
 * Date               Author            Remarks
 * 2013-5-13          YuWeitao          create
 * ---------------------------------------------------------------
 */
package com.jshx.activiti.service.identity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.jshx.core.base.vo.Pagination;
import org.activiti.engine.identity.Group;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.UserQueryImpl;
import org.activiti.engine.impl.persistence.entity.IdentityInfoEntity;
import org.activiti.engine.impl.persistence.entity.UserEntity;
import org.activiti.engine.impl.persistence.entity.UserEntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;

import com.jshx.activiti.util.ActivitiUtils;
import com.jshx.core.exception.BasalException;
import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.entity.UserRole;
import com.jshx.module.admin.service.UserRoleService;
import com.jshx.module.admin.service.UserService;

/**  
 * 自定义Activiti用户管理类
 * 
 * @author   YuWeitao
 * @version  创建时间：2013-5-13  15:32:01
 * 
 */
@Service  
public class CustomUserEntityManager extends UserEntityManager {   
    
    @Autowired
    private UserService userService;
    
    @Autowired
    private UserRoleService userRoleService;

    @Override
    public UserEntity findUserById(final String userName) {
        if (userName == null)
            return null;   
  
        try {
            User user = userService.findUserByLoginId(userName);
            UserEntity userEntity = ActivitiUtils.toActivitiUser(user);
            return userEntity;   
        } catch (Exception e) {   
        	BasalException be = new BasalException(BasalException.ERROR,e);
			throw be;
        }   
    }   
  
    @Override  
    public List<Group> findGroupsByUser(final String userName) {
        if (userName == null)
            return null;
        User user = userService.findUserByLoginId(userName);
    	Map<String, Object> paraMap = new HashMap<String, Object>();
    	paraMap.put("userId", user.getId());
    	List<UserRole> userRoleList = userRoleService.findUserRole(paraMap);
        List<Group> gs = ActivitiUtils.toActivitiGroups(userRoleList, user.getDeptCode());
        return gs;   
    }   
  
    @Override  
    public List<org.activiti.engine.identity.User> findUserByQueryCriteria(UserQueryImpl query, Page page) {
        int pageNumb, pageSize;
        pageNumb = page.getFirstResult()/page.getMaxResults()+1;
        pageSize = page.getMaxResults();
        Map<String, Object> map = new HashMap<>();
        if(query.getFullNameLike()!=null){
            map.put("name", query.getFullNameLike());
        }
        Pagination pagination = new Pagination(pageNumb, pageSize);
        pagination = userService.findUserByPage(pagination, map);
        List<org.activiti.engine.identity.User> userEntityList = new ArrayList<org.activiti.engine.identity.User>();

        List<User> userList = pagination.getListOfObject();
        if(userList!=null){
            for(User user: userList){
                UserEntity userEntity = ActivitiUtils.toActivitiUser(user);
                userEntityList.add(userEntity);
            }
        }
        return userEntityList;
    }   
  
    @Override  
    public IdentityInfoEntity findUserInfoByUserIdAndKey(String userId,   
            String key) {
        throw new RuntimeException("not implement method.");
    }   
  
    @Override  
    public List<String> findUserInfoKeysByUserIdAndType(String userId,   
            String type) {   
        throw new RuntimeException("not implement method.");   
    }   
  
    @Override  
    public long findUserCountByQueryCriteria(UserQueryImpl query) {
        Map<String, Object> map = new HashMap<>();
        if(query.getFullNameLike()!=null){
            map.put("name", query.getFullNameLike());
        }
        return userService.countUser(map);
    }

    @Override
    public List<org.activiti.engine.identity.User> findPotentialStarterUsers(String proceDefId) {
        throw new RuntimeException("not implement method.");
    }
}
