package com.jshx.activiti.freeflow;

import java.util.List;

import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.RuntimeServiceImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.task.Task;
import com.jshx.activiti.freeflow.command.DeleteExecutionTaskCmd;
import com.jshx.activiti.freeflow.command.DeleteRunningTaskCmd;
import com.jshx.activiti.freeflow.command.StartActivityCmd;

/**
 * 自由流之回退、跳转具体实现
 * 
 */
public class FreeFlowService{

	private String processInstanceId;
	
	private TaskService taskService;
	
	private RepositoryService repositoryService;
	
	private RuntimeService runtimeService;
	
	/**
	 * 构造函数
	 * 
	 * 
	 * @param processId
	 *           
	 * @param processEngine
	 * 
	 */
	public FreeFlowService(ProcessEngine processEngine,String processId)
	{
		processInstanceId = processId;
		taskService = processEngine.getTaskService();
		repositoryService = processEngine.getRepositoryService();
		runtimeService = processEngine.getRuntimeService();
	}
	/**          
	 * 命令执行
	 * @param command 需要执行的命令
	 */
	public void executeCommand(Command<java.lang.Void> command)
	{
		((RuntimeServiceImpl) runtimeService).getCommandExecutor().execute(command);
	}

	private TaskEntity getCurrentTask()
	{				
		List<Task> ac = taskService.createTaskQuery().processInstanceId(processInstanceId).active().list();
		return (TaskEntity)ac.get(0);
	}

	private TaskEntity getTaskById(String taskId)
	{
		return (TaskEntity) taskService.createTaskQuery().taskId(taskId).singleResult();
	}
	/**
	 *  系统自己判断当前活动节点         
	 * 
	 */
	public void moveBack() throws Exception
	{
		moveBack(getCurrentTask());
	}
	/**
	 * @param taskId 当前任务id
	 *           
	 * 
	 */
	public void moveBack(String taskId) throws Exception
	{
		moveBack(getTaskById(taskId));
	}
	
	/**
	 * 回退
	 * 
	 * @Author yangshunqing
	 * @param currentTaskEntity 当前任务
	 */
	public void moveBack(TaskEntity currentTaskEntity) throws Exception
	{			
		List<Task> ac = taskService.createTaskQuery().processInstanceId(processInstanceId).active().list();
		int forknum = ac.size();
		//获取上一步活动
		ActivityImpl activity = (ActivityImpl) getActivity(currentTaskEntity).getIncomingTransitions().get(0).getSource();

		String activityBehavior = activity.getActivityBehavior().toString();

		moveTo(currentTaskEntity, activity);
		
		//针对网关内某个支路包含多个串行任务的情况
//		if(activityBehavior.contains("Gateway")){
//			ActivityImpl nextActivity = (ActivityImpl) getActivity(currentTaskEntity).getOutgoingTransitions().get(0).getDestination();
//			String nextActivityBehavior = nextActivity.getActivityBehavior().toString();
//			while(!nextActivityBehavior.contains("Gateway")){
//				if(currentTaskEntity.getTaskDefinitionKey().equals(nextActivity.getId())){
//					moveTo(currentTaskEntity, activity);
//					return;
//				}
//				nextActivity = (ActivityImpl) nextActivity.getOutgoingTransitions().get(0).getDestination();
//				nextActivityBehavior = nextActivity.getActivityBehavior().toString();
//			}
//		}

		
		//以下为支路只有单任务的情况
		//如果为并行网关，则跳转到并行任务的上一个网关处，然后任务会自动跳转到并行任务处
//		if(activityBehavior.contains("InclusiveGateway")||activityBehavior.contains("ParallelGateway")){//并行及包容网关
//
//
//			ActivityImpl lastActivity = (ActivityImpl) activity.getIncomingTransitions().get(0).getSource();
//			//针对并行网关,不能直接moveto
//			if(forknum>1){//由包容网关内跳到网关外
//
//				executeCommand(new StartActivityCmd(currentTaskEntity.getExecutionId(), lastActivity));
//				//一一删除并行分支在act_ru_*表的相关记录
//				for(int m=0;m<forknum;m++){
//					TaskEntity currentTask = (TaskEntity)ac.get(m);
//					executeCommand(new DeleteRunningTaskCmd(currentTask));
//
//					if(!currentTask.getExecutionId().equals(currentTaskEntity.getExecutionId())){
//						executeCommand(new DeleteExecutionTaskCmd(currentTask));//删除act_ru_execution表中的记录
//					}
//				}
//
//
//			}else{//由包容网关外跳到网关内
//				ActivityImpl lastLastActivity = (ActivityImpl) lastActivity.getIncomingTransitions().get(0).getSource();
//				moveTo(currentTaskEntity, lastLastActivity);
//			}
//
//		}else if(activityBehavior.contains("ExclusiveGateway")){//排他网关
//			ActivityImpl lastActivity = (ActivityImpl) activity.getIncomingTransitions().get(0).getSource();
//			//针对排他网关,不能直接moveto
//			if(forknum>1){//网关内多于1个分支的情况
//				executeCommand(new StartActivityCmd(currentTaskEntity.getExecutionId(), lastActivity));
//				//一一删除并行分支在act_ru_*表的相关记录
//				for(int m=0;m<forknum;m++){
//					TaskEntity currentTask = (TaskEntity)ac.get(m);
//					executeCommand(new DeleteRunningTaskCmd(currentTask));
//
//					if(!currentTask.getExecutionId().equals(currentTaskEntity.getExecutionId())){
//						executeCommand(new DeleteExecutionTaskCmd(currentTask));//删除act_ru_execution表中的记录
//					}
//				}
//			}else{//由排他网关外跳到网关内 或是网关内单分支由内跳到外
//				ActivityImpl lastLastActivity = (ActivityImpl) lastActivity.getIncomingTransitions().get(0).getSource();
//				activityBehavior = lastLastActivity.getActivityBehavior().toString();
//				if(!activityBehavior.contains("ExclusiveGateway")){//排他网关由内跳到外
//					moveTo(currentTaskEntity, lastActivity);
//				}else{
//					moveTo(currentTaskEntity, lastLastActivity);
//				}
//			}
//
//		}else{//串行回退
//			moveTo(currentTaskEntity, activity);
//		}
	}

	/**
	 * 
	 * @param currentTaskId
	 *            当前任务ID
	 * @param targetTaskDefinitionKey
	 *            目标任务节点（在模型定义里面的节点名称）
	 * @throws Exception
	 */
	public void moveTo(String currentTaskId, String targetTaskDefinitionKey) throws Exception
	{
		moveTo(getTaskById(currentTaskId), targetTaskDefinitionKey);
	}
	/**
	 * 
	 * @param currentTaskEntity
	 *            当前任务节点
	 * @param targetTaskDefinitionKey
	 *            目标任务节点（在模型定义里面的节点名称）
	 * @throws Exception
	 */
	public void moveTo(TaskEntity currentTaskEntity, String targetTaskDefinitionKey) throws Exception
	{
		ActivityImpl activity = getActivity(currentTaskEntity,targetTaskDefinitionKey);
		moveTo(currentTaskEntity, activity);
	}
	
	private void moveTo(TaskEntity currentTaskEntity, ActivityImpl activity)
	{
		executeCommand(new StartActivityCmd(currentTaskEntity.getExecutionId(), activity));
		executeCommand(new DeleteRunningTaskCmd(currentTaskEntity));
	}
	/**
	 * 
	 *根据当前任务节点获取当前活动
	 *@param task 当前任务节点
	 *            
	 *@return ActivityImpl
	 *            
	 */
	public ActivityImpl getActivity(Task task) throws Exception{
		ProcessDefinitionEntity pde = (ProcessDefinitionEntity) ((RepositoryServiceImpl) repositoryService)
				.getDeployedProcessDefinition(task.getProcessDefinitionId());
		return pde.findActivity(task.getTaskDefinitionKey());
	}
	/**
	 * 
	 *根据当前任务节点获取当前活动
	 *@param task 当前任务节点
	 *
	 *@param targetTaskDefinitionKey 任务自定义id
	 *            
	 *@return ActivityImpl
	 *            
	 */
	public ActivityImpl getActivity(Task task,String targetTaskDefinitionKey) throws Exception{
		ProcessDefinitionEntity pde = (ProcessDefinitionEntity) ((RepositoryServiceImpl) repositoryService)
				.getDeployedProcessDefinition(task.getProcessDefinitionId());
		return pde.findActivity(targetTaskDefinitionKey);
	}
}
