package com.jshx.activiti.entity;

import java.sql.Blob;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import com.jshx.core.base.entity.BaseModel;


/**
 * 实体类模板（目前仅适配MS-SQLServer数据库）
 * @author
 *
 */
@SuppressWarnings("serial")
@Entity
@Table(name="AUTO_DEPUTE")
public class AutoDepute extends BaseModel
{
	/**
	 * 部门代码
	 */
	private String deptId;

	/**
	 * 删除标记
	 */
	private Integer delFlag;

	
	/**
	 * 委托人
	 */
	private String assignee;

	/**
	 * 受托人
	 */
	private String deputy;

	/**
	 * 开始时间
	 */
	private Date startTime;

	/**
	 * 结束时间
	 */
	private Date endDate;

	/**
	 * 流程定义
	 */
	private String processDefinitionId;

	/**
	 * 状态
	 */
	private Long deputeStatus;

	
	public AutoDepute(){
	}
	
	public AutoDepute(String id, String assignee, String deputy, Date startTime, Date endDate, String processDefinitionId, Long deputeStatus){
this.id = id;

this.assignee = assignee;

this.deputy = deputy;

this.startTime = startTime;

this.endDate = endDate;

this.processDefinitionId = processDefinitionId;

this.deputeStatus = deputeStatus;
}


	@Column
	public String getDeptId()
	{
		return deptId;
	}

	public void setDeptId(String deptId)
	{
		this.deptId = deptId;
	}

	@Column
	public Integer getDelFlag()
	{
		return delFlag;
	}

	public void setDelFlag(Integer delFlag)
	{
		this.delFlag = delFlag;
	}

	
	@Column(name="ASSIGNEE")
	public String getAssignee()
	{
		return this.assignee;
	}

	public void setAssignee(String assignee)
	{
		this.assignee = assignee;
	}

	@Column(name="DEPUTY")
	public String getDeputy()
	{
		return this.deputy;
	}

	public void setDeputy(String deputy)
	{
		this.deputy = deputy;
	}

	@Column(name="START_TIME")
	public Date getStartTime()
	{
		return this.startTime;
	}

	public void setStartTime(Date startTime)
	{
		this.startTime = startTime;
	}

	@Column(name="END_DATE")
	public Date getEndDate()
	{
		return this.endDate;
	}

	public void setEndDate(Date endDate)
	{
		this.endDate = endDate;
	}

	@Column(name="PROCESS_DEFINITION_ID")
	public String getProcessDefinitionId()
	{
		return this.processDefinitionId;
	}

	public void setProcessDefinitionId(String processDefinitionId)
	{
		this.processDefinitionId = processDefinitionId;
	}

	@Column(name="DEPUTE_STATUS")
	public Long getDeputeStatus()
	{
		return this.deputeStatus;
	}

	public void setDeputeStatus(Long deputeStatus)
	{
		this.deputeStatus = deputeStatus;
	}

}
