package com.jshx.activiti.entity;

import java.sql.Blob;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

import com.jshx.core.base.entity.BaseModel;


/**
 * 实体类模板（目前仅适配MS-SQLServer数据库）
 *
 * @author
 */
@SuppressWarnings("serial")
@Entity
@Table(name = "ACTIVITI_OPER_LOG")
public class ActivitiOperLog extends BaseModel {
    /**
     * 部门代码
     */
    private String deptId;

    /**
     * 删除标记
     */
    private Integer delFlag;


    /**
     * 任务ID
     */
    private String taskid;

    /**
     * 任务名称
     */
    private String taskname;

    /**
     * 流程实例ID
     */
    private String processinstanceid;

    /**
     * 流程实例名称
     */
    private String processinstancename;

    /**
     * 操作类型
     */
    private String opertype;

    /**
     * 操作人
     */
    private String operuser;

    /**
     * 备注
     */
    private String remark;


    public ActivitiOperLog() {
    }

    public ActivitiOperLog(String id, String taskid, String taskname, String processinstanceid, String processinstancename, String opertype, String operuser, String remark) {
        this.id = id;

        this.taskid = taskid;

        this.taskname = taskname;

        this.processinstanceid = processinstanceid;

        this.processinstancename = processinstancename;

        this.opertype = opertype;

        this.operuser = operuser;

        this.remark = remark;

    }


    @Column
    public String getDeptId() {
        return deptId;
    }

    public void setDeptId(String deptId) {
        this.deptId = deptId;
    }

    @Column
    public Integer getDelFlag() {
        return delFlag;
    }

    public void setDelFlag(Integer delFlag) {
        this.delFlag = delFlag;
    }


    @Column(name = "TASKID")
    public String getTaskid() {
        return this.taskid;
    }

    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }

    @Column(name = "TASKNAME")
    public String getTaskname() {
        return this.taskname;
    }

    public void setTaskname(String taskname) {
        this.taskname = taskname;
    }

    @Column(name = "PROCESSINSTANCEID")
    public String getProcessinstanceid() {
        return this.processinstanceid;
    }

    public void setProcessinstanceid(String processinstanceid) {
        this.processinstanceid = processinstanceid;
    }

    @Column(name = "PROCESSINSTANCENAME")
    public String getProcessinstancename() {
        return this.processinstancename;
    }

    public void setProcessinstancename(String processinstancename) {
        this.processinstancename = processinstancename;
    }

    @Column(name = "OPERTYPE")
    public String getOpertype() {
        return this.opertype;
    }

    public void setOpertype(String opertype) {
        this.opertype = opertype;
    }

    @Column(name = "OPERUSER")
    public String getOperuser() {
        return this.operuser;
    }

    public void setOperuser(String operuser) {
        this.operuser = operuser;
    }

    @Column(name = "REMARK")
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
