package com.jshx.activiti.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.activiti.entity.AutoDepute;
import com.jshx.activiti.dao.AutoDeputeDao;

@Component("autoDeputeDao")
public class AutoDeputeDaoImpl extends BaseDaoImpl implements AutoDeputeDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findAutoDeputeByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findAutoDepute(Map<String, Object> paraMap){
		return this.findListByHqlId("findAutoDeputeByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public AutoDepute getById(String id)
	{
		return (AutoDepute)this.getObjectById(AutoDepute.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(AutoDepute autoDepute)
	{
		autoDepute.setId(null);
		this.saveOrUpdateObject(autoDepute);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(AutoDepute autoDepute)
	{
		this.saveOrUpdateObject(autoDepute);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(AutoDepute.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		AutoDepute autoDepute = (AutoDepute)this.getObjectById(AutoDepute.class, id);
		autoDepute.setDelFlag(1);
		this.saveObject(autoDepute);
	}
}
