package com.jshx.activiti.cmd;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.impl.cmd.GetBpmnModelCmd;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.image.impl.DefaultProcessDiagramGenerator;


public class ProcessInstanceDiagramCmd implements Command<InputStream> {
    protected String processDefinitionId;

    public ProcessInstanceDiagramCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }
    
    @Override
    public InputStream execute(CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = commandContext
            .getExecutionEntityManager();
        ExecutionEntity executionEntity = executionEntityManager
            .findExecutionById(processDefinitionId);
        List<String> highlightflows = new ArrayList<>();
        List<String> activiityIds = new ArrayList<>();
        if(executionEntity != null){
        	  activiityIds = executionEntity.findActiveActivityIds();
        	  processDefinitionId = executionEntity.getProcessDefinitionId();
        }

        GetBpmnModelCmd getBpmnModelCmd = new GetBpmnModelCmd(
                processDefinitionId);
        BpmnModel bpmnModel = getBpmnModelCmd.execute(commandContext);

        return new DefaultProcessDiagramGenerator().generateDiagram(bpmnModel, "png", activiityIds, highlightflows,  commandContext.getProcessEngineConfiguration().getActivityFontName(),
        		commandContext.getProcessEngineConfiguration().getLabelFontName(), commandContext.getProcessEngineConfiguration().getClassLoader(), 1.0);

    }
}
