/**
 * @license Angular UI Tree v2.15.0
 * (c) 2010-2016. https://github.com/angular-ui-tree/angular-ui-tree
 * License: MIT
 */
!function(){"use strict";angular.module("ui.tree",[]).constant("treeConfig",{treeClass:"angular-ui-tree",emptyTreeClass:"angular-ui-tree-empty",hiddenClass:"angular-ui-tree-hidden",nodesClass:"angular-ui-tree-nodes",nodeClass:"angular-ui-tree-node",handleClass:"angular-ui-tree-handle",placeholderClass:"angular-ui-tree-placeholder",dragClass:"angular-ui-tree-drag",dragThreshold:3,levelThreshold:30,defaultCollapsed:!1})}(),function(){"use strict";angular.module("ui.tree").controller("TreeHandleController",["$scope","$element",function(e,n){this.scope=e,e.$element=n,e.$nodeScope=null,e.$type="uiTreeHandle"}])}(),function(){"use strict";angular.module("ui.tree").controller("TreeNodeController",["$scope","$element",function(e,n){function t(e){var n,o,l,r=0,a=e.childNodes();if(!a||0===a.length)return 0;for(l=a.length-1;l>=0;l--)n=a[l],o=1+t(n),r=Math.max(r,o);return r}this.scope=e,e.$element=n,e.$modelValue=null,e.$parentNodeScope=null,e.$childNodesScope=null,e.$parentNodesScope=null,e.$treeScope=null,e.$handleScope=null,e.$type="uiTreeNode",e.$$allowNodeDrop=!1,e.collapsed=!1,e.init=function(t){var o=t[0];e.$treeScope=t[1]?t[1].scope:null,e.$parentNodeScope=o.scope.$nodeScope,e.$modelValue=o.scope.$modelValue[e.$index],e.$parentNodesScope=o.scope,o.scope.initSubNode(e),n.on("$destroy",function(){o.scope.destroySubNode(e)})},e.index=function(){return e.$parentNodesScope.$modelValue.indexOf(e.$modelValue)},e.dragEnabled=function(){return!(e.$treeScope&&!e.$treeScope.dragEnabled)},e.isSibling=function(n){return e.$parentNodesScope==n.$parentNodesScope},e.isChild=function(n){var t=e.childNodes();return t&&t.indexOf(n)>-1},e.prev=function(){var n=e.index();return n>0?e.siblings()[n-1]:null},e.siblings=function(){return e.$parentNodesScope.childNodes()},e.childNodesCount=function(){return e.childNodes()?e.childNodes().length:0},e.hasChild=function(){return e.childNodesCount()>0},e.childNodes=function(){return e.$childNodesScope&&e.$childNodesScope.$modelValue?e.$childNodesScope.childNodes():null},e.accept=function(n,t){return e.$childNodesScope&&e.$childNodesScope.$modelValue&&e.$childNodesScope.accept(n,t)},e.remove=function(){return e.$parentNodesScope.removeNode(e)},e.toggle=function(){e.collapsed=!e.collapsed},e.collapse=function(){e.collapsed=!0},e.expand=function(){e.collapsed=!1},e.depth=function(){var n=e.$parentNodeScope;return n?n.depth()+1:1},e.maxSubDepth=function(){return e.$childNodesScope?t(e.$childNodesScope):0}}])}(),function(){"use strict";angular.module("ui.tree").controller("TreeNodesController",["$scope","$element",function(e,n){this.scope=e,e.$element=n,e.$modelValue=null,e.$nodeScope=null,e.$treeScope=null,e.$type="uiTreeNodes",e.$nodesMap={},e.nodropEnabled=!1,e.maxDepth=0,e.cloneEnabled=!1,e.initSubNode=function(n){return n.$modelValue?void(e.$nodesMap[n.$modelValue.$$hashKey]=n):null},e.destroySubNode=function(n){return n.$modelValue?void(e.$nodesMap[n.$modelValue.$$hashKey]=null):null},e.accept=function(n,t){return e.$treeScope.$callbacks.accept(n,e,t)},e.beforeDrag=function(n){return e.$treeScope.$callbacks.beforeDrag(n)},e.isParent=function(n){return n.$parentNodesScope==e},e.hasChild=function(){return e.$modelValue.length>0},e.safeApply=function(e){var n=this.$root.$$phase;"$apply"==n||"$digest"==n?e&&"function"==typeof e&&e():this.$apply(e)},e.removeNode=function(n){var t=e.$modelValue.indexOf(n.$modelValue);return t>-1?(e.safeApply(function(){e.$modelValue.splice(t,1)[0]}),e.$treeScope.$callbacks.removed(n)):null},e.insertNode=function(n,t){e.safeApply(function(){e.$modelValue.splice(n,0,t)})},e.childNodes=function(){var n,t=[];if(e.$modelValue)for(n=0;n<e.$modelValue.length;n++)t.push(e.$nodesMap[e.$modelValue[n].$$hashKey]);return t},e.depth=function(){return e.$nodeScope?e.$nodeScope.depth():0},e.outOfDepth=function(n){var t=e.maxDepth||e.$treeScope.maxDepth;return t>0?e.depth()+n.maxSubDepth()+1>t:!1}}])}(),function(){"use strict";angular.module("ui.tree").controller("TreeController",["$scope","$element",function(e,n){this.scope=e,e.$element=n,e.$nodesScope=null,e.$type="uiTree",e.$emptyElm=null,e.$callbacks=null,e.dragEnabled=!0,e.emptyPlaceholderEnabled=!0,e.maxDepth=0,e.dragDelay=0,e.cloneEnabled=!1,e.nodropEnabled=!1,e.isEmpty=function(){return e.$nodesScope&&e.$nodesScope.$modelValue&&0===e.$nodesScope.$modelValue.length},e.place=function(n){e.$nodesScope.$element.append(n),e.$emptyElm.remove()},this.resetEmptyElement=function(){e.$nodesScope.$modelValue&&0!==e.$nodesScope.$modelValue.length||!e.emptyPlaceholderEnabled?e.$emptyElm.remove():n.append(e.$emptyElm)},e.resetEmptyElement=this.resetEmptyElement}])}(),function(){"use strict";angular.module("ui.tree").directive("uiTree",["treeConfig","$window",function(e,n){return{restrict:"A",scope:!0,controller:"TreeController",link:function(t,o,l,r){var a,i,d,c={accept:null,beforeDrag:null},s={};angular.extend(s,e),s.treeClass&&o.addClass(s.treeClass),"table"===o.prop("tagName").toLowerCase()?(t.$emptyElm=angular.element(n.document.createElement("tr")),i=o.find("tr"),d=i.length>0?angular.element(i).children().length:1e6,a=angular.element(n.document.createElement("td")).attr("colspan",d),t.$emptyElm.append(a)):t.$emptyElm=angular.element(n.document.createElement("div")),s.emptyTreeClass&&t.$emptyElm.addClass(s.emptyTreeClass),t.$watch("$nodesScope.$modelValue.length",function(e){angular.isNumber(e)&&r.resetEmptyElement()},!0),t.$watch(l.dragEnabled,function(e){"boolean"==typeof e&&(t.dragEnabled=e)}),t.$watch(l.emptyPlaceholderEnabled,function(e){"boolean"==typeof e&&(t.emptyPlaceholderEnabled=e,r.resetEmptyElement())}),t.$watch(l.nodropEnabled,function(e){"boolean"==typeof e&&(t.nodropEnabled=e)}),t.$watch(l.cloneEnabled,function(e){"boolean"==typeof e&&(t.cloneEnabled=e)}),t.$watch(l.maxDepth,function(e){"number"==typeof e&&(t.maxDepth=e)}),t.$watch(l.dragDelay,function(e){"number"==typeof e&&(t.dragDelay=e)}),c.accept=function(e,n){return!(n.nodropEnabled||n.$treeScope.nodropEnabled||n.outOfDepth(e))},c.beforeDrag=function(){return!0},c.removed=function(){},c.dropped=function(){},c.dragStart=function(){},c.dragMove=function(){},c.dragStop=function(){},c.beforeDrop=function(){},t.$watch(l.uiTree,function(e){angular.forEach(e,function(e,n){c[n]&&"function"==typeof e&&(c[n]=e)}),t.$callbacks=c},!0)}}}])}(),function(){"use strict";angular.module("ui.tree").directive("uiTreeHandle",["treeConfig",function(e){return{require:"^uiTreeNode",restrict:"A",scope:!0,controller:"TreeHandleController",link:function(n,t,o,l){var r={};angular.extend(r,e),r.handleClass&&t.addClass(r.handleClass),n!=l.scope&&(n.$nodeScope=l.scope,l.scope.$handleScope=n)}}}])}(),function(){"use strict";angular.module("ui.tree").directive("uiTreeNode",["treeConfig","UiTreeHelper","$window","$document","$timeout","$q","$rootElement",function(e,n,t,o,l,r,a){return{require:["^uiTreeNodes","^uiTree"],restrict:"A",controller:"TreeNodeController",link:function(i,d,c,s){var u,p,f,m,h,$,g,b,N,y,v,S,E,T,x,C,w,D,X,Y,A,V,H,I,O={},k="ontouchstart"in window,M=null,P=document.body,L=document.documentElement;angular.extend(O,e),O.nodeClass&&d.addClass(O.nodeClass),i.init(s),i.collapsed=!!n.getNodeAttribute(i,"collapsed")||e.defaultCollapsed,i.sourceOnly=i.nodropEnabled||i.$treeScope.nodropEnabled,i.$watch(c.collapsed,function(e){"boolean"==typeof e&&(i.collapsed=e)}),i.$watch("collapsed",function(e){n.setNodeAttribute(i,"collapsed",e),c.$set("collapsed",e)}),i.$on("angular-ui-tree:collapse-all",function(){i.collapsed=!0}),i.$on("angular-ui-tree:expand-all",function(){i.collapsed=!1}),y=function(e){if((k||2!==e.button&&3!==e.which)&&!(e.uiTreeDragging||e.originalEvent&&e.originalEvent.uiTreeDragging)){var l,r,c,s,y,v,S,E,T,x=angular.element(e.target);if(l=n.treeNodeHandlerContainerOfElement(x),l&&(x=angular.element(l)),r=d.clone(),E=n.elementIsTreeNode(x),T=n.elementIsTreeNodeHandle(x),(E||T)&&!(E&&n.elementContainsTreeNodeHandler(x)||(c=x.prop("tagName").toLowerCase(),"input"==c||"textarea"==c||"button"==c||"select"==c))){for(I=angular.element(e.target);I&&I[0]&&I[0]!==d;){if(n.nodrag(I))return;I=I.parent()}i.beforeDrag(i)&&(e.uiTreeDragging=!0,e.originalEvent&&(e.originalEvent.uiTreeDragging=!0),e.preventDefault(),y=n.eventObj(e),u=!0,p=n.dragInfo(i),s=d.prop("tagName"),"tr"===s.toLowerCase()?(m=angular.element(t.document.createElement(s)),v=angular.element(t.document.createElement("td")).addClass(O.placeholderClass).attr("colspan",d[0].children.length),m.append(v)):m=angular.element(t.document.createElement(s)).addClass(O.placeholderClass),h=angular.element(t.document.createElement(s)),O.hiddenClass&&h.addClass(O.hiddenClass),f=n.positionStarted(y,d),m.css("height",n.height(d)+"px"),$=angular.element(t.document.createElement(i.$parentNodesScope.$element.prop("tagName"))).addClass(i.$parentNodesScope.$element.attr("class")).addClass(O.dragClass),$.css("width",n.width(d)+"px"),$.css("z-index",9999),S=(d[0].querySelector(".angular-ui-tree-handle")||d[0]).currentStyle,S&&(document.body.setAttribute("ui-tree-cursor",o.find("body").css("cursor")||""),o.find("body").css({cursor:S.cursor+"!important"})),i.sourceOnly&&m.css("display","none"),d.after(m),d.after(h),$.append(p.isClone()&&i.sourceOnly?r:d),a.append($),$.css({left:y.pageX-f.offsetX+"px",top:y.pageY-f.offsetY+"px"}),g={placeholder:m,dragging:$},X(),i.$apply(function(){i.$treeScope.$callbacks.dragStart(p.eventArgs(g,f))}),b=Math.max(P.scrollHeight,P.offsetHeight,L.clientHeight,L.scrollHeight,L.offsetHeight),N=Math.max(P.scrollWidth,P.offsetWidth,L.clientWidth,L.scrollWidth,L.offsetWidth))}}},v=function(e){var o,l,r,a,d,c,s,h,y,v,S,E,T,x,C,w,D=n.eventObj(e);if($){if(e.preventDefault(),t.getSelection?t.getSelection().removeAllRanges():t.document.selection&&t.document.selection.empty(),r=D.pageX-f.offsetX,a=D.pageY-f.offsetY,0>r&&(r=0),0>a&&(a=0),a+10>b&&(a=b-10),r+10>N&&(r=N-10),$.css({left:r+"px",top:a+"px"}),d=window.pageYOffset||t.document.documentElement.scrollTop,c=d+(window.innerHeight||t.document.clientHeight||t.document.clientHeight),c<D.pageY&&b>=c&&window.scrollBy(0,10),d>D.pageY&&window.scrollBy(0,-10),n.positionMoved(e,f,u),u)return void(u=!1);if(h=n.offset($).left-n.offset(m).left>=O.threshold,y=D.pageX-(t.pageXOffset||t.document.body.scrollLeft||t.document.documentElement.scrollLeft)-(t.document.documentElement.clientLeft||0),v=D.pageY-(t.pageYOffset||t.document.body.scrollTop||t.document.documentElement.scrollTop)-(t.document.documentElement.clientTop||0),angular.isFunction($.hide)?$.hide():(S=$[0].style.display,$[0].style.display="none"),t.document.elementFromPoint(y,v),T=angular.element(t.document.elementFromPoint(y,v)),H=n.treeNodeHandlerContainerOfElement(T),H&&(T=angular.element(H)),angular.isFunction($.show)?$.show():$[0].style.display=S,V=!(n.elementIsTreeNodeHandle(T)||n.elementIsTreeNode(T)||n.elementIsTreeNodes(T)||n.elementIsTree(T)||n.elementIsPlaceholder(T)),V&&(m.remove(),M&&(M.resetEmptyElement(),M=null)),f.dirAx&&f.distAxX>=O.levelThreshold&&(f.distAxX=0,f.distX>0&&(o=p.prev(),o&&!o.collapsed&&o.accept(i,o.childNodesCount())&&(o.$childNodesScope.$element.append(m),p.moveTo(o.$childNodesScope,o.childNodes(),o.childNodesCount()))),f.distX<0&&(l=p.next(),l||(s=p.parentNode(),s&&s.$parentNodesScope.accept(i,s.index()+1)&&(s.$element.after(m),p.moveTo(s.$parentNodesScope,s.siblings(),s.index()+1))))),!f.dirAx){if(n.elementIsTree(T)?E=T.controller("uiTree").scope:n.elementIsTreeNodeHandle(T)?E=T.controller("uiTreeHandle").scope:n.elementIsTreeNode(T)?E=T.controller("uiTreeNode").scope:n.elementIsTreeNodes(T)?E=T.controller("uiTreeNodes").scope:n.elementIsPlaceholder(T)?E=T.controller("uiTreeNodes").scope:T.controller("uiTreeNode")&&(E=T.controller("uiTreeNode").scope),x=!1,!E)return;if(!E.$treeScope||E.$parent.nodropEnabled||E.$treeScope.nodropEnabled||m.css("display",""),"uiTree"==E.$type&&E.dragEnabled&&(x=E.isEmpty()),"uiTreeHandle"==E.$type&&(E=E.$nodeScope),"uiTreeNode"!=E.$type&&!x)return;M&&m.parent()[0]!=M.$element[0]&&(M.resetEmptyElement(),M=null),x?(M=E,E.$nodesScope.accept(i,0)&&(E.place(m),p.moveTo(E.$nodesScope,E.$nodesScope.childNodes(),0))):E.dragEnabled()&&(T=E.$element,C=n.offset(T),w=E.horizontal?D.pageX<C.left+n.width(T)/2:D.pageY<C.top+n.height(T)/2,E.$parentNodesScope.accept(i,E.index())?w?(T[0].parentNode.insertBefore(m[0],T[0]),p.moveTo(E.$parentNodesScope,E.siblings(),E.index())):(T.after(m),p.moveTo(E.$parentNodesScope,E.siblings(),E.index()+1)):!w&&E.accept(i,E.childNodesCount())?(E.$childNodesScope.$element.append(m),p.moveTo(E.$childNodesScope,E.childNodes(),E.childNodesCount())):V=!0)}i.$apply(function(){i.$treeScope.$callbacks.dragMove(p.eventArgs(g,f))})}},S=function(e){var n=p.eventArgs(g,f);e.preventDefault(),Y(),i.$treeScope.$apply(function(){r.when(i.$treeScope.$callbacks.beforeDrop(n)).then(function(e){e!==!1&&i.$$allowNodeDrop&&!V?(p.apply(),i.$treeScope.$callbacks.dropped(n)):D()})["catch"](function(){D()})["finally"](function(){h.replaceWith(i.$element),m.remove(),$&&($.remove(),$=null),i.$treeScope.$callbacks.dragStop(n),i.$$allowNodeDrop=!1,p=null;var e=document.body.getAttribute("ui-tree-cursor");null!==e&&(o.find("body").css({cursor:e}),document.body.removeAttribute("ui-tree-cursor"))})})},E=function(e){i.dragEnabled()&&y(e)},T=function(e){v(e)},x=function(e){i.$$allowNodeDrop=!0,S(e)},C=function(e){S(e)},w=function(){var e;return{exec:function(n,t){t||(t=0),this.cancel(),e=l(n,t)},cancel:function(){l.cancel(e)}}}(),D=function(){d.bind("touchstart mousedown",function(e){w.exec(function(){E(e)},i.dragDelay||0)}),d.bind("touchend touchcancel mouseup",function(){w.cancel()})},D(),X=function(){angular.element(o).bind("touchend",x),angular.element(o).bind("touchcancel",x),angular.element(o).bind("touchmove",T),angular.element(o).bind("mouseup",x),angular.element(o).bind("mousemove",T),angular.element(o).bind("mouseleave",C)},Y=function(){angular.element(o).unbind("touchend",x),angular.element(o).unbind("touchcancel",x),angular.element(o).unbind("touchmove",T),angular.element(o).unbind("mouseup",x),angular.element(o).unbind("mousemove",T),angular.element(o).unbind("mouseleave",C)},A=function(e){27==e.keyCode&&(i.$$allowNodeDrop=!1,S(e))},angular.element(t.document).bind("keydown",A),i.$on("$destroy",function(){angular.element(t.document).unbind("keydown",A)})}}}])}(),function(){"use strict";angular.module("ui.tree").directive("uiTreeNodes",["treeConfig","$window",function(e){return{require:["ngModel","?^uiTreeNode","^uiTree"],restrict:"A",scope:!0,controller:"TreeNodesController",link:function(n,t,o,l){var r={},a=l[0],i=l[1],d=l[2];angular.extend(r,e),r.nodesClass&&t.addClass(r.nodesClass),i?(i.scope.$childNodesScope=n,n.$nodeScope=i.scope):d.scope.$nodesScope=n,n.$treeScope=d.scope,a&&(a.$render=function(){n.$modelValue=a.$modelValue}),n.$watch(function(){return o.maxDepth},function(e){"number"==typeof e&&(n.maxDepth=e)}),n.$watch(function(){return o.nodropEnabled},function(e){"undefined"!=typeof e&&(n.nodropEnabled=!0)},!0),o.$observe("horizontal",function(e){n.horizontal="undefined"!=typeof e})}}}])}(),function(){"use strict";function e(e,n){if(void 0===n)return null;for(var t=n.parentNode,o=1,l="function"==typeof t.setAttribute&&t.hasAttribute(e)?t:null;t&&"function"==typeof t.setAttribute&&!t.hasAttribute(e);){if(t=t.parentNode,l=t,t===document.documentElement){l=null;break}o++}return l}angular.module("ui.tree").factory("UiTreeHelper",["$document","$window","treeConfig",function(n,t,o){return{nodesData:{},setNodeAttribute:function(e,n,t){if(!e.$modelValue)return null;var o=this.nodesData[e.$modelValue.$$hashKey];o||(o={},this.nodesData[e.$modelValue.$$hashKey]=o),o[n]=t},getNodeAttribute:function(e,n){if(!e.$modelValue)return null;var t=this.nodesData[e.$modelValue.$$hashKey];return t?t[n]:null},nodrag:function(e){return"undefined"!=typeof e.attr("data-nodrag")?"false"!==e.attr("data-nodrag"):!1},eventObj:function(e){var n=e;return void 0!==e.targetTouches?n=e.targetTouches.item(0):void 0!==e.originalEvent&&void 0!==e.originalEvent.targetTouches&&(n=e.originalEvent.targetTouches.item(0)),n},dragInfo:function(e){return{source:e,sourceInfo:{cloneModel:e.$treeScope.cloneEnabled===!0?angular.copy(e.$modelValue):void 0,nodeScope:e,index:e.index(),nodesScope:e.$parentNodesScope},index:e.index(),siblings:e.siblings().slice(0),parent:e.$parentNodesScope,moveTo:function(e,n,t){this.parent=e,this.siblings=n.slice(0);var o=this.siblings.indexOf(this.source);o>-1&&(this.siblings.splice(o,1),this.source.index()<t&&t--),this.siblings.splice(t,0,this.source),this.index=t},parentNode:function(){return this.parent.$nodeScope},prev:function(){return this.index>0?this.siblings[this.index-1]:null},next:function(){return this.index<this.siblings.length-1?this.siblings[this.index+1]:null},isClone:function(){return this.source.$treeScope.cloneEnabled===!0},clonedNode:function(e){return angular.copy(e)},isDirty:function(){return this.source.$parentNodesScope!=this.parent||this.source.index()!=this.index},isForeign:function(){return this.source.$treeScope!==this.parent.$treeScope},eventArgs:function(e,n){return{source:this.sourceInfo,dest:{index:this.index,nodesScope:this.parent},elements:e,pos:n}},apply:function(){var e=this.source.$modelValue;this.parent.nodropEnabled||this.parent.$treeScope.nodropEnabled||this.isDirty()&&(this.isClone()&&this.isForeign()?this.parent.insertNode(this.index,this.sourceInfo.cloneModel):(this.source.remove(),this.parent.insertNode(this.index,e)))}}},height:function(e){return e.prop("scrollHeight")},width:function(e){return e.prop("scrollWidth")},offset:function(e){var o=e[0].getBoundingClientRect();return{width:e.prop("offsetWidth"),height:e.prop("offsetHeight"),top:o.top+(t.pageYOffset||n[0].body.scrollTop||n[0].documentElement.scrollTop),left:o.left+(t.pageXOffset||n[0].body.scrollLeft||n[0].documentElement.scrollLeft)}},positionStarted:function(e,n){var t={},o=e.pageX,l=e.pageY;return e.originalEvent&&e.originalEvent.touches&&e.originalEvent.touches.length>0&&(o=e.originalEvent.touches[0].pageX,l=e.originalEvent.touches[0].pageY),t.offsetX=o-this.offset(n).left,t.offsetY=l-this.offset(n).top,t.startX=t.lastX=o,t.startY=t.lastY=l,t.nowX=t.nowY=t.distX=t.distY=t.dirAx=0,t.dirX=t.dirY=t.lastDirX=t.lastDirY=t.distAxX=t.distAxY=0,t},positionMoved:function(e,n,t){var o,l=e.pageX,r=e.pageY;return e.originalEvent&&e.originalEvent.touches&&e.originalEvent.touches.length>0&&(l=e.originalEvent.touches[0].pageX,r=e.originalEvent.touches[0].pageY),n.lastX=n.nowX,n.lastY=n.nowY,n.nowX=l,n.nowY=r,n.distX=n.nowX-n.lastX,n.distY=n.nowY-n.lastY,n.lastDirX=n.dirX,n.lastDirY=n.dirY,n.dirX=0===n.distX?0:n.distX>0?1:-1,n.dirY=0===n.distY?0:n.distY>0?1:-1,o=Math.abs(n.distX)>Math.abs(n.distY)?1:0,t?(n.dirAx=o,void(n.moving=!0)):(n.dirAx!==o?(n.distAxX=0,n.distAxY=0):(n.distAxX+=Math.abs(n.distX),0!==n.dirX&&n.dirX!==n.lastDirX&&(n.distAxX=0),n.distAxY+=Math.abs(n.distY),0!==n.dirY&&n.dirY!==n.lastDirY&&(n.distAxY=0)),void(n.dirAx=o))},elementIsTreeNode:function(e){return"undefined"!=typeof e.attr("ui-tree-node")},elementIsTreeNodeHandle:function(e){return"undefined"!=typeof e.attr("ui-tree-handle")},elementIsTree:function(e){return"undefined"!=typeof e.attr("ui-tree")},elementIsTreeNodes:function(e){return"undefined"!=typeof e.attr("ui-tree-nodes")},elementIsPlaceholder:function(e){return e.hasClass(o.placeholderClass)},elementContainsTreeNodeHandler:function(e){return e[0].querySelectorAll("[ui-tree-handle]").length>=1},treeNodeHandlerContainerOfElement:function(n){return e("ui-tree-handle",n[0])}}}])}();