var KisBpmEmailPropertyCtrl = [ '$scope', '$modal', function($scope, $modal) {

    var opts = {
        template:  'editor-app/configuration/properties/email-popup.html?version=' + Date.now(),
        scope: $scope
    };

    // Open the dialog
    $modal(opts);
}];

var KisBpmEmailPropertyPopupCtrl = ['$scope', '$rootScope', function($scope, $rootScope) {

    $scope.disabled = false;

    if(!$scope.selectedShape.properties["oryx-executionlisteners"]){
        $scope.selectedShape.properties["oryx-executionlisteners"] = {};
        $scope.selectedShape.properties["oryx-executionlisteners"].executionListeners = [];
    }
    $scope.executionlisteners = $scope.selectedShape.properties["oryx-executionlisteners"].executionListeners;
    if(!$scope.executionlisteners){
        $scope.executionlisteners = {};
    }
    var len = $scope.executionlisteners.length;
    var flag = false;
    for(var j = 0; j < len; j++){
        var taskListener = $scope.executionlisteners[j];
        if(taskListener.className===$rootScope.config.DEFAULT_MAIL_LISTENER){
            flag = true;
            break;
        }
    }

    if(!flag){
        $scope.selectedShape.properties["oryx-executionlisteners"].executionListeners.push({
            event: "start",
            "implementation": $rootScope.config.DEFAULT_MAIL_LISTENER,
            "className": $rootScope.config.DEFAULT_MAIL_LISTENER,
            "expression": "",
            "delegateExpression": ""
        });
    }

    $scope.useApply = function(obj){
        if(!obj.checked){
            $scope.disabled = false;
            jQuery("#from_email_add").val("");
        }else{
            $scope.disabled = true;
            jQuery("#from_email_add").val("${initiatorMail}");
        }
    }

    $scope.save = function() {
        $scope.property.value = jQuery("#from_email_add").val();
        $scope.updatePropertyInModel($scope.property);
        $scope.close();
    };

    $scope.close = function() {
        $scope.property.mode = 'read';
        $scope.$hide();
    };
}];

var KisBpmMultiEmailPropertyCtrl = [ '$scope', '$modal', function($scope, $modal) {

    var opts = {
    	backdrop: 'static',  
        template:  'editor-app/configuration/properties/multi-email-popup.html?version=' + Date.now(),
        scope: $scope
    };

    // Open the dialog
    $modal(opts);
}];

var KisBpmMultiEmailPropertyPopupCtrl = ['$scope', '$rootScope', function($scope, $rootScope) {

    if(!$scope.selectedShape.properties["oryx-executionlisteners"]){
        $scope.selectedShape.properties["oryx-executionlisteners"] = {};
        $scope.selectedShape.properties["oryx-executionlisteners"].executionListeners = [];
    }
    $scope.executionlisteners = $scope.selectedShape.properties["oryx-executionlisteners"].executionListeners;
    if(!$scope.executionlisteners){
        $scope.executionlisteners = {};
    }
    var len = $scope.executionlisteners.length;
    var flag = false;
    for(var j = 0; j < len; j++){
        var taskListener = $scope.executionlisteners[j];
        if(taskListener.className===$rootScope.config.DEFAULT_MAIL_LISTENER){
            flag = true;
            break;
        }
    }

    if(!flag){
        $scope.selectedShape.properties["oryx-executionlisteners"].executionListeners.push({
            event: "start",
            "implementation": $rootScope.config.DEFAULT_MAIL_LISTENER,
            "className": $rootScope.config.DEFAULT_MAIL_LISTENER,
            "expression": "",
            "delegateExpression": ""
        });
    }

    $scope.init = function() {
        var mailAddrs = $scope.property.value.split(",");
        var length = mailAddrs.length;
        for(var i = 0; i < length; i++){
            jQuery("#mail_adds").append(new Option(mailAddrs[i], mailAddrs[i]));
        }
    };

    $scope.useApply = function(obj){
        if(obj.checked){
            jQuery("#mail_adds").append(new Option("${assigneeMail}", "${assigneeMail}"));
        }else{
            jQuery("#mail_adds Option[value='${assigneeMail}']").remove();
        }
    }

    $scope.save = function() {
        $scope.property.value = "";
        var options = jQuery("#mail_adds option");
        for(var i = 0; i < options.length; i++){
            $scope.property.value += options[i].value + ",";
        }
        $scope.property.value = $scope.property.value.substring(0, $scope.property.value.length-1);
        $scope.updatePropertyInModel($scope.property);
        $scope.close();
    };

    $scope.add = function() {

        var val = jQuery("#email_add").val();
        if(jQuery("#mail_adds Option[value='" + val + "']").length===0)
            jQuery("#mail_adds").append(new Option(val, val));
        jQuery("#email_add").val("");
    };

    $scope.close = function() {
        $scope.property.mode = 'read';
        $scope.$hide();
    };

    $scope.removeAdd = function(){
        jQuery("#mail_adds").find("option:selected").remove();
    }

    setTimeout(function(){
        $scope.init();
    }, 300);
}];