<%@page language="java" pageEncoding="UTF-8" isELIgnored="false"%>
<%@include file="/common/header.jsp"%>
<jsp:useBean id="today" class="java.util.GregorianCalendar" />
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>日程安排管理</title>
    <%@include file="/common/jsLib.jsp"%>

	<script>

        function setDefaultStartdate() {
            var currentDate =  formatDateNum2Str(new Date()," 00:00:00");
            // document.getElementById("querySendtimeStart").setAttribute("value",currentDate);
            $('#querySendtimeStart')[0].value = currentDate;
            getStartDateAndEndDate();
        }
        //ie下时间参数必须是'/'，'-’会失败,但是显示‘-’更美观
        function formatDateStr4Show(dateStr)
		{
            var newIEDateStr =  dateStr.replace(/\//g,'\-');;
            return newIEDateStr;
        }
        function formatDateStr4Ie(dateStr)
        {
            var newIEDateStr =  dateStr.replace(/\-/g,'\/');
            return newIEDateStr;
        }

        //按数字自定义排序
        function sort_int(a,b){
            if(a.length > b.length) return 1;
            else if(a.length < b.length) return -1;
            else if(a > b) return 1;
            else return -1;
        }

        // 取得 某日期(nowDate) 所在周的星期几(weekDay)的日期
        function getNextDate(nowDate,weekDay){
            var day = nowDate.getDay();
            day = day == 0 ? 7 :day;
            var time = nowDate.getTime();
            var sub = weekDay-day;
            time+=sub*24*3600000;
            nowDate.setTime(time);
            return nowDate;
        }
        function formatDateNum2Str(obj,str){
            var date =  new Date(obj);
            var y = 1900+date.getYear();
            var m = "0"+(date.getMonth()+1);
            var d = "0"+date.getDate();
            return y+"/"+m.substring(m.length-2,m.length)+"/"+d.substring(d.length-2,d.length)+str;
        }

        window.getStartDateAndEndDate=function getStartDateAndEndDate()
        {
            $(function(){
                // var value=document.getElementById("querySendtimeStart").getAttribute("value");
				var selectQueryDateText =  $('#querySendtimeStart');
				var selectEndDateText =  $('#querySendtimeEnd');
                var value_temp = selectQueryDateText[0].value;
                // console.log(value_temp);
                var value = formatDateStr4Ie(value_temp);
                // console.log(value);
                var selectedDate = new Date(value);
                var selectedDate1 = new Date(value);
                var selectedDate2 = new Date(value);
                // console.log(selectedDate,selectedDate1,selectedDate2);
                var  monday = getNextDate(selectedDate,1);
                var  monday1 = getNextDate(selectedDate1,1);
                var  sunday =  getNextDate(selectedDate2,7);
                // console.log(monday,monday1,sunday);
                monday = formatDateNum2Str(monday," 00:00:00");
                monday1 = formatDateNum2Str(monday1,"");
                // console.log(monday,monday1);
                var monday_Show = formatDateStr4Show(monday1);

                sunday = formatDateNum2Str(sunday," 23:59:59");
                // console.log(monday_Show,sunday);
                selectQueryDateText[0].value = monday_Show;
                sunday = formatDateStr4Show(sunday);
                // console.log(sunday);
                selectEndDateText[0].value = sunday;

                // console.log(monday_Show,sunday);
                // document.getElementById("querySendtimeStart").setAttribute("value",monday);
                document.getElementById("querySendtimeEnd").setAttribute("value",sunday);
            })
        }

        function sort_int(a,b){
            if(a.length > b.length) return 1;
            else if(a.length < b.length) return -1;
            else if(a > b) return 1;
            else return -1;
        }


        function addNew(){
        	var dt=new Date();
            createSimpleWindow("win_schedule1","添加日程安排","${ctx}/jsp/schedule/scheduleInitEdit.action?flag=add&dt="+dt.getTime(),840,400);
        	
        }
        function edit(row_Id){
        	var dt=new Date();
            createSimpleWindow("win_schedule1","修改日程安排","${ctx}/jsp/schedule/scheduleInitEdit.action?flag=mod&schedule1.id="+row_Id+"&dt="+dt.getTime(),700,300);
        	
        }
        function view(row_Id){
        	var dt=new Date();
            createSimpleWindow("win_schedule1","查看日程安排","${ctx}/jsp/schedule/scheduleView.action?schedule1.id="+row_Id+"&dt="+dt.getTime(),700,300);
        	
        }
        function reloadDate(){
            $('#pagination').datagrid('clearSelections');
        	search_schedule();
        }
        function del(){
        	var rows = $('#pagination').datagrid('getSelections');
        	var ids = "";
			for(var i=0;i<rows.length;i++){
				ids += rows[i].id+"|";
			}
			if(rows.length<1){
			    $.messager.alert('提示','至少选择一项删除！');
			}else{
			    $.messager.confirm("删除","确定要删除吗?",function(result){
			        if(result){
		                $.ajax({
		                	url : "scheduleDel.action",
		                	type: 'post',
		                    dataType: 'json',
		                    async : false,
		                    data:{ 
		                    	ids : ids
		                    },
		                    error: function(){
		                    	$.messager.alert('错误','删除时出错！');
		                    },
		                    success: function(data){
		                        if(data.result){
		                        	$.messager.alert('提示','删除成功！');
		                        	search_schedule();
		                        }else{
		                        	$.messager.alert('错误','删除时出错！');
		                        }
		                    }
		                });
			        }
			    });
			}
        }
        function search_schedule(){
        	var queryParams = {
        			"queryYearsDateStart" :$("#querySendtimeStart").val(),
 					"queryYearsDateEnd" :$("#querySendtimeEnd").val()
			};        	
        	$('#pagination').datagrid('options').queryParams = queryParams;
        	$('#pagination').datagrid('clearSelections');
        	$("#pagination").datagrid('load');
        }
        
        $(function(){
            //界面初始化时默认查询当前时间所在周的表数据
            setDefaultStartdate();

        	$('#pagination').datagrid($.extend(window.dg_cm_pp,{
				title:'日程安排列表',
                remoteSort: false,
                sortName:'sequence',
                sortOder:'ASC',
                nowrap:false,
                rownumbers : false,
                pagination:false,
				url:'schedule1Query.action',
				queryParams:{
					"queryYearsDateStart" :$("#querySendtimeStart").val(),
 					"queryYearsDateEnd" :$("#querySendtimeEnd").val()
				},
				columns:[[
                    {field:'week',title:'日期',rowspan:2,width:40,align:"center",
                        styler: function(value,row,index){

                            return'  border-bottom: 1px solid #B7B7B7;';

                        }},
                    {field:'noon',title:'午别',rowspan:2,width:20,align:"center",
                        styler: function(value,row,index){
                            if(value == '下')
                            {
                                return'  border-bottom: 1px solid #B7B7B7;';
                            }
                        }},
                    {title:'起止时间',colspan:2},
                    {field:'remark',title:'工作内容',rowspan:2,width:180,align:"center",
                        styler: function(value,row,index){
                            if(row.flag == '1')
                            {
                                return'  border-bottom: 1px solid #B7B7B7;';
                            }
                        }},
                    {field:'event',title:'参加人员',rowspan:2,width:90,align:"center",
                        styler: function(value,row,index){
                            if(row.flag == '1')
                            {
                                return'  border-bottom: 1px solid #B7B7B7;';
                            }
                        }},
                    {field:'location',title:'地点',rowspan:2,width:60,align:"center",
                        styler: function(value,row,index){
                            if(row.flag == '1')
                            {
                                return'  border-bottom: 1px solid #B7B7B7;';
                            }
                        }},
                    {field:'operator',title:'登记人',rowspan:2,width:30,align:"center",
                        styler: function(value,row,index){
                            if(row.flag == '1')
                            {
                                return'  border-bottom: 1px solid #B7B7B7;';
                            }
                        }},
                    {field:'sequence',title:'序号',rowspan:2,width:80,hidden:true,sortable:true,sorter:sort_int},
                    {field:'flag',title:'标记',rowspan:2,width:20,hidden:true}
                ],[
                    {field:'startdate',title:'开始时间',width:60,align:'center',
                        styler: function(value,row,index){
                            if(row.flag == '1')
                            {
                                return'  border-bottom: 1px solid #B7B7B7;';
                            }
                        }},
                    {field:'enddate',title:'结束时间',width:60,align:'center' ,
                        styler: function(value,row,index){
                            if(row.flag == '1')
                            {
                                return'  border-bottom: 1px solid #B7B7B7;';
                            }
                        }}

                ]],
                onLoadSuccess: function(data) {

                    var rows = $('#pagination').datagrid('getRows');
                    //合并周
                    var lastValue = rows[0]['week'];
                    var begin = 0 ;
                    var count = 1;
                    for (var i = 1; i < rows.length; i++)
                    {
                        if(rows[i]['week'] == lastValue) {
                            count++;
                            if( i == rows.length -1)
                            {
                                $(this).datagrid('mergeCells', {
                                    index: begin,
                                    field: 'week',
                                    rowspan: count
                                });
                            }
                        }
                        else if( count != 1)
                        {
                            $(this).datagrid('mergeCells', {
                                index: begin,
                                field: 'week',
                                rowspan: count
                            });
                            begin = i;
                            lastValue =rows[i]['week'];
                            count = 1;
                        }
                        else
                        {
                            begin = i;
                            lastValue =rows[i]['week'];
                        }
                    }
                    //合并午别
                    var lastValue = rows[0]['noon'];
                    var begin = 0 ;
                    var count = 1;
                    for (var i = 1; i < rows.length; i++)
                    {
                        if(rows[i]['noon'] == lastValue) {
                            count++;
                            if( i == rows.length -1)
                            {
                                $(this).datagrid('mergeCells', {
                                    index: begin,
                                    field: 'noon',
                                    rowspan: count
                                });
                            }
                        }
                        else if( count != 1)
                        {
                            $(this).datagrid('mergeCells', {
                                index: begin,
                                field: 'noon',
                                rowspan: count
                            });
                            begin = i;
                            lastValue =rows[i]['noon'];
                            count = 1;
                        }
                        else
                        {
                            begin = i;
                            lastValue =rows[i]['noon'];
                        }
                    }
                }
// 				toolbar:[{
// 					id:'btnadd',
// 					text:'添加',
// 					iconCls:'icon-add',
// 					handler:function(){
// 						addNew();
// 					}
// 				},{
// 					id:'btncut',
// 					text:'删除',
// 					iconCls:'icon-remove',
// 					handler:function(){
// 						del();
// 					}
// 				}]
			}));
		});

    </script>
</head>
<body>
    <div class="page_content" >
	
	    <div class="box_01 submitdata">
		<div class="inner12px">
			<div class="cell boxBmargin12">
			<table width="100%">
				<tr>
				<th width="15%">时间：</th>
				<td width="35%">
                     <input name="queryYearsDateStart" id="querySendtimeStart" value="" type="text" class="Wdate" class="form_text"  onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})"
                     onchange="getStartDateAndEndDate();"  style="width: 60%"  >

					<span  style="display: none">	<input name="queryYearsDateEnd" id="querySendtimeEnd" value="" type="text" class="Wdate" class="form_text" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',minDate:'#F{$dp.$D(\'querySendtimeStart\')}'})" style="width: 44%" > </span>

</td>
</tr>
	<tr>
		<td colspan="4" align="center">
			<a href="###" class="btn_01" onclick="search_schedule()" >查询<b></b></a>&nbsp;
		</td>
	</tr>
</table>
</div>

<div id="pagination" >
</div>
</div>
</div>
</div>
</body>
</html>
