<%@page language="java" pageEncoding="UTF-8" isELIgnored="false" %>
<%@include file="/common/header.jsp" %>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>自动委托管理</title>
    <%@include file="/common/jsLib.jsp" %>
    <script>

        function addNew() {
            var dt = new Date();
            createSimpleWindow("win_autoDepute", "添加自动委托", "${ctx}/jsp/depute/autoDeputeInitEdit.action?flag=add&dt=" + dt.getTime(), 800, 400);

        }
        function edit(row_Id) {
            var dt = new Date();
            createSimpleWindow("win_autoDepute", "修改自动委托", "${ctx}/jsp/depute/autoDeputeInitEdit.action?flag=mod&autoDepute.id=" + row_Id + "&dt=" + dt.getTime(), 700, 300);

        }
        function view(row_Id) {
            var dt = new Date();
            createSimpleWindow("win_autoDepute", "查看自动委托", "${ctx}/jsp/depute/autoDeputeView.action?autoDepute.id=" + row_Id + "&dt=" + dt.getTime(), 700, 300);

        }
        function reloadDate() {
            $('#pagination').datagrid('clearSelections');
            search_autoDepute();
        }
        function del() {
            var rows = $('#pagination').datagrid('getSelections');
            var ids = "";
            for (var i = 0; i < rows.length; i++) {
                ids += rows[i].id + "|";
            }
            if (rows.length < 1) {
                $.messager.alert('提示', '至少选择一项删除！');
            } else {
                $.messager.confirm("删除", "确定要删除吗?", function (result) {
                    if (result) {
                        $.ajax({
                            url: "autoDeputeDel.action",
                            type: 'post',
                            dataType: 'json',
                            async: false,
                            data: {
                                ids: ids
                            },
                            error: function () {
                                $.messager.alert('错误', '删除时出错！');
                            },
                            success: function (data) {
                                if (data.result) {
                                    $.messager.alert('提示', '删除成功！');
                                    search_autoDepute();
                                } else {
                                    $.messager.alert('错误', '删除时出错！');
                                }
                            }
                        });
                    }
                });
            }
        }
        function search_autoDepute() {
            var queryParams = {
                "autoDepute.assignee": $("#assignee").val(),
                "queryStartTimeStart": $("#queryStartTimeStart").val(),
                "queryStartTimeEnd": $("#queryStartTimeEnd").val(),
                "queryEndDateStart": $("#queryEndDateStart").val(),
                "queryEndDateEnd": $("#queryEndDateEnd").val(),
                "autoDepute.processDefinitionId": $("#processDefinitionId").val(),
                "autoDepute.deputeStatus": $("#deputeStatus").val()
            };
            $('#pagination').datagrid('options').queryParams = queryParams;
            $('#pagination').datagrid('clearSelections');
            $("#pagination").datagrid('load');
        }

        $(function () {
            $('#pagination').datagrid($.extend(window.dg_cm_pp, {
                title: '自动委托列表',
                url: 'autoDeputeQuery.action',
                frozenColumns: [[
                    {field: 'id', checkbox: true}
                ]],
                columns: [[
                    {field: 'assignee', title: '委托人', width: 100},
                    {field: 'deputy', title: '受托人', width: 100},
                    {field: 'startTime', title: '开始时间', width: 100},
                    {field: 'endDate', title: '结束时间', width: 100},
                    {field: 'processDefinitionId', title: '流程定义', width: 100},
                    {field: 'deputeStatus', title: '状态', width: 100},
                    {
                        field: 'op', title: '操作', width: 100, formatter: function (value, rec) {
                        return "<a class='btn_01_mini' onclick=edit('" + rec.id + "')>修改<b></b></a>";
                    }
                    }
                ]],
                toolbar: [{
                    id: 'btnadd',
                    text: '添加',
                    iconCls: 'icon-add',
                    handler: function () {
                        addNew();
                    }
                }, {
                    id: 'btncut',
                    text: '删除',
                    iconCls: 'icon-remove',
                    handler: function () {
                        del();
                    }
                }]
            }));
        });


    </script>
</head>
<body>
<div class="page_content">

    <div class="box_01 submitdata">
        <div class="inner12px">
            <div id="pagination">
            </div>
        </div>
    </div>
</div>
</body>
</html>
